/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.workspaceMonitor;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.MultipleSelectionMessageDialog;
import com.tssap.dtr.client.eclipse.ui.actions.AddFileAction;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.workspaceMonitor.Messages;
import com.tssap.dtr.client.eclipse.workspaceMonitor.MonitorType;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.Team;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ResourceChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$workspaceMonitor$ResourceChangeListener == null ? (class$com$tssap$dtr$client$eclipse$workspaceMonitor$ResourceChangeListener = ResourceChangeListener.class$("com.tssap.dtr.client.eclipse.workspaceMonitor.ResourceChangeListener")) : class$com$tssap$dtr$client$eclipse$workspaceMonitor$ResourceChangeListener));
    public static final QualifiedName MOVED_PROPERTY_NAME = new QualifiedName("com.tssap.dtr.client.eclipse", "_move");
    public static final QualifiedName DELETE_PROPERTY_NAME = new QualifiedName("com.tssap.dtr.client.eclipse", "_delete");
    private List fAddedResources = new ArrayList(1);
    private Set fParentFoldersToRefresh = new HashSet();
    private WorkspaceMonitor fWorkspaceMonitor = WorkspaceMonitor.getInstance();
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$workspaceMonitor$ResourceChangeListener;

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        if (event.getType() != 1) {
            return;
        }
        this.fAddedResources.clear();
        this.fParentFoldersToRefresh.clear();
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this, 0);
        }
        catch (CoreException visitorFailed) {
            Logbook.getErrorChapter().println("Unable to process resource delta.");
            LogUtil.logException((Location)LOCATION, (Throwable)visitorFailed);
            return;
        }
        if (!this.fAddedResources.isEmpty()) {
            this.addResourceToRepository(this.fAddedResources);
        }
        if (!this.fParentFoldersToRefresh.isEmpty()) {
            this.refreshOnParentFolderItem(this.fParentFoldersToRefresh);
        }
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if (resource instanceof IProject && (delta.getFlags() & 0x4000) != 0) {
            return false;
        }
        if (Team.isIgnoredHint((IResource)resource)) {
            return false;
        }
        int kind = delta.getKind();
        if (resource instanceof IContainer && (kind & 2) == 0) {
            return true;
        }
        if ((kind & 1) != 0 && this.fWorkspaceMonitor.isMonitored(resource, MonitorType.ADD)) {
            this.fAddedResources.add(resource);
            this.fParentFoldersToRefresh.add(resource.getParent());
        }
        if ((kind & 2) != 0) {
            this.fParentFoldersToRefresh.add(resource.getParent());
        }
        return true;
    }

    private void refreshOnParentFolderItem(Set removedResources) {
        Iterator iter = removedResources.iterator();
        while (iter.hasNext()) {
            String path;
            IVersionedFileSystemManager vfsManager;
            IVfsFolderItem projectFolderItem;
            IProject project;
            IResource parentFolder = (IResource)iter.next();
            if (parentFolder == null || (project = parentFolder.getProject()) == null || (projectFolderItem = this.getFolderItem((IResource)project)) == null || (vfsManager = projectFolderItem.getVersionedFileSystemManager()) == null || !vfsManager.isFolderItemAvailableFor(path = parentFolder.getLocation().toOSString())) continue;
            try {
                IVfsFolderItem parentFolderItem = vfsManager.getFolderItem(path);
                if (parentFolderItem == null) continue;
                parentFolderItem.asFolder().refreshFolderItems();
            }
            catch (VfsException x) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
    }

    private void addResourceToRepository(List resources) {
        ArrayList<IResource> davFiles = new ArrayList<IResource>();
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            IResource resource = (IResource)i.next();
            boolean moved = false;
            try {
                Object property = resource.getSessionProperty(MOVED_PROPERTY_NAME);
                if (property != null && (moved = Boolean.TRUE.equals(resource.getSessionProperty(MOVED_PROPERTY_NAME)))) {
                    resource.setSessionProperty(MOVED_PROPERTY_NAME, (Object)Boolean.FALSE);
                }
            }
            catch (CoreException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
            if (!this.hasAvailableAction(resource, VfsActionOnFolderItem.CREATE_AND_CHECKOUT) || moved) continue;
            davFiles.add(resource);
        }
        if (!davFiles.isEmpty()) {
            RunnableDialog runableDialog = new RunnableDialog();
            runableDialog.setInput(davFiles);
            Display.getDefault().asyncExec((Runnable)runableDialog);
        }
    }

    private boolean hasAvailableAction(IResource resource, VfsActionOnFolderItem action) {
        IVfsFolderItem folderItem = this.getFolderItem(resource);
        if (folderItem == null) {
            return false;
        }
        VfsActionOnFolderItem[] availableActions = folderItem.getActionsForCurrentState();
        int i = 0;
        while (i < availableActions.length) {
            if (availableActions[i] == action) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IVfsFolderItem getFolderItem(IResource resource) {
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider(resource);
        if (teamProvider != null) {
            return teamProvider.getFolderItem(resource);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AddDialog
    extends MultipleSelectionMessageDialog {
        private boolean p_autoExclude = true;

        public AddDialog(Shell parentShell, String title, String message, int messageType, IVfsFolderItem[] folderItems, IVfsFolderItem[] checkedItems) {
            super(parentShell, title, message, messageType, folderItems, checkedItems);
        }

        protected Control createDialogArea(Composite parent) {
            Composite out = (Composite)super.createDialogArea(parent);
            Button autoExclude = new Button(out, 32);
            autoExclude.setText("Automatically exclude unselected files from workspace monitor");
            autoExclude.setLayoutData((Object)new GridData(1808));
            autoExclude.setSelection(true);
            autoExclude.addSelectionListener((SelectionListener)new SelectionAdapter(this, autoExclude){
                private final /* synthetic */ Button val$autoExclude;
                private final /* synthetic */ AddDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$autoExclude = val$autoExclude;
                }

                public void widgetSelected(SelectionEvent e) {
                    AddDialog.access$202(this.this$1, this.val$autoExclude.getSelection());
                }
            });
            return out;
        }

        public boolean autoExclude() {
            return this.p_autoExclude;
        }

        static /* synthetic */ boolean access$202(AddDialog x0, boolean x1) {
            x0.p_autoExclude = x1;
            return x0.p_autoExclude;
        }
    }

    private class RunnableDialog
    implements Runnable {
        private List p_input;
        static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem;

        private RunnableDialog() {
        }

        public void setInput(List input) {
            this.p_input = input;
        }

        public void run() {
            Shell shell = new Shell(32);
            AddFileAction addAction = new AddFileAction();
            Action dummyAction = new Action(){};
            addAction.selectionChanged((IAction)dummyAction, (ISelection)new StructuredSelection(this.p_input));
            IVfsFolderItem[] folderItems = (IVfsFolderItem[])Util.getArrayFromIterator(addAction.getFolderItemsFromSelectedResources().iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem = RunnableDialog.class$("com.tssap.dtr.client.lib.vfs.IVfsFolderItem")) : class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem);
            AddDialog fDialog = new AddDialog(shell, Messages.getString("ResourceChangeListener.dialog.title"), Messages.getString("ResourceChangeListener.dialog.message"), 0, folderItems, folderItems);
            fDialog.setValidEmptySelection(true);
            if (fDialog.open() == 0) {
                IEditorPart part = BluebirdPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (part == null) {
                    part = BluebirdPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences()[0].getView(true);
                }
                if (fDialog.getReturnedSelection().size() != 0) {
                    addAction.setActivePart((IAction)dummyAction, (IWorkbenchPart)part);
                    addAction.selectionChanged((IAction)dummyAction, (ISelection)new StructuredSelection(fDialog.getReturnedSelection().toArray()));
                    addAction.run((IAction)dummyAction);
                }
                if (fDialog.autoExclude()) {
                    ArrayList<IVfsFolderItem> unselctedItems = new ArrayList<IVfsFolderItem>(Arrays.asList(folderItems));
                    Object[] selected = fDialog.getReturnedSelection().toArray();
                    int i = 0;
                    while (i < selected.length) {
                        unselctedItems.remove(selected[i]);
                        ++i;
                    }
                    if (unselctedItems.size() != 0) {
                        Iterator iter = unselctedItems.iterator();
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        while (iter.hasNext()) {
                            IVfsFolderItem element = (IVfsFolderItem)iter.next();
                            if (!(element instanceof IVfsFile)) continue;
                            IFile workspaceResource = root.getFileForLocation((IPath)new Path(element.getLocalPath()));
                            ResourceChangeListener.this.fWorkspaceMonitor.setMonitorResource((IResource)workspaceResource, false, MonitorType.ADD, 0);
                        }
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

