/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.workspaceMonitor;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.share.SelectActivityPage;
import com.tssap.dtr.client.eclipse.workspaceMonitor.DeleteOptionsPage;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

class DeleteResourceWizard
extends Wizard {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$workspaceMonitor$DeleteResourceWizard == null ? (class$com$tssap$dtr$client$eclipse$workspaceMonitor$DeleteResourceWizard = DeleteResourceWizard.class$("com.tssap.dtr.client.eclipse.workspaceMonitor.DeleteResourceWizard")) : class$com$tssap$dtr$client$eclipse$workspaceMonitor$DeleteResourceWizard));
    private DeleteOptionsPage fDeletePage;
    private SelectActivityPage fActivityPage;
    private boolean fDeleteContents;
    private IResource fSelectedResource;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$workspaceMonitor$DeleteResourceWizard;

    public DeleteResourceWizard(boolean deleteContents, IResource selectedResource) {
        this.fDeleteContents = deleteContents;
        this.fSelectedResource = selectedResource;
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        this.fDeletePage = new DeleteOptionsPage("Actions which should be performed", this.fDeleteContents);
        this.addPage((IWizardPage)this.fDeletePage);
        IVfsFolderItem item = this.getRepositoryResource(this.fSelectedResource);
        this.fActivityPage = new SelectActivityPage(item.asActivityRecordedFolderItem().getWorkspace());
        this.fActivityPage.setMessage("Selected activity will be used to delete resources from the repository.");
        this.addPage((IWizardPage)this.fActivityPage);
    }

    private IVfsFolderItem getRepositoryResource(IResource resource) {
        IVersionedFileSystemManager manager;
        DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider(resource);
        if (provider != null && (manager = provider.getVFSManager()) != null) {
            try {
                return manager.getFolderItem(resource.getLocation().toOSString());
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }
        return null;
    }

    public boolean canFinish() {
        if (!this.fDeletePage.getDeleteFromServer()) {
            return true;
        }
        return super.canFinish();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fDeletePage && !this.fDeletePage.getDeleteFromServer()) {
            return null;
        }
        return super.getNextPage(page);
    }

    public IVfsActivity getActivity() {
        if (this.fActivityPage != null) {
            return this.fActivityPage.getSelectedActivity();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

