/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.workspaceMonitor;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.util.DetailMessageDialog;
import com.tssap.dtr.client.eclipse.workspaceMonitor.MonitorType;
import com.tssap.dtr.client.eclipse.workspaceMonitor.ResourceChangeListener;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.actions.AddAction;
import com.tssap.dtr.client.lib.vfs.actions.DeleteAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsActionManager;
import com.tssap.dtr.client.lib.vfs.actions.UncheckoutAction;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.Team;

public class DAVMoveDeleteHook
implements IMoveDeleteHook {
    private DAVTeamProvider myProvider;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$workspaceMonitor$DAVMoveDeleteHook == null ? (class$com$tssap$dtr$client$eclipse$workspaceMonitor$DAVMoveDeleteHook = DAVMoveDeleteHook.class$("com.tssap.dtr.client.eclipse.workspaceMonitor.DAVMoveDeleteHook")) : class$com$tssap$dtr$client$eclipse$workspaceMonitor$DAVMoveDeleteHook));
    private static final String thisClassName = "DAVMoveDeleteHook";
    private static final String allCases = "*";
    private String traceFilter = Platform.getDebugOption((String)"com.tssap.dtr.client.eclipse/debug/filter");
    private WorkspaceMonitor fWorkspaceMonitor;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$workspaceMonitor$DAVMoveDeleteHook;

    public DAVMoveDeleteHook(DAVTeamProvider provider) {
        this.myProvider = provider;
        this.fWorkspaceMonitor = WorkspaceMonitor.getInstance();
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        boolean sync;
        boolean force;
        this.trace("deleteFile - " + file.toString());
        try {
            if (Boolean.TRUE.equals(file.getSessionProperty(ResourceChangeListener.MOVED_PROPERTY_NAME))) {
                file.setSessionProperty(ResourceChangeListener.MOVED_PROPERTY_NAME, (Object)Boolean.FALSE);
                return true;
            }
        }
        catch (CoreException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return true;
        }
        Iterator iterator = DAVTeamProvider._moveDeleteHookListeners.iterator();
        while (iterator.hasNext()) {
            IMoveDeleteHook hook = (IMoveDeleteHook)iterator.next();
            try {
                boolean done = hook.deleteFile(tree, file, updateFlags, monitor);
                if (!done) continue;
                return true;
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        boolean bl = force = (updateFlags & 1) != 0;
        if (!force && !(sync = tree.isSynchronized((IResource)file, 0)) && file.getLocation().toFile().exists()) {
            String message = file.getFullPath().toOSString() + " is not in sync with local file system.";
            ResourceStatus status = new ResourceStatus(274, file.getFullPath(), message);
            tree.failed((IStatus)status);
            return true;
        }
        IVfsFile toBeProcessed = this.getFileForVFSDelete((IResource)file);
        if (toBeProcessed != null && this.fWorkspaceMonitor.isMonitored((IResource)file, MonitorType.DELETE)) {
            if (this.deleteRepositoryFile(toBeProcessed) && file.exists()) {
                tree.standardDeleteFile(file, updateFlags, monitor);
            }
            return true;
        }
        return false;
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        boolean sync;
        boolean force;
        try {
            if (Boolean.TRUE.equals(folder.getSessionProperty(ResourceChangeListener.MOVED_PROPERTY_NAME))) {
                folder.setSessionProperty(ResourceChangeListener.MOVED_PROPERTY_NAME, (Object)Boolean.FALSE);
                return true;
            }
        }
        catch (CoreException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return true;
        }
        Iterator iterator = DAVTeamProvider._moveDeleteHookListeners.iterator();
        while (iterator.hasNext()) {
            IMoveDeleteHook hook = (IMoveDeleteHook)iterator.next();
            try {
                boolean done = hook.deleteFolder(tree, folder, updateFlags, monitor);
                if (!done) continue;
                return true;
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        boolean deleteContents = true;
        boolean bl = force = (updateFlags & 1) != 0;
        if (!force && !(sync = tree.isSynchronized((IResource)folder, 0)) && folder.getLocation().toFile().exists()) {
            String message = folder.getFullPath().toOSString() + " is not in sync with local file system.";
            ResourceStatus status = new ResourceStatus(274, folder.getFullPath(), message);
            tree.failed((IStatus)status);
            return true;
        }
        if (this.myProvider == null) {
            return false;
        }
        IVfsFolderItem item = this.myProvider.getFolderItem((IResource)folder);
        if (item == null || item.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
            return false;
        }
        final IVfsFolder vfsFolder = item.asFolder();
        if (vfsFolder != null && this.fWorkspaceMonitor.isMonitored((IResource)folder, MonitorType.DELETE)) {
            if (this.isDeleteFolderAllowed(vfsFolder, deleteContents)) {
                try {
                    boolean activityNeeded = this.isSourceActivityNeeded(vfsFolder);
                    if (activityNeeded) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                SelectActivityDialog dialog = new SelectActivityDialog(DAVMoveDeleteHook.this.getShell(), vfsFolder.getWorkspace());
                                if (dialog.open() == 0) {
                                    IVfsActivity activity = dialog.getActivitySelection()[0];
                                    DAVMoveDeleteHook.this.deleteRepositoryFolder(vfsFolder, activity);
                                }
                            }
                        });
                    }
                    tree.standardDeleteFolder(folder, updateFlags, monitor);
                }
                catch (VfsException e1) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e1);
                    return true;
                }
            } else {
                this.showFolderDeleteErrorMessage(vfsFolder);
            }
            return true;
        }
        return false;
    }

    private void deleteRepositoryFolder(IVfsFolder root, IVfsActivity activity) {
        IVfsFolderItem[] items;
        if (root == null) {
            return;
        }
        try {
            items = root.refreshFolderItems();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return;
        }
        IVfsActionManager manager = VfsActionManager.getInstance();
        int i = 0;
        while (i < items.length) {
            if (items[i].getCategory() == VfsFolderItemCategory.FILE) {
                IVfsFile file = items[i].asFile();
                if (!file.hasLocalRemoteNameClash() && !this.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.CREATE_AND_CHECKOUT) && file.getLocationState() != VfsFolderItemLocationState.SERVER_ONLY) {
                    manager.doSynchronously((IVfsAction)new DeleteAction((IVfsActivityRecordedFolderItem)file, activity, null));
                }
            } else if (items[i].getCategory() == VfsFolderItemCategory.FOLDER) {
                this.deleteRepositoryFolder(items[i].asFolder(), activity);
            }
            ++i;
        }
    }

    private boolean isDeleteFolderAllowed(IVfsFolder root, boolean deleteLocally) {
        IVfsFolderItem[] items;
        if (!root.getWorkspace().isModifiable()) {
            return false;
        }
        try {
            items = root.refreshFolderItems();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return false;
        }
        if (this.hasAvailableAction((IVfsFolderItem)root, VfsActionOnFolderItem.UNCHECKOUT)) {
            return false;
        }
        int i = 0;
        while (i < items.length) {
            IVfsFolder folder;
            if (items[i].getCategory() == VfsFolderItemCategory.FILE) {
                IVfsFile file = items[i].asFile();
                if (file.getOpenActivities().length > 0) {
                    return false;
                }
                if (file.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER && deleteLocally) {
                    return false;
                }
            } else if (items[i].getCategory() == VfsFolderItemCategory.FOLDER && !this.isDeleteFolderAllowed(folder = items[i].asFolder(), deleteLocally)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        boolean deleteContents;
        Iterator iterator = DAVTeamProvider._moveDeleteHookListeners.iterator();
        while (iterator.hasNext()) {
            IMoveDeleteHook hook = (IMoveDeleteHook)iterator.next();
            try {
                boolean done = hook.deleteProject(tree, project, updateFlags, monitor);
                if (!done) continue;
                return true;
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        boolean bl = deleteContents = (updateFlags & 4) != 0;
        if (!deleteContents) {
            return false;
        }
        if (this.myProvider == null || this.myProvider.getFolderItem((IResource)project) == null) {
            return false;
        }
        IVfsFolder vfsFolder = this.myProvider.getFolderItem((IResource)project).asFolder();
        try {
            if (vfsFolder.hasCheckedOutFolderItems()) {
                throw new VfsRuntimeException("Delete project is not allowed: There are checked-out resources in subtree.");
            }
        }
        catch (VfsException e) {
            throw new VfsRuntimeException(e.getMessage(), (Throwable)e);
        }
        try {
            vfsFolder.removeFromClient();
        }
        catch (VfsException e) {
            throw new VfsRuntimeException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        Iterator iterator = DAVTeamProvider._moveDeleteHookListeners.iterator();
        while (iterator.hasNext()) {
            IMoveDeleteHook hook = (IMoveDeleteHook)iterator.next();
            try {
                boolean done = hook.moveFile(tree, source, destination, updateFlags, monitor);
                if (!done) continue;
                return true;
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        if (this.fWorkspaceMonitor.isMonitored((IResource)source, MonitorType.MOVE)) {
            IVfsFile vfsFile;
            IVfsFile iVfsFile = vfsFile = this.myProvider.getFolderItem((IResource)source) != null ? this.myProvider.getFolderItem((IResource)source).asFile() : null;
            if (vfsFile != null && vfsFile.getWorkspace().isModifiable()) {
                IVfsFile destinationVfsFile;
                IVfsFile iVfsFile2 = destinationVfsFile = this.myProvider.getFolderItem((IResource)destination) != null ? this.myProvider.getFolderItem((IResource)destination).asFile() : null;
                if (destinationVfsFile == null || !this.isCheckoutForDelete(destinationVfsFile)) {
                    if (!this.prepareFileMove(tree, source, destination, updateFlags, monitor)) {
                        this.revertMoveFile(tree, source, destination, updateFlags, monitor);
                        return true;
                    }
                    if (!this.moveRepositoryFile(tree, source, destination, updateFlags, monitor)) {
                        this.revertMoveFile(tree, source, destination, updateFlags, monitor);
                    } else if (source.exists()) {
                        tree.standardDeleteFile(source, updateFlags, monitor);
                    }
                } else {
                    IVfsActivity activity = destinationVfsFile.getOpenActivities()[0];
                    String message = "Destination file is already check-out for delete in a open activity.\nFile move isn't allowed.";
                    String activityName = "";
                    try {
                        activityName = activity.getDisplayName();
                    }
                    catch (VfsException e) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    }
                    final String detailedMessage = MessageFormat.format("Source file:\n\t{0}\nDestination file:\n\t{1}\nActivity:\n\t{2}", source.getLocation().toOSString(), destination.getLocation().toOSString(), activityName);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            DetailMessageDialog dialog = new DetailMessageDialog(DAVMoveDeleteHook.this.getShell(), "File Move", null, "Destination file is already check-out for delete in a open activity.\nFile move isn't allowed.", detailedMessage, 1, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.SHOW_DETAILS_LABEL}, 0);
                            dialog.setDetailButton(1);
                            dialog.open();
                        }
                    });
                    throw new RuntimeException("Destination file is already check-out for delete in a open activity.\nFile move isn't allowed.");
                }
            }
            return true;
        }
        return false;
    }

    private boolean isCheckoutForDelete(IVfsFile file) {
        return file.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY && !this.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.CHECKOUT_AND_DELETE);
    }

    private boolean prepareFileMove(IResourceTree tree, IFile source, IFile destination, int update, IProgressMonitor monitor) {
        try {
            source.setSessionProperty(ResourceChangeListener.MOVED_PROPERTY_NAME, (Object)Boolean.TRUE);
            tree.standardMoveFile(source, destination, update, monitor);
            destination.copy(source.getFullPath(), true, monitor);
        }
        catch (CoreException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean revertMoveFile(IResourceTree tree, IFile source, IFile destination, int update, IProgressMonitor monitor) {
        try {
            if (source.exists()) {
                tree.standardDeleteFile(source, update, monitor);
            }
            destination.setSessionProperty(ResourceChangeListener.MOVED_PROPERTY_NAME, (Object)Boolean.TRUE);
            tree.standardMoveFile(destination, source, update, monitor);
        }
        catch (CoreException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean moveRepositoryFile(IResourceTree tree, IFile source, IFile destination, int update, IProgressMonitor monitor) {
        IVfsFile destinationFile;
        IVfsFile sourceFile = this.myProvider.getFolderItem((IResource)source) != null ? this.myProvider.getFolderItem((IResource)source).asFile() : null;
        IVfsFile iVfsFile = destinationFile = this.myProvider.getFolderItem((IResource)destination) != null ? this.myProvider.getFolderItem((IResource)destination).asFile() : null;
        if (destinationFile == null || sourceFile == null) {
            return false;
        }
        if (this.hasAvailableAction((IVfsFolderItem)sourceFile, VfsActionOnFolderItem.CREATE_AND_CHECKOUT)) {
            return true;
        }
        if (sourceFile.hasLocalRemoteNameClash()) {
            return true;
        }
        if (sourceFile.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER) {
            this.showFileMoveErrorMessage(sourceFile);
            return false;
        }
        boolean inOneWorkspace = sourceFile.getWorkspace().equals(destinationFile.getWorkspace());
        IVfsActivity sourceActivity = null;
        IVfsActivity[] openActivities = sourceFile.getOpenActivities();
        if (openActivities.length > 0) {
            sourceActivity = openActivities[0];
        }
        String message = inOneWorkspace ? "Select Activity for Moving - " + File.separatorChar + destination.getProjectRelativePath().toOSString() : "Select Activity for Deleting - " + File.separatorChar + destination.getProjectRelativePath().toOSString();
        if (sourceActivity == null) {
            final SelectActivityDialog dialog = new SelectActivityDialog(this.getShell(), sourceFile.getWorkspace(), false, message, null, 0);
            final boolean[] result = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    result[0] = dialog.open() == 0;
                }
            });
            if (result[0]) {
                sourceActivity = dialog.getActivitySelection()[0];
            } else {
                return false;
            }
        }
        IVfsActivity destinationActivity = null;
        if (inOneWorkspace) {
            destinationActivity = sourceActivity;
        } else {
            final SelectActivityDialog dialog = new SelectActivityDialog(this.getShell(), destinationFile.getWorkspace(), false, "Select Activity for Adding - " + File.separatorChar + destination.getProjectRelativePath().toOSString(), null, 0);
            final boolean[] result = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    result[0] = dialog.open() == 0;
                }
            });
            if (result[0]) {
                destinationActivity = dialog.getActivitySelection()[0];
            } else {
                return false;
            }
        }
        this.moveFileInRepository(sourceFile, destinationFile, sourceActivity, destinationActivity);
        return true;
    }

    private boolean hasAvailableAction(IVfsFolderItem item, VfsActionOnFolderItem action) {
        if (item == null) {
            return false;
        }
        item.refreshState();
        VfsActionOnFolderItem[] availableActions = item.getActionsForCurrentState();
        int i = 0;
        while (i < availableActions.length) {
            if (availableActions[i] == action) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        this.trace("moveFolder - " + source.toString() + ", to: " + destination.toString());
        Iterator iterator = DAVTeamProvider._moveDeleteHookListeners.iterator();
        while (iterator.hasNext()) {
            IMoveDeleteHook hook = (IMoveDeleteHook)iterator.next();
            try {
                boolean done = hook.moveFolder(tree, source, destination, updateFlags, monitor);
                if (!done) continue;
                return true;
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        boolean force = (updateFlags & 1) != 0;
        boolean inSync = tree.isSynchronized((IResource)source, 2);
        if (!force && !inSync) {
            String message = source.getFullPath().toString() + " Is out of sync with local file system";
            ResourceStatus status = new ResourceStatus(4, source.getFullPath(), message);
            tree.failed((IStatus)status);
            return true;
        }
        if (this.fWorkspaceMonitor.isMonitored((IResource)source, MonitorType.MOVE)) {
            IVfsFolder vfsFolder;
            IVfsFolder iVfsFolder = vfsFolder = this.myProvider.getFolderItem((IResource)source) != null ? this.myProvider.getFolderItem((IResource)source).asFolder() : null;
            if (vfsFolder == null || vfsFolder.getWorkspace() == null) {
                Logbook.getInfoChapter().println("Moving folder not possible, could not get VFS folder for '" + (source != null ? source.getName() : "?") + "' or could not get workspace.");
                return true;
            }
            if (vfsFolder.getWorkspace().isModifiable()) {
                if (!this.prepareMoveFolder(tree, source, destination, updateFlags, monitor)) {
                    this.revertMoveFolder(tree, source, destination, updateFlags, monitor);
                    return true;
                }
                if (!this.moveRepositoryFolder(tree, source, destination, updateFlags, monitor)) {
                    this.revertMoveFolder(tree, source, destination, updateFlags, monitor);
                }
            }
            return true;
        }
        return false;
    }

    private boolean prepareMoveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        this.setMovePropertyToTree(source, Boolean.TRUE);
        tree.standardMoveFolder(source, destination, updateFlags, monitor);
        try {
            destination.copy(source.getFullPath(), true, monitor);
        }
        catch (CoreException ex) {
            LogUtil.logException((Location)LOCATION, (Throwable)ex);
            return false;
        }
        this.setMovePropertyToTree(destination, Boolean.TRUE);
        return true;
    }

    private boolean revertMoveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        if (source.exists()) {
            tree.standardDeleteFolder(source, updateFlags, monitor);
        }
        this.setMovePropertyToTree(destination, Boolean.TRUE);
        tree.standardMoveFolder(destination, source, updateFlags, monitor);
        return true;
    }

    private boolean hasOutdatedElement(IVfsFolder folder) {
        IVfsFolderItem[] items;
        try {
            items = folder.refreshFolderItems();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return false;
        }
        int i = 0;
        while (i < items.length) {
            IVfsFolder fld;
            IVfsFile file;
            if (items[i].getCategory() == VfsFolderItemCategory.FILE ? (file = items[i].asFile()).getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER : items[i].getCategory() == VfsFolderItemCategory.FOLDER && this.hasOutdatedElement(fld = items[i].asFolder())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean moveRepositoryFolder(IResourceTree tree, IFolder source, final IFolder destination, int updateFlags, IProgressMonitor monitor) {
        boolean[] okPressed;
        IVfsActivity[] activityResult;
        boolean needSourceActivity;
        IVfsActivity destinationActivity = null;
        IVfsActivity sourceActivity = null;
        IVfsFolderItem item = this.myProvider.getFolderItem((IResource)source);
        IVfsFolder sourceFolder = null;
        if (item != null) {
            sourceFolder = item.asFolder();
        }
        if (this.hasOutdatedElement(sourceFolder)) {
            this.showFolderMoveErrorMessage(sourceFolder);
            return false;
        }
        try {
            needSourceActivity = this.isSourceActivityNeeded(sourceFolder);
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return false;
        }
        item = this.myProvider.getFolderItem((IResource)destination);
        IVfsFolder destinationFolder = null;
        if (item != null) {
            destinationFolder = item.asFolder();
        }
        boolean needDestinationActivity = this.isDestinationActivityNeeded(sourceFolder, destinationFolder);
        String message = sourceFolder.getWorkspace().equals(destinationFolder.getWorkspace()) ? "Select Activity for Moving - " + File.separatorChar + source.getProjectRelativePath().toOSString() : "Select Activity for Deleting - " + File.separatorChar + source.getProjectRelativePath().toOSString();
        if (needSourceActivity) {
            activityResult = new IVfsActivity[1];
            okPressed = new boolean[1];
            final IVfsFolder srcFolder = sourceFolder;
            final String msg = message;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    SelectActivityDialog dialog = new SelectActivityDialog(DAVMoveDeleteHook.this.getShell(), srcFolder.getWorkspace(), false, msg, null, 0);
                    if (dialog.open() == 0) {
                        activityResult[0] = dialog.getActivitySelection()[0];
                        okPressed[0] = true;
                    } else {
                        okPressed[0] = false;
                    }
                }
            });
            sourceActivity = activityResult[0];
            if (!okPressed[0]) {
                return false;
            }
        } else {
            sourceActivity = this.getSourceActivity(sourceFolder);
        }
        if (needDestinationActivity) {
            activityResult = new IVfsActivity[1];
            okPressed = new boolean[1];
            final IVfsFolder dstFolder = destinationFolder;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    SelectActivityDialog dialog = new SelectActivityDialog(DAVMoveDeleteHook.this.getShell(), dstFolder.getWorkspace(), false, "Select Activity for Adding - " + File.separatorChar + destination.getProjectRelativePath().toOSString(), null, 0);
                    if (dialog.open() == 0) {
                        activityResult[0] = dialog.getActivitySelection()[0];
                        okPressed[0] = true;
                    } else {
                        okPressed[0] = false;
                    }
                }
            });
            destinationActivity = activityResult[0];
            if (!okPressed[0]) {
                return false;
            }
        } else {
            destinationActivity = sourceActivity;
        }
        try {
            int elements = this.getFileCountInTree(source);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, elements);
            String monitorMessage = "Performing repository actions...";
            subMonitor.beginTask(monitorMessage, elements);
            if (this.moveRepositoryTree(sourceFolder, destinationFolder, sourceActivity, destinationActivity, (IProgressMonitor)subMonitor, 0)) {
                if (source.exists()) {
                    this.deleteFilesInTree(tree, source, updateFlags, monitor);
                }
            } else {
                return false;
            }
            subMonitor.done();
        }
        catch (Throwable e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return false;
        }
        return true;
    }

    private void deleteFilesInTree(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        IResource[] members;
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return;
        }
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof IFile) {
                tree.standardDeleteFile((IFile)members[i], updateFlags, monitor);
            }
            if (members[i] instanceof IFolder) {
                this.deleteFilesInTree(tree, (IFolder)members[i], updateFlags, monitor);
            }
            ++i;
        }
    }

    private int getFileCountInTree(IFolder folder) {
        IResource[] members;
        int items = 0;
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return items;
        }
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof IFile) {
                ++items;
            }
            if (members[i] instanceof IFolder) {
                items += this.getFileCountInTree((IFolder)members[i]);
            }
            ++i;
        }
        return items;
    }

    private IVfsActivity getSourceActivity(IVfsFolder item) {
        IVfsFolderItem[] items;
        try {
            items = item.refreshFolderItems();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
        int i = 0;
        while (i < items.length) {
            IVfsFile file;
            IVfsActivity[] act;
            if (items[i].getCategory() == VfsFolderItemCategory.FILE && (act = (file = items[i].asFile()).getOpenActivities()).length > 0) {
                return act[0];
            }
            ++i;
        }
        return null;
    }

    private boolean moveRepositoryTree(IVfsFolder source, IVfsFolder destination, IVfsActivity sourceActivity, IVfsActivity destinationActivity, IProgressMonitor monitor, int worked) {
        IVfsFolderItem[] items;
        boolean result = true;
        try {
            items = source.refreshFolderItems();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return false;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i].getCategory() == VfsFolderItemCategory.FILE) {
                IVfsFile srcFile = items[i].asFile();
                IVfsFile destFile = this.findCorrespondingDestinationFile(srcFile, destination);
                this.moveFileInRepository(srcFile, destFile, sourceActivity, destinationActivity);
                monitor.worked(++worked);
                result = true;
            } else if (items[i].getCategory() == VfsFolderItemCategory.FOLDER) {
                IVfsFolder dest = this.findCorrespondingDestinationNode(items[i].asFolder(), destination);
                result = this.moveRepositoryTree(items[i].asFolder(), dest, sourceActivity, destinationActivity, monitor, worked);
            }
            ++i;
        }
        return result;
    }

    private void moveFileInRepository(IVfsFile source, IVfsFile destination, IVfsActivity sourceActivity, IVfsActivity destinationActivity) {
        if (source == null) {
            return;
        }
        if (this.hasAvailableAction((IVfsFolderItem)source, VfsActionOnFolderItem.CREATE_AND_CHECKOUT)) {
            return;
        }
        if (this.hasAvailableAction((IVfsFolderItem)source, VfsActionOnFolderItem.UNCHECKOUT)) {
            sourceActivity = source.getOpenActivities()[0];
        }
        IVfsActionManager actionManager = VfsActionManager.getInstance();
        if (destination != null) {
            actionManager.doSynchronously((IVfsAction)new AddAction((IVfsActivityRecordedFolderItem[])new IVfsFile[]{destination}, destinationActivity, 0));
        }
        if (source.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            actionManager.doSynchronously((IVfsAction)new UncheckoutAction((IVfsActivityRecordedFolderItem)source));
        }
        if (!this.hasAvailableAction((IVfsFolderItem)source, VfsActionOnFolderItem.CREATE_AND_CHECKOUT)) {
            actionManager.doSynchronously((IVfsAction)new DeleteAction((IVfsActivityRecordedFolderItem)source, sourceActivity));
        }
    }

    private IVfsFile findCorrespondingDestinationFile(IVfsFile source, IVfsFolder destinationParent) {
        IVfsFolderItem[] items;
        if (destinationParent == null) {
            return null;
        }
        try {
            items = destinationParent.refreshFolderItems();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i].getCategory() == VfsFolderItemCategory.FILE) {
                IVfsFile dstFile = items[i].asFile();
                if (source.getName().equals(dstFile.getName())) {
                    return items[i].asFile();
                }
            }
            ++i;
        }
        return null;
    }

    private IVfsFolder findCorrespondingDestinationNode(IVfsFolder source, IVfsFolder destinationParent) {
        if (destinationParent == null) {
            return null;
        }
        String name = source.getName();
        IVfsFolderItem[] items = null;
        try {
            items = destinationParent.getFolderItems();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i].getCategory() == VfsFolderItemCategory.FOLDER && name.equals(items[i].getName())) {
                return items[i].asFolder();
            }
            ++i;
        }
        return null;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        Iterator iterator = DAVTeamProvider._moveDeleteHookListeners.iterator();
        while (iterator.hasNext()) {
            IMoveDeleteHook hook = (IMoveDeleteHook)iterator.next();
            try {
                boolean done = hook.moveProject(tree, source, description, updateFlags, monitor);
                if (!done) continue;
                return true;
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        return false;
    }

    private void trace(String msg) {
        if (this.traceFilter != null && (this.traceFilter.equals(allCases) || this.traceFilter.equals(thisClassName))) {
            Logbook.getPlainChapter((int)3).println("[DAVMoveDeleteHook] - " + msg);
        }
    }

    private Shell getShell() {
        final Shell[] result = new Shell[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                result[0] = BluebirdPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            }
        });
        return result[0];
    }

    private IVfsFile getFileForVFSDelete(IResource resource) {
        if (resource instanceof IFile && Team.isIgnoredHint((IResource)resource)) {
            return null;
        }
        IVfsFolderItem folderItem = this.myProvider.getFolderItem(resource);
        if (folderItem == null) {
            return null;
        }
        return folderItem.asFile();
    }

    private boolean deleteRepositoryFile(final IVfsFile file) {
        boolean deleteAllowed;
        file.refreshState();
        boolean bl = deleteAllowed = !this.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.SYNC_TO_LATEST) && file.getWorkspace().isModifiable();
        if (this.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.CREATE_AND_CHECKOUT) || file.getActionsForCurrentState().length == 0) {
            return true;
        }
        if (file.hasLocalRemoteNameClash()) {
            return true;
        }
        if (!deleteAllowed) {
            this.showFileDeleteErrorMessage(file);
            return false;
        }
        if (this.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.UNCHECKOUT)) {
            IVfsActivity activity = file.getOpenActivities()[0];
            IVfsActionManager manager = VfsActionManager.getInstance();
            manager.doSynchronously((IVfsAction)new UncheckoutAction((IVfsActivityRecordedFolderItem)file));
            file.refreshState();
            if (this.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.CREATE_AND_CHECKOUT)) {
                return true;
            }
            manager.doSynchronously((IVfsAction)new DeleteAction((IVfsActivityRecordedFolderItem)file, activity));
            return true;
        }
        final boolean[] result = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SelectActivityDialog dialog = new SelectActivityDialog(DAVMoveDeleteHook.this.getShell(), file.getWorkspace(), false, "Select Activity to Delete File - .../" + file.getWorkspaceRelativePath(), null, 0);
                if (dialog.open() == 0) {
                    IVfsActivity activity = dialog.getActivitySelection()[0];
                    VfsActionManager.getInstance().doSynchronously((IVfsAction)new DeleteAction((IVfsActivityRecordedFolderItem)file, activity));
                    result[0] = true;
                } else {
                    result[0] = false;
                }
            }
        });
        return result[0];
    }

    protected boolean isSourceActivityNeeded(IVfsFolder folder) throws VfsException {
        if (this.isSubtreeCheckoutedInOneActivity(folder)) {
            return false;
        }
        IVfsFolderItem[] items = folder.refreshFolderItems();
        int i = 0;
        while (i < items.length) {
            boolean childrenResult;
            IVfsFile file;
            if (items[i].asFile() != null ? ((file = items[i].asFile()).getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY || !this.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.CREATE_AND_CHECKOUT)) && file.isModifiable() && !file.hasLocalRemoteNameClash() && file.getLocationState() != VfsFolderItemLocationState.SERVER_ONLY && file.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT : items[i].asFolder() != null && (childrenResult = this.isSourceActivityNeeded(items[i].asFolder()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isDestinationActivityNeeded(IVfsFolder source, IVfsFolder destination) {
        if (source == null || destination == null) {
            return false;
        }
        if (!source.getWorkspace().equals(destination.getWorkspace())) {
            return this.isShared(source);
        }
        if (!this.isShared(source)) {
            return false;
        }
        if (this.isWholeSubtreeCheckouted(source)) {
            return !this.isSubtreeCheckoutedInOneActivity(source);
        }
        return false;
    }

    private boolean isWholeSubtreeCheckouted(IVfsFolder folder) {
        IVfsFolderItem[] items;
        try {
            items = folder.refreshFolderItems();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return false;
        }
        int i = 0;
        while (i < items.length) {
            IVfsFolder fld;
            IVfsFile file;
            if (items[i].asFile() != null ? (file = items[i].asFile()).getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY && file.getLocationState() != VfsFolderItemLocationState.SERVER_ONLY && !this.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.UNCHECKOUT) : items[i].asFolder() != null && !this.isWholeSubtreeCheckouted(fld = items[i].asFolder())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isSubtreeCheckoutedInOneActivity(IVfsFolder folder) {
        IVfsFolderItem[] items;
        try {
            items = folder.refreshFolderItems();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return false;
        }
        IVfsActivity activity = null;
        int i = 0;
        while (i < items.length) {
            IVfsFile file;
            if (items[i].getCategory() == VfsFolderItemCategory.FILE && (file = items[i].asFile()).getOpenActivities().length > 0) {
                activity = file.getOpenActivities()[0];
                break;
            }
            ++i;
        }
        if (activity == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < items.length) {
            IVfsActivity act;
            IVfsFile file;
            if (items[i2].getCategory() == VfsFolderItemCategory.FILE && (file = items[i2].asFile()).getOpenActivities().length > 0 && !activity.equals(act = file.getOpenActivities()[0])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean isShared(IVfsFolder folder) {
        return folder.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY || this.hasAvailableAction((IVfsFolderItem)folder, VfsActionOnFolderItem.UNCHECKOUT);
    }

    private void setMovePropertyToTree(IFolder folder, Boolean value) {
        try {
            folder.setSessionProperty(ResourceChangeListener.MOVED_PROPERTY_NAME, (Object)value);
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i].getType() == 2 && members[i] instanceof IFolder) {
                    this.setMovePropertyToTree((IFolder)members[i], value);
                } else if (members[i] instanceof IFile) {
                    members[i].setSessionProperty(ResourceChangeListener.MOVED_PROPERTY_NAME, (Object)value);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    private void showFileDeleteErrorMessage(final IVfsFile item) {
        Runnable action = new Runnable(){

            public void run() {
                IVfsActivityRecordedFolderItem activityRecorded = item.asActivityRecordedFolderItem();
                VfsFolderItemLocationState state = item.getLocationState();
                String reason = "is not in sync with latest version.";
                String solution = "- check-in changes and then delete.\n  - revert resource and then delete.";
                if (activityRecorded.getOpenActivities().length > 0) {
                    reason = "is checked-out for edit.";
                    solution = "- check-in all changes and then delete.\n - revert checked-out file and then delete.";
                } else if (state.equals(VfsFolderItemLocationState.SYNCED_TO_FORMER)) {
                    reason = "is outdated.";
                    solution = "- synchronize to latest version and then delete.";
                }
                MessageDialog.openError((Shell)DAVMoveDeleteHook.this.getShell(), (String)"Delete is not Allowed", (String)MessageFormat.format("Resource {0} {1}\n\nTo delete resource:\n {2}", item.getName(), reason, solution));
            }
        };
        Display.getDefault().syncExec(action);
    }

    private void showFileMoveErrorMessage(final IVfsFile item) {
        Runnable action = new Runnable(){

            public void run() {
                IVfsActivityRecordedFolderItem activityRecorded = item.asActivityRecordedFolderItem();
                VfsFolderItemLocationState state = item.getLocationState();
                String reason = "is not in sync with latest version.";
                String solution = "- check-in changes and then move.\n  - revert resource and then move.";
                if (activityRecorded.getOpenActivities().length > 0) {
                    reason = "is checked-out for edit.";
                    solution = "- check-in all changes and then delete.\n - revert checked-out file and then move.";
                } else if (state.equals(VfsFolderItemLocationState.SYNCED_TO_FORMER)) {
                    reason = "is outdated.";
                    solution = "- synchronize to latest version and then move.";
                }
                MessageDialog.openError((Shell)DAVMoveDeleteHook.this.getShell(), (String)"Move is not Allowed", (String)MessageFormat.format("Resource {0} {1}\n\nTo move resource:\n {2}", item.getName(), reason, solution));
            }
        };
        Display.getDefault().syncExec(action);
    }

    private void showFolderDeleteErrorMessage(final IVfsFolder item) {
        Runnable action = new Runnable(){

            public void run() {
                String msg = "could not be deleted because of following reasons:";
                String reasons = "- folder itself is checked-out\n - some member(s) is/are checked-out\n - some member(s) is/are outdated";
                MessageDialog.openError((Shell)DAVMoveDeleteHook.this.getShell(), (String)"Delete is not Allowed", (String)MessageFormat.format("Folder {0} {1}\n\n {2}", ".../" + item.getWorkspaceRelativePath(), msg, reasons));
            }
        };
        Display.getDefault().syncExec(action);
    }

    private void showFolderMoveErrorMessage(final IVfsFolder item) {
        Runnable action = new Runnable(){

            public void run() {
                String msg = "could not be moved because of following reasons:";
                String reasons = "- some member(s) is/are) outdated";
                MessageDialog.openError((Shell)DAVMoveDeleteHook.this.getShell(), (String)"Move is not Allowed", (String)MessageFormat.format("Folder {0} {1}\n\n {2}", ".../" + item.getWorkspaceRelativePath(), msg, reasons));
            }
        };
        Display.getDefault().syncExec(action);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

