/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.workspaceMonitor;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.eclipse.workspaceMonitor.EditMultipleFilesDialog;
import com.tssap.dtr.client.eclipse.workspaceMonitor.MonitorType;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.EditAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.Team;

public class DAVFileValidatior
implements IFileModificationValidator {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$workspaceMonitor$DAVFileValidatior == null ? (class$com$tssap$dtr$client$eclipse$workspaceMonitor$DAVFileValidatior = DAVFileValidatior.class$("com.tssap.dtr.client.eclipse.workspaceMonitor.DAVFileValidatior")) : class$com$tssap$dtr$client$eclipse$workspaceMonitor$DAVFileValidatior));
    private static final String thisClassName = "DAVFileValidator";
    private static final String allCases = "*";
    private String traceFilter = Platform.getDebugOption((String)"com.tssap.dtr.client.eclipse/debug/filter");
    private DAVTeamProvider fProvider;
    private WorkspaceMonitor fWorkspaceMonitor;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$workspaceMonitor$DAVFileValidatior;

    public DAVFileValidatior(DAVTeamProvider provider) {
        this.fProvider = provider;
        this.fWorkspaceMonitor = WorkspaceMonitor.getInstance();
    }

    protected boolean comeSelectionsFromSameWorkspace(IFile[] files) {
        if (files == null) {
            return false;
        }
        if (files.length == 1) {
            return true;
        }
        if (files.length > 1) {
            IVfsWorkspace firstWS = null;
            int i = 0;
            while (i < files.length) {
                DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider((IResource)files[i]);
                if (provider == null) {
                    return false;
                }
                IVfsFolderItem item = null;
                try {
                    IVersionedFileSystemManager manager = provider.getVFSManager();
                    if (manager == null) {
                        return false;
                    }
                    item = manager.getFolderItem(files[i].getLocation().toOSString());
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    return false;
                }
                if (!(item instanceof IVfsActivityRecordedFolderItem)) {
                    return false;
                }
                IVfsWorkspace workspace = ((IVfsActivityRecordedFolderItem)item).getWorkspace();
                if (firstWS == null) {
                    firstWS = workspace;
                } else if (!firstWS.equals(workspace)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private IVfsFile[] convertFromResources(IFile[] resources) {
        if (resources == null) {
            return null;
        }
        ArrayList<IVfsFolderItem> vfsResources = new ArrayList<IVfsFolderItem>();
        int i = 0;
        while (i < resources.length) {
            DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider((IResource)resources[i]);
            if (provider == null) {
                return null;
            }
            try {
                IVersionedFileSystemManager manager = provider.getVFSManager();
                if (manager == null) {
                    return null;
                }
                IVfsFolderItem item = manager.getFolderItem(resources[i].getLocation().toOSString());
                if (item == null) {
                    return null;
                }
                vfsResources.add(item);
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                return null;
            }
            ++i;
        }
        return vfsResources.toArray(new IVfsFile[vfsResources.size()]);
    }

    public IStatus validateEdit(IFile[] files, Object context) {
        Status okStatus = new Status(0, " com.tssap.dtr.client.eclipse", 0, "", null);
        if (VfsManagerProvider.getInstance().isSapIDELoginAvailable() && !VfsManagerProvider.getInstance().isUserLoggedinInSapIDE()) {
            return new Status(4, " com.tssap.dtr.client.eclipse", 3, "User isn't logged in", null);
        }
        if (!this.comeSelectionsFromSameWorkspace(files)) {
            return new Status(4, " com.tssap.dtr.client.eclipse", 1, "File(s) are not from the same workspace", null);
        }
        if (files == null) {
            return okStatus;
        }
        ArrayList<IFile> monitoredFiles = new ArrayList<IFile>(1);
        int i = 0;
        while (i < files.length) {
            if (this.fWorkspaceMonitor.isMonitored((IResource)files[i], MonitorType.EDIT)) {
                monitoredFiles.add(files[i]);
            }
            ++i;
        }
        if (monitoredFiles.isEmpty()) {
            if (files.length == 0) {
                return okStatus;
            }
            return new Status(4, " com.tssap.dtr.client.eclipse", 2, "File(s) are excluded from monitoring", null);
        }
        IFile[] monitored = monitoredFiles.toArray(new IFile[monitoredFiles.size()]);
        final IStatus[] out = new IStatus[1];
        Display.getDefault().syncExec(new Runnable((IStatus)okStatus, context, monitored, files){
            static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsFile;
            private final /* synthetic */ IStatus val$okStatus;
            private final /* synthetic */ Object val$context;
            private final /* synthetic */ IFile[] val$monitored;
            private final /* synthetic */ IFile[] val$files;
            {
                this.val$okStatus = val$okStatus;
                this.val$context = val$context;
                this.val$monitored = val$monitored;
                this.val$files = val$files;
            }

            public void run() {
                boolean okPressed;
                out[0] = this.val$okStatus;
                Shell uiShell = this.val$context == null ? Display.getDefault().getActiveShell() : (Shell)this.val$context;
                IVfsFile[] items = DAVFileValidatior.this.checkForAction(DAVFileValidatior.this.convertFromResources(this.val$monitored), VfsActionOnFolderItem.CHECKOUT_FOR_EDIT);
                if (items == null) {
                    out[0] = new Status(4, " com.tssap.dtr.client.eclipse", 4, "Can't convert to VFS objects", null);
                    return;
                }
                if (items.length == 0) {
                    out[0] = this.val$okStatus;
                    return;
                }
                EditMultipleFilesDialog dialog = new EditMultipleFilesDialog(uiShell, "Check-out for edit", "Following files have been touched - check-out for edit?", 3, (IVfsFolderItem[])items, (IVfsFolderItem[])items);
                boolean bl = okPressed = dialog.open() == 0;
                if (!okPressed) {
                    out[0] = new Status(4, " com.tssap.dtr.client.eclipse", 6, "File(s) are not checked-out for edit", null);
                } else {
                    IVfsActivity activity;
                    items = (IVfsFile[])Util.getArrayFromIterator(dialog.getReturnedSelection().iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsFile == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsFile = 1.class$("com.tssap.dtr.client.lib.vfs.IVfsFile")) : class$com$tssap$dtr$client$lib$vfs$IVfsFile);
                    if (items.length != this.val$files.length) {
                        out[0] = new Status(4, " com.tssap.dtr.client.eclipse", 5, "Not all of the touched files have been checked-out for edit", null);
                    }
                    IVfsWorkspace workspace = items[0].getWorkspace();
                    boolean exclusive = dialog.isExclusive();
                    if (WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
                        activity = null;
                    } else {
                        SelectActivityDialog selectActivity = new SelectActivityDialog(uiShell, workspace);
                        if (selectActivity.open() == 0) {
                            activity = selectActivity.getActivitySelection()[0];
                        } else {
                            return;
                        }
                    }
                    VfsActionManager.getInstance().doSynchronously((IVfsAction)new EditAction((IVfsActivityRecordedFolderItem[])items, activity, 0, exclusive, null));
                }
                try {
                    int i = 0;
                    while (i < this.val$monitored.length) {
                        this.val$monitored[i].refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        ++i;
                    }
                }
                catch (CoreException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        return out[0];
    }

    private IVfsFile[] checkForAction(IVfsFile[] files, VfsActionOnFolderItem action) {
        if (files == null) {
            return null;
        }
        ArrayList<IVfsFile> resultFiles = new ArrayList<IVfsFile>();
        int i = 0;
        while (i < files.length) {
            VfsActionOnFolderItem[] availableActions = files[i].getActionsForCurrentState();
            int j = 0;
            while (j < availableActions.length) {
                if (availableActions[j] == action) {
                    resultFiles.add(files[i]);
                }
                ++j;
            }
            ++i;
        }
        return resultFiles.toArray(new IVfsFile[resultFiles.size()]);
    }

    private boolean checkOpenState(IVfsFolderItem[] items) {
        if (items == null) {
            return true;
        }
        int i = 0;
        while (i < items.length) {
            items[i].refreshState();
            VfsActionOnFolderItem[] availableActions = items[i].getActionsForCurrentState();
            int j = 0;
            while (j < availableActions.length) {
                if (availableActions[j] == VfsActionOnFolderItem.CHECKOUT_FOR_EDIT) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public IStatus validateSave(IFile file) {
        IVfsFile[] items;
        Status okStatus = new Status(0, " com.tssap.dtr.client.eclipse", 0, "", null);
        if (file == null || Team.isIgnoredHint((IFile)file)) {
            return okStatus;
        }
        this.trace("save file:" + file.toString() + ", stamp: " + file.getModificationStamp() + ", phantom:" + file.isPhantom());
        Status result = okStatus;
        if (file != null && !this.checkOpenState((IVfsFolderItem[])(items = this.convertFromResources(new IFile[]{file})))) {
            result = new Status(4, " com.tssap.dtr.client.eclipse", 5, "File(s) are not checked-out for edit", null);
        }
        return result;
    }

    private void trace(String msg) {
        if (this.traceFilter != null && (this.traceFilter.equals(allCases) || this.traceFilter.equals(thisClassName))) {
            Logbook.getPlainChapter((int)3).println("[DAVFileValidator] - " + msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

