/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.vfs;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.internal.IIDELoginListener;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class VfsManagerProvider {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$vfs$VfsManagerProvider == null ? (class$com$tssap$dtr$client$eclipse$vfs$VfsManagerProvider = VfsManagerProvider.class$("com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider")) : class$com$tssap$dtr$client$eclipse$vfs$VfsManagerProvider));
    private static VfsManagerProvider m_ourInstance;
    private boolean m_failedViaReflection;
    private boolean m_firstReflectionSuccessful;
    private Set m_loginListeners = new HashSet();
    private Class class_UserValidator;
    private Class class_UserData;
    private Map _loginSucceededForContext = new HashMap();
    private Set m_warnedClients = new HashSet();
    private static final Object UNAUTHORIZED;
    private static final int FORCE_POPUP = 0;
    private static final int POPUP_IF_NOT_LOGGED_IN = 1;
    private static final int NO_POPUP = 2;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$vfs$VfsManagerProvider;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Shell;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized VfsManagerProvider getInstance() {
        if (m_ourInstance == null) {
            m_ourInstance = new VfsManagerProvider();
            m_ourInstance.registerSapIDELoginListerner();
        }
        return m_ourInstance;
    }

    private VfsManagerProvider() {
    }

    private void registerSapIDELoginListerner() {
        try {
            Class<?> class_LoginListener = Class.forName("com.sap.ide.login.LoginListener");
            this.m_firstReflectionSuccessful = true;
            this.class_UserData = Class.forName("com.sap.ide.login.UserValidator$Data");
            final Method method_loginPerformed = class_LoginListener.getMethod("loginPerformed", this.class_UserData);
            Object proxy_loginListener = Proxy.newProxyInstance(class_LoginListener.getClassLoader(), new Class[]{class_LoginListener}, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.equals(method_loginPerformed)) {
                        long start = System.currentTimeMillis();
                        try {
                            VfsManagerProvider.this.fireLoginOrLogoutPerformed();
                            Object var7_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_6 = null;
                            long elapsed = System.currentTimeMillis() - start;
                            LogUtil.logElapsedTime((long)elapsed, (String)"VfsManagerProvider.fireLoginOrLogoutPerformed");
                            throw throwable;
                        }
                        long elapsed = System.currentTimeMillis() - start;
                        LogUtil.logElapsedTime((long)elapsed, (String)"VfsManagerProvider.fireLoginOrLogoutPerformed");
                        {
                        }
                    }
                    return null;
                }
            });
            this.class_UserValidator = Class.forName("com.sap.ide.login.UserValidator");
            Method method_addLoginListener = this.class_UserValidator.getMethod("addLoginListener", class_LoginListener);
            method_addLoginListener.invoke(null, proxy_loginListener);
        }
        catch (Exception x) {
            this.m_failedViaReflection = true;
            if (this.m_firstReflectionSuccessful) {
                Logbook.getErrorChapter().println("Reflection failed: " + x.getLocalizedMessage());
            }
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
    }

    private void fireLoginOrLogoutPerformed() {
        Object[] userData = this.getLoginData(2, null);
        try {
            Configuration.getConfiguration().setMasterLogin((String)userData[0], (String)userData[1], (KeyStore)userData[2], (KeyStore)userData[3]);
        }
        catch (KeyStoreException x) {
            Logbook.getErrorChapter().println("Setting master login failed: " + x.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return;
        }
        Iterator iter = this.m_loginListeners.iterator();
        if (!this.isUserLoggedinInSapIDE()) {
            this.onLoggedOut();
            while (iter.hasNext()) {
                ((IIDELoginListener)iter.next()).onUserLoggedOut();
            }
        } else {
            this.onLoggedIn();
            String[] userAndPwd = new String[]{(String)userData[0], (String)userData[1]};
            KeyStore[] serverAndClientCerts = new KeyStore[]{(KeyStore)userData[2], (KeyStore)userData[3]};
            while (iter.hasNext()) {
                long elapsed;
                Object var9_8;
                long start = System.currentTimeMillis();
                IIDELoginListener listener = (IIDELoginListener)iter.next();
                try {
                    listener.onUserLoggedIn(userAndPwd, serverAndClientCerts);
                    var9_8 = null;
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    elapsed = System.currentTimeMillis() - start;
                    LogUtil.logElapsedTime((long)elapsed, (String)("IIDELoginListener.onUserLoggedIn called on " + listener));
                    throw throwable;
                }
                elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)("IIDELoginListener.onUserLoggedIn called on " + listener));
                {
                }
            }
        }
    }

    private void onLoggedIn() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            IViewPart loggerView = page.findView("com.tssap.dtr.client.eclipse.ui.loggerview");
            if (loggerView == null) {
                try {
                    loggerView = page.showView("com.tssap.dtr.client.eclipse.ui.loggerview");
                }
                catch (PartInitException x) {
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            }
            if (loggerView != null) {
                page.activate((IWorkbenchPart)loggerView);
            }
        }
    }

    private void onLoggedOut() {
        this._loginSucceededForContext.clear();
        this.m_warnedClients.clear();
    }

    public IVersionedFileSystemManager getVersionedFileSystemManager(IVfsContext context) throws VfsException {
        Object loginStateForContext;
        if (!this.performClientFilterCheck(context)) {
            return null;
        }
        if (this.isSapIDELoginAvailable()) {
            Object[] userData = this.getLoginData(2, null);
            if (userData[0] == null) {
                return null;
            }
            try {
                Configuration.getConfiguration().setMasterLogin((String)userData[0], (String)userData[1], (KeyStore)userData[2], (KeyStore)userData[3]);
            }
            catch (KeyStoreException x) {
                throw new VfsException("Setting master login failed: " + x.getMessage());
            }
        }
        if ((loginStateForContext = this._loginSucceededForContext.get(context)) == UNAUTHORIZED) {
            throw new VfsException("User not authorized.");
        }
        if (loginStateForContext == Boolean.FALSE) {
            throw new VfsException("Failed to log in.");
        }
        if (loginStateForContext == null) {
            IVfsRemoteLocator[] servers = context.getRootRemoteLocators();
            int i = 0;
            while (i < servers.length) {
                IVfsRemoteLocator server = servers[i];
                long start = System.currentTimeMillis();
                int status = context.httpPing(server, 1, 10000, 0);
                if (status == 401) {
                    this._loginSucceededForContext.put(context, UNAUTHORIZED);
                    throw new VfsException("User not authorized for server " + context.getWebLocator(server.getConnectionTemplateId()) + server.getAbsoluteRemotePath());
                }
                if (status >= 500 && status <= 599) {
                    start = System.currentTimeMillis();
                    status = context.httpPing(server, 0, EnvironmentVariables.MILLIS_FOR_LONG_PING, 0);
                    if (status == 401) {
                        this._loginSucceededForContext.put(context, UNAUTHORIZED);
                        throw new VfsException("User not authorized for server " + context.getWebLocator(server.getConnectionTemplateId()) + server.getAbsoluteRemotePath());
                    }
                    if (status != 200) {
                        this._loginSucceededForContext.put(context, Boolean.FALSE);
                        throw new VfsException("Failed to log in (status: " + status + ") on server " + context.getWebLocator(server.getConnectionTemplateId()) + server.getAbsoluteRemotePath());
                    }
                } else if (status != 200) {
                    this._loginSucceededForContext.put(context, Boolean.FALSE);
                    throw new VfsException("Failed to log in (status: " + status + ") on server " + context.getWebLocator(server.getConnectionTemplateId()) + server.getAbsoluteRemotePath());
                }
                long end = System.currentTimeMillis();
                Logbook.getInfoChapter().println("Server response time for login to server " + context.getUrl(server) + " : " + (end - start) + " ms.");
                ++i;
            }
            this._loginSucceededForContext.put(context, Boolean.TRUE);
        }
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)context);
        return manager;
    }

    public boolean logIn(IVfsContext context) throws VfsException {
        Object[] userData;
        if (!this.performClientFilterCheck(context)) {
            return false;
        }
        if (!this.isSapIDELoginAvailable()) {
            this.getVersionedFileSystemManager(context);
            return true;
        }
        Object[] objectArray = userData = this.isUserLoggedinInSapIDE() ? this.getLoginData(0, null) : this.getLoginData(1, null);
        if (userData[0] == null) {
            return false;
        }
        this.onLoggedOut();
        this.getVersionedFileSystemManager(context);
        this.fireLoginOrLogoutPerformed();
        return true;
    }

    private Object[] getLoginData(int popupMode, String displayText) {
        if (!this.isSapIDELoginAvailable()) {
            return new Object[4];
        }
        try {
            Method method_getUser = this.class_UserData.getMethod("getUser", null);
            Method method_getPassword = this.class_UserData.getMethod("getPassword", null);
            Method method_isOnline = this.class_UserData.getMethod("isOnline", null);
            Field field_userLogin = this.class_UserValidator.getField("USER_LOGIN");
            Field field_lazyLogin = this.class_UserValidator.getField("LAZY_LOGIN");
            Field field_forceLogin = this.class_UserValidator.getField("FORCE_LOGIN");
            int userLoginConstant = field_userLogin.getInt(null);
            int lazyLoginConstant = field_lazyLogin.getInt(null);
            int forceLoginConstant = field_forceLogin.getInt(null);
            Method method_getDefaultServerData = this.class_UserValidator.getMethod("getDefaultServerData", Integer.TYPE, class$org$eclipse$swt$widgets$Shell == null ? (class$org$eclipse$swt$widgets$Shell = VfsManagerProvider.class$("org.eclipse.swt.widgets.Shell")) : class$org$eclipse$swt$widgets$Shell, class$java$lang$String == null ? (class$java$lang$String = VfsManagerProvider.class$("java.lang.String")) : class$java$lang$String);
            int kind = popupMode == 0 ? userLoginConstant : (popupMode == 2 ? forceLoginConstant : lazyLoginConstant);
            Object data = method_getDefaultServerData.invoke(null, new Integer(kind), null, displayText);
            if (data == null) {
                return new Object[4];
            }
            boolean isOnline = (Boolean)method_isOnline.invoke(data, null);
            if (!isOnline) {
                return new Object[4];
            }
            Method method_getKeyStore = this.class_UserValidator.getMethod("getKeyStore", null);
            Object keyStore4Server = method_getKeyStore.invoke(null, null);
            return new Object[]{(String)method_getUser.invoke(data, null), (String)method_getPassword.invoke(data, null), (KeyStore)keyStore4Server, null};
        }
        catch (Exception x) {
            if (this.m_firstReflectionSuccessful) {
                Logbook.getErrorChapter().println("Reflection failed: " + x.getLocalizedMessage());
            }
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return new Object[4];
        }
    }

    public void addIDELoginListener(IIDELoginListener listener) {
        this.m_loginListeners.add(listener);
    }

    public void removeIDELoginListener(IIDELoginListener listener) {
        this.m_loginListeners.remove(listener);
    }

    public boolean isSapIDELoginAvailable() {
        return !this.m_failedViaReflection;
    }

    public boolean isUserLoggedinInSapIDE() {
        if (this.isSapIDELoginAvailable()) {
            return this.getLoginData(2, null)[0] != null;
        }
        return true;
    }

    public boolean performClientFilterCheck(IVfsContext context) {
        if (context != null) {
            Shell shell;
            if (this.m_warnedClients.contains(context)) {
                return true;
            }
            String clientFilter = context.getClientFilter();
            if ((clientFilter == null || clientFilter.equals("")) && (shell = Display.getDefault().getActiveShell()) != null) {
                boolean ok;
                MessageDialog warnDialog = new MessageDialog(shell, "No Client Filter", null, "Caution:\n\nThe client \"" + context.getClientName() + "\" does not have a client filter. " + "Such a client is only intended for diagnostic purposes.\n\n" + "Do not SYNC, REMOVE, CHECKOUT or CHECKIN resources with this client " + "as these operations will result in data inconsistency and even data loss!\n\n" + "Continue?", 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
                boolean bl = ok = warnDialog.open() == 0;
                if (ok) {
                    this.m_warnedClients.add(context);
                }
                return ok;
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        UNAUTHORIZED = new Object();
    }
}

