/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.util.ObjectOffsets;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsRevisionAction;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.IWorkbenchAdapter;

class RevisionHistoryTableLabelProvider
implements ITableLabelProvider {
    private Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$vtree$revisionHistory$RevisionHistoryTableLabelProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$vtree$revisionHistory$RevisionHistoryTableLabelProvider = RevisionHistoryTableLabelProvider.class$("com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory.RevisionHistoryTableLabelProvider")) : class$com$tssap$dtr$client$eclipse$ui$vtree$revisionHistory$RevisionHistoryTableLabelProvider));
    static final int REVISION_NUMBER = 0;
    static final int FILE_PATH = 1;
    static final int DATE = 2;
    static final int USER = 3;
    static final int ACTION = 4;
    static final int LOCATION_IN_GRAPH = 5;
    static final int ISN = 6;
    private final String NULL_ISN = "0";
    private final String EDIT_ACTION = "Edit ";
    private final String DELETE_ACTION = "Delete ";
    private final String INTEGRATE_CAPTION = " from workspace : ";
    private IVfsWorkspace m_workspace;
    private IVfsVersion m_versionSyncdOnClientWorkspace;
    private Table m_table;
    private int m_numberOfRevisions;
    private IVfsVersion m_workingResourcePredecessorInSyncDB;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$vtree$revisionHistory$RevisionHistoryTableLabelProvider;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public RevisionHistoryTableLabelProvider(IVfsWorkspace workspace, Table table, int numberOfRevisions, IVfsVersion versionSyncdOnClientWorkspace) {
        this.m_workspace = workspace;
        this.m_table = table;
        this.m_numberOfRevisions = numberOfRevisions;
        this.m_versionSyncdOnClientWorkspace = versionSyncdOnClientWorkspace;
        this.m_workingResourcePredecessorInSyncDB = null;
        if (this.m_versionSyncdOnClientWorkspace != null) {
            try {
                IVfsFile fileInWorkspace = this.m_versionSyncdOnClientWorkspace.getCorrespondingFile(this.m_workspace);
                if (fileInWorkspace != null && (fileInWorkspace.getActivityState().equals(VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) || fileInWorkspace.getActivityState().equals(VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE))) {
                    this.m_workingResourcePredecessorInSyncDB = fileInWorkspace.refreshAndGetVersion();
                }
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)this.LOCATION, (Throwable)e);
            }
        }
    }

    protected final IWorkbenchAdapter getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter)((IAdaptable)o).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = RevisionHistoryTableLabelProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof IVfsRevision && columnIndex == 1) {
            IVfsVersion version = ((IVfsRevision)element).getVersion();
            if (this.m_workingResourcePredecessorInSyncDB == null) {
                if (version.equals(this.m_versionSyncdOnClientWorkspace)) {
                    return this.getSyncdVersionImage();
                }
                return this.getVersionImage(version);
            }
            if (version.equals(this.m_workingResourcePredecessorInSyncDB)) {
                return this.getSyncdVersionImage();
            }
            return this.getVersionImage(version);
        }
        return null;
    }

    private Image getSyncdVersionImage() {
        boolean stretch = true;
        ObjectOffsets objectOffsets = new ObjectOffsets();
        objectOffsets.add(VfsFolderItemCategory.FILE, stretch ? 5 : 0);
        objectOffsets.add(VfsFolderItemLocationState.SYNCED_TO_LATEST, stretch ? 10 : 0);
        objectOffsets.add(VfsFolderItemActivityState.NOT_CHECKED_OUT, stretch ? 0 : 0);
        return BluebirdPlugin.getDefault().getPluginImageRegistry().getImage(objectOffsets, stretch);
    }

    private Image getVersionImage(IVfsVersion version) {
        boolean stretch = true;
        ObjectOffsets objectOffsets = new ObjectOffsets();
        objectOffsets.add("FILE", stretch ? 5 : 0);
        objectOffsets.add("VERSIONED", stretch ? 10 : 0);
        if (version.isDeleted()) {
            objectOffsets.add("DELETION", stretch ? 0 : 0);
        }
        return BluebirdPlugin.getDefault().getPluginImageRegistry().getImage(objectOffsets, stretch);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IVfsRevision) {
            IVfsRevision revision = (IVfsRevision)element;
            boolean createdHere = false;
            if (PathUtilities.assureTrailingSeparator((String)this.m_workspace.getAbsoluteRemotePath(), (IFileService)PathUtilities.REMOTE_FILESERVICE).equalsIgnoreCase(PathUtilities.assureTrailingSeparator((String)revision.getVersion().getCreatorWorkspaceName(), (IFileService)PathUtilities.REMOTE_FILESERVICE))) {
                createdHere = true;
            }
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(this.m_numberOfRevisions - this.m_table.getItemCount() + 1);
                }
                case 6: {
                    return String.valueOf(revision.getISN());
                }
                case 1: {
                    return revision.getVersion().toString();
                }
                case 2: {
                    return Util.getGMTString(revision.getIntegrationDate());
                }
                case 3: {
                    return revision.getVersion().getAuthor();
                }
                case 5: {
                    return revision.getVersion().getLocationInGraph();
                }
                case 4: {
                    StringBuffer actionType = new StringBuffer();
                    actionType.append(revision.getAction().toString());
                    if (revision.getAction().equals(VfsRevisionAction.INTEGRATE) || revision.getAction().equals(VfsRevisionAction.FORCE_INTEGRATE)) {
                        actionType.append(" from workspace : " + revision.getVersion().getCreatorWorkspaceName());
                    }
                    return actionType.toString();
                }
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

