/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory;

import com.tssap.dtr.client.eclipse.ui.treeBrowser.VFSAdaptableSelectionProvider;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.ui.util.ResizableTitleDialog;
import com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory.RevisionHistoryTableContentProvider;
import com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory.RevisionHistoryTableLabelProvider;
import com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory.RevisionHistoryTableViewer;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import java.util.AbstractList;
import java.util.ArrayList;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class RevisionHistoryDialog
extends ResizableTitleDialog
implements IMenuListener {
    private static final String REVISION_HISTORY_DIALOG_LOCATION = "com.tssap.dtr.client.eclipse_RevisionHistoryDialogLocation";
    private static final String REVISION_HISTORY_DIALOG_SIZE = "com.tssap.dtr.client.eclipse_RevisionHistoryDialogSize";
    private final String UNABLE_TO_RETRIEVE_ACTIVITY_DESCRIPTION = "<< Unable to retrieve description >>";
    private final String UNABLE_TO_RETRIEVE_ACTIVITY_NAME = "<< Unable to retrieve display name >>";
    private final String NULL_ACTIVITY_DESCRIPTION = "";
    private ArrayList m_revisionsInWorkspace;
    private IVfsWorkspace m_workspace;
    private IVfsVersion m_versionSyncdOnClientWorkspace;
    private RevisionHistoryTableViewer m_historyTableViewer;
    private Text m_activityName;
    private Text m_activityDescription;
    private IWorkbenchPartSite m_site;
    private ISelectionProvider m_lastSelectionProvider;

    public RevisionHistoryDialog(Shell parent, String title, Image titleImage) {
        super(parent, title, titleImage);
    }

    protected Point getInitialSize() {
        Point sizePoint;
        String sizeString = this.getPreferenceStore().getString(REVISION_HISTORY_DIALOG_SIZE);
        if (sizeString.length() > 0 && (sizePoint = LayoutHelper.parseCoordinates(sizeString)) != null) {
            return sizePoint;
        }
        return super.getInitialSize();
    }

    protected Point getInitialLocation(Point initialSize) {
        Point locationPoint;
        String locationString = this.getPreferenceStore().getString(REVISION_HISTORY_DIALOG_LOCATION);
        if (locationString.length() > 0 && (locationPoint = LayoutHelper.parseCoordinates(locationString)) != null) {
            return locationPoint;
        }
        return super.getInitialLocation(initialSize);
    }

    private void persistShellGeometry() {
        Point shellLocation = this.getShell().getLocation();
        Point shellSize = this.getShell().getSize();
        String locationString = LayoutHelper.serializeCoords(shellLocation);
        String sizeString = LayoutHelper.serializeCoords(shellSize);
        this.getPreferenceStore().setValue(REVISION_HISTORY_DIALOG_LOCATION, locationString);
        this.getPreferenceStore().setValue(REVISION_HISTORY_DIALOG_SIZE, sizeString);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Close", true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite out = (Composite)super.createDialogArea(parent);
        Composite messageParent = new Composite(out, 0);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 2;
        messageParent.setLayout((Layout)gLayout);
        messageParent.setLayoutData((Object)new GridData(34));
        Label revHistoryHeader = new Label(messageParent, 0);
        revHistoryHeader.setText("Revision history of resource:  ");
        Text txResource = new Text(messageParent, 8);
        txResource.setText(((IVfsRevision)((AbstractList)this.m_revisionsInWorkspace).iterator().next()).getVersion().toString());
        Label revHistoryWorkspaceHeader = new Label(messageParent, 0);
        revHistoryWorkspaceHeader.setText("Workspace:  ");
        Text txWorkspace = new Text(messageParent, 8);
        txWorkspace.setText(this.m_workspace.getAbsoluteRemotePath());
        Table table = new Table(out, 68098);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item != null) {
                    BusyIndicator.showWhile((Display)RevisionHistoryDialog.this.getShell().getDisplay(), (Runnable)new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            ISelection selection = RevisionHistoryDialog.access$100(1.access$000(this.this$1)).getSelection();
                            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 1) {
                                RevisionHistoryDialog.access$200(1.access$000(this.this$1)).setText("");
                                RevisionHistoryDialog.access$300(1.access$000(this.this$1)).setText("");
                            } else if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
                                1.access$400(this.this$1, (IVfsRevision)((IStructuredSelection)selection).getFirstElement());
                            }
                        }
                    });
                    RevisionHistoryDialog.this.m_historyTableViewer.fireSelectionChangedEvent(e);
                }
            }

            private void setActivityDetails(IVfsRevision revision) {
                String name = "<< Unable to retrieve display name >>";
                String description = "<< Unable to retrieve description >>";
                name = revision.getCreatingActivityName();
                if (name == null) {
                    name = "<< Unable to retrieve display name >>";
                }
                if ((description = revision.getCreatingActivityDescription()) == null) {
                    description = "";
                }
                RevisionHistoryDialog.this.m_activityName.setText(name);
                RevisionHistoryDialog.this.m_activityDescription.setText(description);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            static /* synthetic */ RevisionHistoryDialog access$000(1 x0) {
                return x0.RevisionHistoryDialog.this;
            }

            static /* synthetic */ void access$400(1 x0, IVfsRevision x1) {
                x0.setActivityDetails(x1);
            }
        });
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(table, 0);
        column.setText("Rev No.");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        column = new TableColumn(table, 0);
        column.setText("File");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(300, true));
        column = new TableColumn(table, 0);
        column.setText("Date");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(350, false));
        column = new TableColumn(table, 0);
        column.setText("User");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(170, false));
        column = new TableColumn(table, 0);
        column.setText("Action");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(350, true));
        column = new TableColumn(table, 0);
        column.setText("Location in Graph (Branch Sequence No.)");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(400, true));
        column = new TableColumn(table, 0);
        column.setText("ISN");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        table.setLayout((Layout)layout);
        GridData layoutData = new GridData(1840);
        layoutData.heightHint = 100;
        table.setLayoutData((Object)layoutData);
        this.m_historyTableViewer = new RevisionHistoryTableViewer(table);
        RevisionHistoryTableContentProvider contentProvider = new RevisionHistoryTableContentProvider();
        this.m_historyTableViewer.setContentProvider((IContentProvider)contentProvider);
        RevisionHistoryTableLabelProvider labelProvider = new RevisionHistoryTableLabelProvider(this.m_workspace, table, this.m_revisionsInWorkspace.size(), this.m_versionSyncdOnClientWorkspace);
        this.m_historyTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.m_historyTableViewer.setInput(this.m_revisionsInWorkspace);
        this.m_historyTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        Group groupActivityInfo = new Group(out, 0);
        groupActivityInfo.setText("Activity Details");
        groupActivityInfo.setLayout((Layout)new GridLayout(2, false));
        groupActivityInfo.setLayoutData((Object)new GridData(1809));
        Label label = new Label((Composite)groupActivityInfo, 0);
        label.setText("Display name:");
        label.setLayoutData((Object)new GridData());
        this.m_activityName = new Text((Composite)groupActivityInfo, 2060);
        this.m_activityName.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)groupActivityInfo, 0);
        label.setText("Description:");
        label.setLayoutData((Object)new GridData(2));
        this.m_activityDescription = new Text((Composite)groupActivityInfo, 2632);
        this.m_activityDescription.setLayoutData((Object)new GridData(1808));
        this.m_site = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
        this.m_site.registerContextMenu(this.m_historyTableViewer.getMenuManager(), (ISelectionProvider)this.m_historyTableViewer);
        this.m_lastSelectionProvider = this.m_site.getSelectionProvider();
        this.m_site.setSelectionProvider((ISelectionProvider)new VFSAdaptableSelectionProvider((ISelectionProvider)this.m_historyTableViewer));
        this.m_historyTableViewer.getTable().setFocus();
        return out;
    }

    public void setInput(ArrayList revisions, IVfsWorkspace workspace, IVfsVersion versionSyncdOnClientWorkspace) {
        this.m_revisionsInWorkspace = revisions;
        this.m_workspace = workspace;
        this.m_versionSyncdOnClientWorkspace = versionSyncdOnClientWorkspace;
    }

    public boolean close() {
        this.persistShellGeometry();
        this.m_site.setSelectionProvider(this.m_lastSelectionProvider);
        return super.close();
    }

    public void menuAboutToShow(IMenuManager manager) {
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    public IVfsWorkspace getWorkspace() {
        return this.m_workspace;
    }
}

