/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.vtree;

import com.tssap.dtr.client.eclipse.ui.vtree.VersionSelectionListener;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeControl;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VersionTreeViewer
extends Viewer
implements VersionSelectionListener {
    private IVfsVersionHistory m_currentVersionHistory;
    private IVfsWorkspace m_activeWorkspace;
    private VersionTreeControl m_versionControl;
    protected IVfsVersion[] m_selectedVersions;
    protected IVfsVersionRelation m_selectedVersionRelation;
    protected String m_selectedWorkspacePath;
    private StructuredSelection selection;
    private Composite m_parent;
    private Composite m_canvasInView;
    private static final boolean DEBUG = false;
    private static final int ARROW_INCREMENT = 25;

    public VersionTreeViewer(Composite parent) {
        this.m_parent = parent;
        this.initializeControl();
    }

    private void initializeControl() {
        this.m_canvasInView = new SashForm(this.m_parent, 0);
        this.m_versionControl = new VersionTreeControl(this.m_canvasInView, 0);
        this.m_versionControl.addVersionSelectionListener(this);
        this.m_selectedVersionRelation = null;
        this.m_selectedVersions = null;
        this.m_selectedWorkspacePath = null;
        this.m_versionControl.getBodyArea().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
                int currentValue = 0;
                if (ke.keyCode == 262144) {
                    ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_CtrlKeyPressed = true;
                } else {
                    switch (ke.keyCode) {
                        case 0x1000006: {
                            currentValue = ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().getValue();
                            int pageIncrement = ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getBounds().height;
                            ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().setValue(currentValue + pageIncrement);
                            break;
                        }
                        case 0x1000005: {
                            currentValue = ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().getValue();
                            int pageDecrement = ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getBounds().height;
                            ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().setValue(currentValue - pageDecrement);
                            break;
                        }
                        case 0x1000002: {
                            currentValue = ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().getValue();
                            ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().setValue(currentValue + 25);
                            break;
                        }
                        case 0x1000001: {
                            currentValue = ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().getValue();
                            ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().setValue(currentValue - 25);
                            break;
                        }
                        case 0x1000004: {
                            currentValue = ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getHorizontalScrollBar().getValue();
                            ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getHorizontalScrollBar().setValue(currentValue + 25);
                            break;
                        }
                        case 0x1000003: {
                            currentValue = ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getHorizontalScrollBar().getValue();
                            ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getHorizontalScrollBar().setValue(currentValue - 25);
                            break;
                        }
                        case 0x1000008: {
                            currentValue = ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().getValue();
                            ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().setValue(currentValue + ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_versionView.getBounds().height);
                            break;
                        }
                        case 0x1000007: {
                            ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_scrollPane.getVerticalScrollBar().setValue(0);
                        }
                    }
                }
            }

            public void keyReleased(KeyEvent ke) {
                if (ke.keyCode == 262144) {
                    ((VersionTreeViewer)VersionTreeViewer.this).m_versionControl.m_CtrlKeyPressed = false;
                }
            }
        });
    }

    public Control getControl() {
        return this.m_versionControl;
    }

    public ISelection getSelection() {
        if (this.m_selectedVersions == null && this.m_selectedVersionRelation == null && this.m_selectedWorkspacePath == null) {
            return StructuredSelection.EMPTY;
        }
        if (this.selection == null) {
            if (this.m_selectedVersions != null) {
                this.selection = new StructuredSelection((Object[])this.m_selectedVersions);
            } else if (this.m_selectedVersionRelation != null) {
                this.selection = this.m_selectedVersionRelation.getRelationType() == VfsVersionRelationType.PRED_SUCC_COLLISION || this.m_selectedVersionRelation.getRelationType() == VfsVersionRelationType.CYCLIC_MERGE_COLLISION ? new StructuredSelection((Object)this.m_selectedVersionRelation.getIntegrateCollision()) : new StructuredSelection((Object)this.m_selectedVersionRelation);
            } else if (this.m_selectedWorkspacePath != null) {
                this.selection = new StructuredSelection((Object)this.m_selectedWorkspacePath);
            }
        }
        return this.selection;
    }

    public void refresh() {
        if (this.m_versionControl != null) {
            this.m_versionControl.refreshCurrentHistory();
        }
    }

    public void setMergeArrowVisibility(boolean show) {
        this.m_versionControl.setEditMergeArrowVisibility(show);
    }

    void loadExistingHistory(String resourceName) {
        this.m_currentVersionHistory = this.m_versionControl.loadExistingHistory(resourceName);
    }

    public void setInput(Object input) {
        this.m_currentVersionHistory = (IVfsVersionHistory)((Object[])input)[0];
        this.m_activeWorkspace = (IVfsWorkspace)((Object[])input)[1];
        IVfsVersion[] versions = this.m_currentVersionHistory.getVersionSet();
        if (versions != null && versions.length > 0) {
            this.m_selectedVersions = new IVfsVersion[1];
            this.m_selectedVersions[0] = versions[0];
        }
        this.m_versionControl.showVersionHistory(this.m_currentVersionHistory, this.m_activeWorkspace);
    }

    public Object getInput() {
        return this.m_currentVersionHistory;
    }

    public void setControlVisible(boolean visible) {
    }

    public void setSelection(ISelection selection, boolean reveal) {
        Logbook.getPlainChapter((int)3).println("VersionTreeViewer.setSelection" + selection);
    }

    public void addVersionSelectionListener(VersionSelectionListener listener) {
        this.m_versionControl.addVersionSelectionListener(listener);
    }

    public void removeVersionSelectionListener(VersionSelectionListener listener) {
        this.m_versionControl.removeVersionSelectionListener(listener);
    }

    public void versionsSelected(VersionTreeControl control, IVfsVersion[] versions) {
        this.m_selectedVersions = versions;
        this.selection = null;
        this.m_selectedVersionRelation = null;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    public void versionRelationSelected(VersionTreeControl control, IVfsVersionRelation versionRelation) {
        if (this.m_selectedVersionRelation == null || this.m_selectedVersionRelation != versionRelation) {
            this.m_selectedVersionRelation = versionRelation;
            this.selection = null;
            this.m_selectedVersions = null;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public void workspaceSelected(VersionTreeControl control, String workspaceRemotePath) {
        if (this.m_selectedWorkspacePath == null || !this.m_selectedWorkspacePath.equalsIgnoreCase(workspaceRemotePath)) {
            this.m_selectedWorkspacePath = workspaceRemotePath;
            this.m_selectedVersionRelation = null;
            this.selection = null;
            this.m_selectedVersions = null;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public void removeInput() {
        this.m_versionControl.unloadAllHistoriesAndReinitialize();
        this.m_selectedVersions = null;
        this.m_selectedVersionRelation = null;
        this.m_selectedWorkspacePath = null;
        this.m_activeWorkspace = null;
        this.m_currentVersionHistory = null;
    }
}

