/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.vtree;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.LegendDialog;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.VFSAdaptableSelectionProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.VfsResourceTransfer;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionSelectionListener;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeControl;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeViewer;
import com.tssap.dtr.client.eclipse.util.ILegend;
import com.tssap.dtr.client.eclipse.util.LegendElement;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IConfigurationListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;

public class VersionTreeView
extends ViewPart
implements ISetSelectionTarget,
IConfigurationListener,
VersionSelectionListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$vtree$VersionTreeView == null ? (class$com$tssap$dtr$client$eclipse$ui$vtree$VersionTreeView = VersionTreeView.class$("com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView")) : class$com$tssap$dtr$client$eclipse$ui$vtree$VersionTreeView));
    private static final String REFRESH_ACTION_TEXT = "Refresh";
    private static final String REFRESH_ACTION_ICON = "refresh.gif";
    private static final String SHOW_EDITMERGE_ARROWS = "ShowEditMergeArrows";
    private static final String SHOW_EDITMERGE_ACTION_TEXT = "Show Edit Merge Arrows";
    private static final String SHOW_EDITMERGE_ACTION_ICON = "showEditMerge.gif";
    private static final String SHOW_BRANCH_SEQ_NUMBERS = "ShowBranchSeqNumbers";
    private static final String SHOW_BRANCH_SEQ_NUM_ACTION_TEXT = "Show Branch Sequence Numbers";
    private static final String SHOW_BRANCH_SEQ_NUM_ACTION_ICON = "showbranchseqnumbers.gif";
    private static final String SHOW_BOTTOM_TOP = "ShowBottomTop";
    private static final String SHOW_BOTTOM_TOP_ACTION_TEXT = "Show Graph from Bottom to Top";
    private static final String SHOW_BOTTOM_TOP_ACTION_ICON = "showgraphbottomtop.gif";
    private static final String SHOW_ACTIVE_VERSION = "ShowActiveVersion";
    private static final String SHOW_ACTIVE_VERSION_ACTION_TEXT = "Show Active Version in Selected Workspace";
    private static final String SHOW_ACTIVE_VERSION_ACTION_ICON = "showactiveversion.gif";
    private static final String SHOW_LEGEND_ACTION_TEXT = "Display Legend";
    private static final ImageDescriptor IMAGE_DESCRIPTOR_LEGEND = BluebirdPlugin.getDefault().createImageDescriptor("showlegend.gif");
    private static final String SHOW = "Show";
    private static final String DO_NOT_SHOW = "DoNotShow";
    private static final String ACTIVE_WORKSPACE_TOOLTIP = "Selected Workspace: ";
    private static final boolean DEBUG = false;
    private VersionTreeViewer m_vTreeViewer;
    private VersionTreeControl m_versionTreeControl;
    private Action m_refreshViewAction;
    private Action m_showEditMergeArrowAction;
    private Action m_showBranchSequenceNumbersAction;
    private Action m_showBottomTopAction;
    private Action m_showActiveVersionAction;
    private Action m_showLegendAction;
    private HashMap m_loadedResources;
    private HashMap m_workspacesInCurrentTree;
    private HashMap m_workspaceActions;
    private boolean m_HistoryToolItemAdded;
    private boolean m_workspaceToolItemAdded;
    private boolean m_showEditMergeArrows;
    private boolean m_showBranchSequenceNumbers;
    private boolean m_showActiveVersion;
    private boolean m_showBottomTop;
    private Composite m_parentComposite;
    private IAction m_workspaceToolItemAction;
    private IVfsWorkspace m_workspaceSelectedInGraphToShow;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$vtree$VersionTreeView;

    public VersionTreeView() {
        Configuration.getConfiguration().addConfigurationListener((IConfigurationListener)this);
    }

    public void dispose() {
        Configuration.getConfiguration().removeConfigurationListener((IConfigurationListener)this);
        this.persistUserPreferences();
        super.dispose();
    }

    public void createPartControl(Composite arg0) {
        try {
            this.m_parentComposite = arg0;
            this.m_HistoryToolItemAdded = false;
            this.m_workspaceToolItemAdded = false;
            this.m_showEditMergeArrows = false;
            this.m_showBranchSequenceNumbers = false;
            this.m_showBottomTop = false;
            this.m_showActiveVersion = false;
            this.m_loadedResources = new HashMap();
            this.m_workspacesInCurrentTree = new HashMap();
            this.m_workspaceActions = new HashMap();
            this.initializeViewer();
            this.restoreUserPreferences();
            this.createActions();
            this.createToolbar();
            this.createMenu();
            this.createContextMenu();
        }
        catch (Exception e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    private void initializeViewer() {
        this.m_vTreeViewer = new VersionTreeViewer(this.m_parentComposite);
        this.m_versionTreeControl = (VersionTreeControl)this.m_vTreeViewer.getControl();
        this.m_versionTreeControl.addVersionSelectionListener(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_vTreeViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)new VFSAdaptableSelectionProvider((ISelectionProvider)this.m_vTreeViewer));
        this.initDragAndDrop();
    }

    private void initDragAndDrop() {
        this.initDrop();
    }

    private void initDrop() {
        Transfer[] types = new Transfer[]{VfsResourceTransfer.getInstance(), ResourceTransfer.getInstance()};
        if (this.m_vTreeViewer != null) {
            DropTarget dropTarget = new DropTarget((Control)this.m_parentComposite, 1);
            dropTarget.setTransfer(types);
            dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                public void dragOver(DropTargetEvent event) {
                    event.detail = 0;
                    if (VfsResourceTransfer.getInstance().isSupportedType(event.currentDataType)) {
                        this.validateVFSResource(event);
                    } else if (ResourceTransfer.getInstance().isSupportedType(event.currentDataType)) {
                        event.detail = 1;
                    }
                }

                private void validateVFSResource(DropTargetEvent event) {
                    ISelection selection = VfsResourceTransfer.getInstance().getSelection();
                    event.detail = 0;
                    if (selection.isEmpty()) {
                        return;
                    }
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection sel = (IStructuredSelection)selection;
                        if (sel.size() > 1) {
                            return;
                        }
                        if (sel.getFirstElement() instanceof IVfsFile) {
                            IVfsFile file = (IVfsFile)sel.getFirstElement();
                            if (!file.getLocationState().equals(VfsFolderItemLocationState.LOCAL_ONLY)) {
                                event.detail = 1;
                            }
                        } else if (sel.getFirstElement() instanceof IVfsIntegrateCollision) {
                            event.detail = 1;
                        } else if (sel.getFirstElement() instanceof IVfsVersion) {
                            IVfsVersion version = (IVfsVersion)sel.getFirstElement();
                            try {
                                if (version.isFile()) {
                                    event.detail = 1;
                                }
                            }
                            catch (VfsException e) {
                                LogUtil.logException((Location)LOCATION, (Throwable)e);
                            }
                        }
                    }
                }

                public void drop(DropTargetEvent event) {
                    BusyIndicator.showWhile((Display)VersionTreeView.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(this, event){
                        private final /* synthetic */ DropTargetEvent val$event;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$event = val$event;
                        }

                        public void run() {
                            if (VfsResourceTransfer.getInstance().isSupportedType(this.val$event.currentDataType)) {
                                1.access$100(this.this$1, this.val$event);
                            } else if (ResourceTransfer.getInstance().isSupportedType(this.val$event.currentDataType)) {
                                1.access$200(this.this$1, this.val$event);
                            }
                        }
                    });
                }

                private void handleResource(DropTargetEvent event) {
                    Object[] data;
                    if (event.data != null && event.data instanceof Object[] && (data = (Object[])event.data).length == 1 && data[0] instanceof IFile) {
                        IFile file = (IFile)data[0];
                        DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider((IResource)file);
                        IVfsFile vfsFile = (IVfsFile)provider.getFolderItem((IResource)file);
                        VersionTreeView.this.selectReveal((ISelection)new StructuredSelection((Object)vfsFile));
                    }
                }

                private void handleVFSResource(DropTargetEvent event) {
                    IWorkbenchPage activePage;
                    IWorkbenchWindow activeWindow;
                    ISelection selection = VfsResourceTransfer.getInstance().getSelection();
                    if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IVfsVersion && (activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = activeWindow.getActivePage()) != null) {
                        IViewPart part = activePage.findView(VfsResourceTransfer.getInstance().getSourceViewID());
                        IVfsVersion version = (IVfsVersion)((IStructuredSelection)selection).getFirstElement();
                        Object[] parentObjects = this.getParentObjectForTreeSelection(version, 1, part);
                        IVfsWorkspace workspace = null;
                        if (parentObjects.length == 1 && parentObjects[0] instanceof IVfsIntegrateCollision) {
                            IVfsIntegrateCollision parentCollision = (IVfsIntegrateCollision)parentObjects[0];
                            try {
                                if (version.getVersionId().equalsIgnoreCase(parentCollision.getActiveVersion().getVersionId())) {
                                    workspace = parentCollision.getWorkspace();
                                }
                                workspace = parentCollision.getIntegratedActivity().getCreationWorkspace();
                            }
                            catch (VfsException e) {
                                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                                return;
                            }
                        } else {
                            Object[] parentWorkspaces = this.getParentObjectForTreeSelection(version, 2, part);
                            if (parentWorkspaces.length == 1 && parentWorkspaces[0] instanceof IVfsWorkspace) {
                                workspace = (IVfsWorkspace)parentWorkspaces[0];
                            }
                        }
                        VersionTreeView.this.setWorkspaceSelection(workspace);
                    }
                    VersionTreeView.this.selectReveal(selection);
                }

                protected Object[] getParentObjectForTreeSelection(Object selectedObject, int aboveLevel, IViewPart targetPart) {
                    HashSet<Object> parents = new HashSet<Object>();
                    if (targetPart instanceof RepositoryView) {
                        if (aboveLevel < 1) {
                            return new Object[]{selectedObject};
                        }
                        HashSet<TreeItem> correspondingTreeItems = new HashSet<TreeItem>();
                        TreeItem[] selectedTreeItems = ((RepositoryView)targetPart).getRepositoryTreeViewer().getTreeViewer().getTree().getSelection();
                        int i = 0;
                        while (i < selectedTreeItems.length) {
                            if (selectedTreeItems[i].getData().equals(selectedObject)) {
                                correspondingTreeItems.add(selectedTreeItems[i]);
                            }
                            ++i;
                        }
                        Iterator iter = correspondingTreeItems.iterator();
                        while (iter.hasNext()) {
                            TreeItem parentTreeItem = (TreeItem)iter.next();
                            int i2 = 0;
                            while (i2 < aboveLevel) {
                                if ((parentTreeItem = parentTreeItem.getParentItem()) == null) break;
                                ++i2;
                            }
                            if (parentTreeItem == null) continue;
                            parents.add(parentTreeItem.getData());
                        }
                    }
                    return parents.toArray();
                }

                static /* synthetic */ void access$100(1 x0, DropTargetEvent x1) {
                    x0.handleVFSResource(x1);
                }

                static /* synthetic */ void access$200(1 x0, DropTargetEvent x1) {
                    x0.handleResource(x1);
                }
            });
        }
    }

    public void selectReveal(ISelection selection) {
        IVfsVersion version;
        IVfsWorkspace workspace;
        block16: {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            workspace = null;
            version = null;
            if (selected instanceof IVfsFile) {
                IVfsFile versionFile = (IVfsFile)selected;
                workspace = versionFile.getWorkspace();
                try {
                    version = versionFile.refreshAndGetVersion();
                    if (version == null) {
                        Logbook.getErrorChapter().println("Unable to retrieve version from file.");
                        MessageDialog.openError((Shell)this.m_parentComposite.getShell(), (String)"Show Version Graph", (String)"Unable to load Version Graph. See log for details.");
                        return;
                    }
                    break block16;
                }
                catch (Exception x) {
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                    return;
                }
            }
            if (selected instanceof IVfsIntegrateCollision) {
                IVfsIntegrateCollision selectedCollision = (IVfsIntegrateCollision)selected;
                version = selectedCollision.getActiveVersion();
                workspace = selectedCollision.getWorkspace();
            } else if (selected instanceof IVfsVersion) {
                version = (IVfsVersion)selected;
                workspace = version.getCreatorWorkspace();
            } else if (selected instanceof IVfsActivityElement) {
                version = ((IVfsActivityElement)selected).getAsVersion();
                if (version != null) {
                    workspace = version.getCreatorWorkspace();
                } else {
                    IVfsActivityRecordedFolderItem folderItem = ((IVfsActivityElement)selected).getAsActivityRecordedFolderItem();
                    this.selectReveal((ISelection)new StructuredSelection((Object)folderItem));
                }
            } else {
                Logbook.getErrorChapter().println("Invalid selection. Unable to display version graph");
                return;
            }
        }
        IVfsVersionHistory versionHistory = version.getVersionHistoryWithRefresh();
        if (versionHistory == null) {
            Logbook.getErrorChapter().println("Unable to retrieve version history.");
            MessageDialog.openError((Shell)this.m_parentComposite.getShell(), (String)"Show Version Graph", (String)"Unable to load Version Graph. See log for details.");
            return;
        }
        if (this.m_workspaceSelectedInGraphToShow != null) {
            workspace = this.m_workspaceSelectedInGraphToShow;
        }
        if (workspace == null) {
            Logbook.getErrorChapter().println("Unable to retrieve workspace context for version history");
            MessageDialog.openError((Shell)this.m_parentComposite.getShell(), (String)"Show Version Graph", (String)"Unable to load Version Graph. See log for details.");
            return;
        }
        this.showVersionTree(versionHistory, workspace, version.toString());
        this.m_workspaceSelectedInGraphToShow = null;
    }

    private void showVersionTree(IVfsVersionHistory versionHistory, IVfsWorkspace currentWorkspace, String title) {
        Object[] inputCollection = new Object[]{versionHistory, currentWorkspace};
        this.m_versionTreeControl.setProperties(this.m_showEditMergeArrows, this.m_showBranchSequenceNumbers, this.m_showBottomTop, this.m_showActiveVersion);
        this.m_vTreeViewer.setInput(inputCollection);
        if (!this.m_workspaceToolItemAdded) {
            this.addWorkspaceToolItem();
        }
        if (!this.m_HistoryToolItemAdded) {
            this.addHistoryToolItem();
        }
        this.addNewAction(this.getHistoryActionText(versionHistory), this.m_versionTreeControl.getVersionHistoryKey(versionHistory));
        this.refreshWorkspaceActions();
        this.setTitleAndStatusBar(this.getHistoryActionText(versionHistory));
        this.setFocus();
    }

    private void setTitleAndStatusBar(String name) {
        this.setTitle("Version Graph - " + name);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage("Version Graph - " + name);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private String getHistoryActionText(IVfsVersionHistory versionHistory) {
        return versionHistory.getRootVersion().getDisplayName() + " [" + versionHistory.getVersionedFileSystemManager().getClientName() + "] ";
    }

    private void addNewAction(String name, String identifier) {
        if (!this.m_loadedResources.containsKey(identifier)) {
            Action thisAction = new Action(name){

                public void run() {
                    VersionTreeView.this.showVersionHistory(this.getId(), this.getText());
                    VersionTreeView.this.uncheckAllActions(VersionTreeView.this.m_loadedResources);
                    this.setChecked(true);
                    VersionTreeView.this.refreshWorkspaceActions();
                }
            };
            thisAction.setId(identifier);
            this.uncheckAllActions(this.m_loadedResources);
            thisAction.setChecked(true);
            this.m_loadedResources.put(identifier, thisAction);
        } else {
            this.uncheckAllActions(this.m_loadedResources);
            ((IAction)this.m_loadedResources.get(identifier)).setChecked(true);
        }
    }

    private void refreshWorkspaceActions() {
        this.removeExistingWorkspaceActions();
        Object[] workspaces = this.m_versionTreeControl.m_currentVersionTree.getAllWorkspaces();
        boolean actionAdded = false;
        int i = 0;
        while (i < workspaces.length) {
            if (workspaces[i] instanceof IVfsWorkspace) {
                actionAdded = this.addWorkspaceAction(((IVfsWorkspace)workspaces[i]).getAbsoluteRemotePath());
                if (actionAdded) {
                    this.m_workspacesInCurrentTree.put(((IVfsWorkspace)workspaces[i]).getAbsoluteRemotePath(), (IVfsWorkspace)workspaces[i]);
                }
            } else {
                actionAdded = this.addWorkspaceAction((String)workspaces[i]);
                if (actionAdded) {
                    this.m_workspacesInCurrentTree.put(workspaces[i], null);
                }
            }
            ++i;
        }
    }

    private boolean addWorkspaceAction(String workspaceRemotePath) {
        if (!this.m_workspacesInCurrentTree.containsKey(workspaceRemotePath)) {
            Action thisAction = new Action(workspaceRemotePath){

                public void run() {
                    VersionTreeView.this.m_versionTreeControl.setActiveWorkspace((IVfsWorkspace)VersionTreeView.this.m_workspacesInCurrentTree.get(this.getText()), this.getText());
                    VersionTreeView.this.uncheckAllActions(VersionTreeView.this.m_workspaceActions);
                    this.setChecked(true);
                    VersionTreeView.this.m_workspaceToolItemAction.setToolTipText(VersionTreeView.ACTIVE_WORKSPACE_TOOLTIP + this.getText());
                }
            };
            this.m_workspaceActions.put(workspaceRemotePath, thisAction);
            if (workspaceRemotePath.equalsIgnoreCase(this.m_versionTreeControl.m_currentVersionTree.getActiveWorkspacePath())) {
                thisAction.setChecked(true);
                this.m_workspaceToolItemAction.setToolTipText(ACTIVE_WORKSPACE_TOOLTIP + thisAction.getText());
            }
            return true;
        }
        return false;
    }

    private void removeExistingWorkspaceActions() {
        if (this.m_workspaceActions != null) {
            Iterator iter = this.m_workspaceActions.values().iterator();
            while (iter.hasNext()) {
                Action workspaceAction = (Action)iter.next();
                workspaceAction = null;
                iter.remove();
            }
        }
        if (this.m_workspacesInCurrentTree != null) {
            this.m_workspacesInCurrentTree.clear();
        }
    }

    void uncheckAllActions(HashMap actionsMap) {
        Iterator it = actionsMap.values().iterator();
        while (it.hasNext()) {
            ((IAction)it.next()).setChecked(false);
        }
    }

    public void setFocus() {
        this.m_versionTreeControl.setFocus();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createActions() {
        this.createRefreshAction();
        this.createShowEditMergeArrowAction();
        this.createShowBranchSeqNumAction();
        this.createShowBottomTopAction();
        this.createShowActiveVersionAction();
        this.createShowLegendAction();
    }

    private void createRefreshAction() {
        String imagePath = REFRESH_ACTION_ICON;
        final ImageDescriptor refreshImage = BluebirdPlugin.getDefault().createImageDescriptor(imagePath);
        this.m_refreshViewAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (VersionTreeView.access$1000(5.access$900(this.this$1)) != null) {
                            VersionTreeView.access$1000(5.access$900(this.this$1)).refresh();
                        }
                    }
                });
            }

            public ImageDescriptor getImageDescriptor() {
                return refreshImage;
            }

            public String getToolTipText() {
                return VersionTreeView.REFRESH_ACTION_TEXT;
            }

            public String getText() {
                return VersionTreeView.REFRESH_ACTION_TEXT;
            }

            static /* synthetic */ VersionTreeView access$900(5 x0) {
                return x0.VersionTreeView.this;
            }
        };
    }

    private void createShowEditMergeArrowAction() {
        final ImageDescriptor showEditMergeImage = BluebirdPlugin.getDefault().createImageDescriptor(SHOW_EDITMERGE_ACTION_ICON);
        this.m_showEditMergeArrowAction = new Action(){

            public void run() {
                if (VersionTreeView.this.m_vTreeViewer != null) {
                    VersionTreeView.this.m_vTreeViewer.setMergeArrowVisibility(this.isChecked());
                    VersionTreeView.this.m_showEditMergeArrows = this.isChecked();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return showEditMergeImage;
            }

            public String getToolTipText() {
                return VersionTreeView.SHOW_EDITMERGE_ACTION_TEXT;
            }

            public String getText() {
                return VersionTreeView.SHOW_EDITMERGE_ACTION_TEXT;
            }
        };
        this.m_showEditMergeArrowAction.setChecked(this.m_showEditMergeArrows);
    }

    private void createShowBranchSeqNumAction() {
        final ImageDescriptor showBranchSeqNumImage = BluebirdPlugin.getDefault().createImageDescriptor(SHOW_BRANCH_SEQ_NUM_ACTION_ICON);
        this.m_showBranchSequenceNumbersAction = new Action(){

            public void run() {
                if (VersionTreeView.this.m_versionTreeControl != null) {
                    VersionTreeView.this.m_versionTreeControl.setBranchSequenceNumberVisibility(this.isChecked());
                    VersionTreeView.this.m_showBranchSequenceNumbers = this.isChecked();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return showBranchSeqNumImage;
            }

            public String getToolTipText() {
                return VersionTreeView.SHOW_BRANCH_SEQ_NUM_ACTION_TEXT;
            }

            public String getText() {
                return VersionTreeView.SHOW_BRANCH_SEQ_NUM_ACTION_TEXT;
            }
        };
        this.m_showBranchSequenceNumbersAction.setChecked(this.m_showBranchSequenceNumbers);
    }

    private void createShowActiveVersionAction() {
        final ImageDescriptor showActiveVersionImage = BluebirdPlugin.getDefault().createImageDescriptor(SHOW_ACTIVE_VERSION_ACTION_ICON);
        this.m_showActiveVersionAction = new Action(){

            public void run() {
                if (VersionTreeView.this.m_vTreeViewer != null) {
                    VersionTreeView.this.m_versionTreeControl.showActiveVersion(this.isChecked());
                    VersionTreeView.this.m_showActiveVersion = this.isChecked();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return showActiveVersionImage;
            }

            public String getToolTipText() {
                return VersionTreeView.SHOW_ACTIVE_VERSION_ACTION_TEXT;
            }

            public String getText() {
                return VersionTreeView.SHOW_ACTIVE_VERSION_ACTION_TEXT;
            }
        };
        this.m_showActiveVersionAction.setChecked(this.m_showActiveVersion);
    }

    private void createShowLegendAction() {
        this.m_showLegendAction = new Action(){

            public void run() {
                VersionTreeView.this.showVersionLegends();
            }

            public ImageDescriptor getImageDescriptor() {
                return IMAGE_DESCRIPTOR_LEGEND;
            }

            public String getToolTipText() {
                return VersionTreeView.SHOW_LEGEND_ACTION_TEXT;
            }

            public String getText() {
                return VersionTreeView.SHOW_LEGEND_ACTION_TEXT;
            }
        };
    }

    private void createShowBottomTopAction() {
        final ImageDescriptor flipGraphDirectionImage = BluebirdPlugin.getDefault().createImageDescriptor(SHOW_BOTTOM_TOP_ACTION_ICON);
        this.m_showBottomTopAction = new Action(){

            public void run() {
                if (VersionTreeView.this.m_versionTreeControl != null) {
                    VersionTreeView.this.m_versionTreeControl.setGraphDirection(this.isChecked());
                    VersionTreeView.this.m_showBottomTop = this.isChecked();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return flipGraphDirectionImage;
            }

            public String getToolTipText() {
                return VersionTreeView.SHOW_BOTTOM_TOP_ACTION_TEXT;
            }

            public String getText() {
                return VersionTreeView.SHOW_BOTTOM_TOP_ACTION_TEXT;
            }
        };
        this.m_showBottomTopAction.setChecked(this.m_showBottomTop);
    }

    private void showVersionLegends() {
        ILegend[] legends = new ILegend[]{new LegendElement(this.getImageDescriptor("/versiongraph/openversion.gif").createImage(true), "Open Version (Represents a Checked-Out file). The black border indicates that it was created in the workspace currently selected in Version Graph."), new LegendElement(this.getImageDescriptor("/versiongraph/inactiveopenversion.gif").createImage(true), "Open Version (Represents a Checked-Out file). The gray border indicates that it was not created in the Workspace currently selected in Version Graph."), new LegendElement(this.getImageDescriptor("/versiongraph/closedversion.gif").createImage(true), "Closed Version (Represents a Checked-In file). The black border indicates that it was active at some point of time in the Workspace currently selected in Version Graph."), new LegendElement(this.getImageDescriptor("/versiongraph/inactiveversion.gif").createImage(true), "Closed Version (Represents a Checked-In file). The gray border indicates that it was never active in the Workspace currently selected in Version Graph."), new LegendElement(this.getImageDescriptor("/versiongraph/syncdversionmarker.gif").createImage(true), "Points to a Version synced locally in the Workspace currently selected in Version Graph."), new LegendElement(this.getImageDescriptor("/versiongraph/activeversionmarker.gif").createImage(true), "Points to the Active Version in the Workspace currently selected in the Version Graph."), new LegendElement(this.getImageDescriptor("/versiongraph/deletedversionmarker.gif").createImage(true), "Points to a deleted Version."), new LegendElement(this.getImageDescriptor("/versiongraph/pseudopredecessor.gif").createImage(true), "Pseudo predecessor-successor arrow. The source Version of this arrow is not the real predecessor of the target Version. (The real predecessor can be found at the source of a Copy Merge arrow to the target Version)."), new LegendElement(this.getImageDescriptor("/versiongraph/copymerge.gif").createImage(true), "Copy Merge arrow. Indicates that the source of this arrow is the Version whose contents were copied to the target Version when it was created."), new LegendElement(this.getImageDescriptor("/versiongraph/merge.gif").createImage(true), "Merge arrow. Created when an Integration Conflict is resolved by a Merge."), new LegendElement(this.getImageDescriptor("/versiongraph/discardmerge.gif").createImage(true), "Discard arrow. Created when an Integration Conflict is resolved by a Discard."), new LegendElement(this.getImageDescriptor("/versiongraph/integrateconflict.gif").createImage(true), "Integration Conflict in Workspace currently selected in Version Graph. Created when a version is integrated from another workspace.")};
        new LegendDialog(this.m_parentComposite.getShell(), "Version Graph", IMAGE_DESCRIPTOR_LEGEND.createImage(true), legends).open();
    }

    void addWorkspaceToolItem() {
        this.m_workspaceToolItemAdded = true;
        this.m_workspaceToolItemAction = new Action("Dummy"){

            public void run() {
            }
        };
        ToolBarManager toolMgr = (ToolBarManager)this.getViewSite().getActionBars().getToolBarManager();
        this.m_workspaceToolItemAction.setToolTipText("Workspaces in Graph");
        this.m_workspaceToolItemAction.setImageDescriptor(this.getImageDescriptor("browserIcons\\WORKSPACE.gif"));
        this.m_workspaceToolItemAction.setMenuCreator(new IMenuCreator(){

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                MenuManager menuMgr = new MenuManager();
                menuMgr.setRemoveAllWhenShown(true);
                menuMgr.addMenuListener(new IMenuListener(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void menuAboutToShow(IMenuManager mgr) {
                        13.access$1700(this.this$1).fillWorkspaceDropDownMenu(mgr);
                    }
                });
                Menu thisMenu = menuMgr.createContextMenu(parent);
                return thisMenu;
            }

            public Menu getMenu(Menu parent) {
                Menu thisMenu = new Menu(parent);
                Action myAct = new Action(this, "DropAction"){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Logbook.getPlainChapter((int)3).println("Called Drop Action");
                    }
                };
                ActionContributionItem myActItem = new ActionContributionItem((IAction)myAct);
                myActItem.fill(thisMenu, -1);
                return thisMenu;
            }

            static /* synthetic */ VersionTreeView access$1700(13 x0) {
                return x0.VersionTreeView.this;
            }
        });
        toolMgr.add((IContributionItem)new ActionContributionItem(this.m_workspaceToolItemAction));
    }

    void fillWorkspaceDropDownMenu(IMenuManager mgr) {
        ArrayList listOfWorkspaceActions = new ArrayList(this.m_workspaceActions.values());
        Collections.sort(listOfWorkspaceActions, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                IAction first = (IAction)arg0;
                IAction second = (IAction)arg1;
                return first.getText().compareTo(second.getText());
            }
        });
        Iterator it = ((AbstractList)listOfWorkspaceActions).iterator();
        while (it.hasNext()) {
            mgr.add((IAction)it.next());
        }
    }

    void addHistoryToolItem() {
        this.m_HistoryToolItemAdded = true;
        Action thisAction = new Action("Dummy"){

            public void run() {
            }
        };
        ToolBarManager toolMgr = (ToolBarManager)this.getViewSite().getActionBars().getToolBarManager();
        thisAction.setToolTipText("Previous Version Graphs");
        thisAction.setImageDescriptor(this.getImageDescriptor("vtree.gif"));
        thisAction.setMenuCreator(new IMenuCreator(){

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                MenuManager menuMgr = new MenuManager();
                menuMgr.setRemoveAllWhenShown(true);
                menuMgr.addMenuListener(new IMenuListener(this){
                    private final /* synthetic */ 18 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void menuAboutToShow(IMenuManager mgr) {
                        18.access$1800(this.this$1).fillHistoryDropDownMenu(mgr);
                    }
                });
                Menu thisMenu = menuMgr.createContextMenu(parent);
                return thisMenu;
            }

            public Menu getMenu(Menu parent) {
                Menu thisMenu = new Menu(parent);
                Action myAct = new Action(this, "DropAction"){
                    private final /* synthetic */ 18 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Logbook.getPlainChapter((int)3).println("Called Drop Action");
                    }
                };
                ActionContributionItem myActItem = new ActionContributionItem((IAction)myAct);
                myActItem.fill(thisMenu, -1);
                return thisMenu;
            }

            static /* synthetic */ VersionTreeView access$1800(18 x0) {
                return x0.VersionTreeView.this;
            }
        });
        toolMgr.add((IContributionItem)new Separator());
        toolMgr.add((IContributionItem)new ActionContributionItem((IAction)thisAction));
    }

    void fillHistoryDropDownMenu(IMenuManager mgr) {
        Iterator it = this.m_loadedResources.values().iterator();
        while (it.hasNext()) {
            mgr.add((IAction)it.next());
        }
    }

    void showVersionHistory(String versionHistoryId, String resourceName) {
        this.m_vTreeViewer.loadExistingHistory(versionHistoryId);
        this.setTitleAndStatusBar(resourceName);
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add((IAction)this.m_showEditMergeArrowAction);
        mgr.add((IAction)this.m_showBranchSequenceNumbersAction);
        mgr.add((IAction)this.m_showBottomTopAction);
        mgr.add((IAction)this.m_showActiveVersionAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.m_showLegendAction);
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.m_refreshViewAction);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                VersionTreeView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.m_vTreeViewer.getControl());
        this.m_vTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_vTreeViewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("dtr.dynamic"));
        manager.add((IContributionItem)new GroupMarker("dtr.dynamic-end"));
        manager.add((IContributionItem)new Separator("dtr.comfort"));
        manager.add((IContributionItem)new GroupMarker("dtr.comfort-end"));
        manager.add((IContributionItem)new Separator("dtr.main1"));
        manager.add((IContributionItem)new GroupMarker("dtr.main1-end"));
        manager.add((IContributionItem)new Separator("dtr.main2"));
        manager.add((IContributionItem)new GroupMarker("dtr.main2-end"));
        manager.add((IContributionItem)new Separator("dtr.change"));
        manager.add((IContributionItem)new GroupMarker("dtr.change-end"));
        manager.add((IContributionItem)new Separator("dtr.content"));
        manager.add((IContributionItem)new GroupMarker("dtr.content-end"));
        manager.add((IContributionItem)new Separator("dtr.navigation"));
        manager.add((IContributionItem)new GroupMarker("dtr.navigation-end"));
        manager.add((IContributionItem)new Separator("dtr.additions1"));
        manager.add((IContributionItem)new GroupMarker("dtr.additions1-end"));
        manager.add((IContributionItem)new Separator("dtr.additions2"));
        manager.add((IContributionItem)new GroupMarker("dtr.additions2-end"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("dtr.properties"));
        manager.add((IContributionItem)new GroupMarker("dtr.properties-end"));
    }

    private ImageDescriptor getImageDescriptor(String relativePath) {
        return BluebirdPlugin.getDefault().createImageDescriptor(relativePath);
    }

    public void onActiveClientChanged(IClient newClient, IClient oldClient) {
        if (this.m_loadedResources != null) {
            this.m_loadedResources.clear();
        }
        this.removeExistingWorkspaceActions();
        if (this.m_workspaceToolItemAction != null) {
            this.m_workspaceToolItemAction.setToolTipText("Workspaces in Graph");
        }
        if (this.m_vTreeViewer != null) {
            this.m_vTreeViewer.removeInput();
        }
        this.setTitle("Version Graph ");
    }

    public void onConfigurationChanged(IConfiguration configuration) {
    }

    public IVfsWorkspace getActiveWorkspace() {
        return this.m_versionTreeControl.m_currentVersionTree.getActiveWorkspace();
    }

    public String getActiveWorkspacePath() {
        return this.m_versionTreeControl.m_currentVersionTree.getActiveWorkspacePath();
    }

    public void versionsSelected(VersionTreeControl control, IVfsVersion[] versions) {
    }

    public void versionRelationSelected(VersionTreeControl control, IVfsVersionRelation versionRelationType) {
    }

    public void workspaceSelected(VersionTreeControl control, String workspaceRemotePath) {
        this.uncheckAllActions(this.m_workspaceActions);
        IAction thisWorkspaceAction = (IAction)this.m_workspaceActions.get(workspaceRemotePath);
        thisWorkspaceAction.setChecked(true);
        this.m_workspaceToolItemAction.setToolTipText(ACTIVE_WORKSPACE_TOOLTIP + thisWorkspaceAction.getText());
    }

    private void persistUserPreferences() {
        this.getPreferenceStore().setValue(SHOW_EDITMERGE_ARROWS, this.m_showEditMergeArrows ? SHOW : DO_NOT_SHOW);
        this.getPreferenceStore().setValue(SHOW_BRANCH_SEQ_NUMBERS, this.m_showBranchSequenceNumbers ? SHOW : DO_NOT_SHOW);
        this.getPreferenceStore().setValue(SHOW_BOTTOM_TOP, this.m_showBottomTop ? SHOW : DO_NOT_SHOW);
        this.getPreferenceStore().setValue(SHOW_ACTIVE_VERSION, this.m_showActiveVersion ? SHOW : DO_NOT_SHOW);
    }

    private IPreferenceStore getPreferenceStore() {
        return BluebirdPlugin.getDefault().getPreferenceStore();
    }

    private void restoreUserPreferences() {
        IPreferenceStore prefStore = this.getPreferenceStore();
        if (SHOW.equalsIgnoreCase(prefStore.getString(SHOW_EDITMERGE_ARROWS))) {
            this.m_showEditMergeArrows = true;
        }
        if (SHOW.equalsIgnoreCase(prefStore.getString(SHOW_BRANCH_SEQ_NUMBERS))) {
            this.m_showBranchSequenceNumbers = true;
        }
        if (SHOW.equalsIgnoreCase(prefStore.getString(SHOW_BOTTOM_TOP))) {
            this.m_showBottomTop = true;
        }
        if (SHOW.equalsIgnoreCase(prefStore.getString(SHOW_ACTIVE_VERSION))) {
            this.m_showActiveVersion = true;
        }
    }

    public void setWorkspaceSelection(IVfsWorkspace workspaceToBeSelected) {
        this.m_workspaceSelectedInGraphToShow = workspaceToBeSelected;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

