/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.vtree;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionGraphMouseListener;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionSelectionListener;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollisionListener;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionGraph;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionListener;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsRevisionComparator;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import com.tssap.dtr.client.lib.vfs.actions.IVfsActionListener;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsRevision;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersionGraph;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class VersionTreeControl
extends Canvas
implements PaintListener {
    private HashMap m_versionTrees;
    protected VersionTree m_currentVersionTree;
    private Point imageSize;
    protected boolean m_CtrlKeyPressed;
    protected HashSet m_selectedNodes;
    protected ArrayList m_selectedVersions;
    protected Label m_selectedLabel;
    protected PolylineConnection m_selectedConnection;
    private int m_layoutStyle;
    private boolean m_showEditMergeArrows;
    private boolean m_showBranchSequenceNumbers;
    private boolean m_showBottomTopView;
    private boolean m_navigateToActiveVersion;
    protected ScrollPane m_scrollPane;
    protected IFigure m_versionView;
    private LightweightSystem m_lws;
    protected SashForm m_graphArea;
    protected Canvas m_bodyArea;
    protected Canvas m_headerArea;
    protected ScrollPane m_headerScrollPane;
    protected IFigure m_headerVersionView;
    private LightweightSystem m_headerLWS;
    private Shell m_shell;
    private ArrayList listeners;
    static final int HORIZONTAL_SPAN = 120;
    static final int VERTICAL_SPAN = 50;
    private static final int DRAW_ELEMENT_WIDTH = 30;
    private static final int DRAW_ELEMENT_HEIGHT = 30;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int DOTTED_LINE = 3;
    private static final Color MERGE_ARROW_COLOR = new Color(null, 0, 127, 0);
    private static final Color DISCARD_ARROW_COLOR = new Color(null, 0, 0, 127);
    private static final Color COLLISION_COLOR = new Color(null, 255, 0, 0);
    private static final Color PRED_SUCC_ARROW_COLOR = new Color(null, 0, 0, 0);
    private static final Color INACTIVE_ARROW_COLOR = new Color(null, 192, 192, 192);
    private static final Color ACTIVE_WORKSPACE_COLOR = ColorConstants.tooltipBackground;
    private static final Color INACTIVE_WORKSPACE_COLOR = ColorConstants.lightGray;
    private static final Color ACTIVE_VERSION_COLOR = ColorConstants.white;
    private static final Color INACTIVE_VERSION_COLOR = ColorConstants.lightGray;
    private static final Color OPEN_VERSION_COLOR = ColorConstants.white;
    private static final String COLLISION_TOOLTIP = "Conflict";
    private static final String COLLISION_ICON = "collision.gif";
    private static final String COLLIDING_VERSION = "Conflicting Version";
    private static final String ACTIVE_VERSION = "Active Version";
    private static final String MERGE_TOOLTIP = "Merge";
    private static final String MERGE_ICON = "merge.gif";
    private static final String COPYMERGE_TOOLTIP = "Copy Merge";
    private static final String COPYMERGE_ICON = "copymerge.gif";
    private static final String DISCARDMERGE_TOOLTIP = "Discard Merge";
    private static final String DISCARDMERGE_ICON = "copymerge.gif";
    private static final String ACTIVE_VERSION_IN_WORKSPACE = "Active Version in Workspace ";
    private static final String ACTIVE_VERSION_ICON = "activeversion.gif";
    private static final String DELETED_VERSION = "Deleted Version";
    private static final String DELETED_VERSION_ICON = "deletedversion.gif";
    private static final String SYNCED_VERSION_IN_ACTIVE_WORKSPACE = "Version on local client in Workspace ";
    private static final String SYNCED_VERSION_ICON = "syncdversion.gif";
    private static final String ACTIVE_VERSION_SYNCED = "Active version in Workspace, and version synced on Client";
    private static final boolean DEBUG_MODE = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$vtree$VersionTreeControl == null ? (class$com$tssap$dtr$client$eclipse$ui$vtree$VersionTreeControl = VersionTreeControl.class$("com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeControl")) : class$com$tssap$dtr$client$eclipse$ui$vtree$VersionTreeControl));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$vtree$VersionTreeControl;

    public VersionTreeControl(Composite parent, int layoutStyle) {
        super(parent, 0);
        this.m_layoutStyle = layoutStyle;
        this.m_graphArea = (SashForm)parent;
        this.m_graphArea.setOrientation(512);
        this.m_graphArea.SASH_WIDTH = 0;
        this.m_shell = parent.getShell();
        this.m_showEditMergeArrows = false;
        this.m_showBranchSequenceNumbers = false;
        this.m_showBottomTopView = false;
        this.m_navigateToActiveVersion = false;
        this.m_headerArea = new Canvas((Composite)this.m_graphArea, 0);
        this.m_bodyArea = new Canvas((Composite)this.m_graphArea, 0);
        this.initDraw2D();
        this.initHeaderDraw2D();
        this.m_graphArea.setBackground(ColorConstants.white);
        this.m_headerArea.setBackground(ColorConstants.white);
        this.m_bodyArea.setBackground(ColorConstants.white);
        this.m_layoutStyle = layoutStyle == 1 ? layoutStyle : 0;
        this.m_bodyArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (VersionTreeControl.this.m_bodyArea != null && VersionTreeControl.this.m_scrollPane != null) {
                    VersionTreeControl.this.m_scrollPane.setBounds(new Rectangle(0, 0, VersionTreeControl.this.m_bodyArea.getSize().x, VersionTreeControl.this.m_bodyArea.getSize().y));
                    VersionTreeControl.this.setSashFormWeights();
                    int pageIncrement = VersionTreeControl.this.m_scrollPane.getBounds().height;
                    VersionTreeControl.this.m_scrollPane.getVerticalScrollBar().setPageIncrement(pageIncrement);
                }
            }
        });
        this.m_headerArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (VersionTreeControl.this.m_graphArea != null && VersionTreeControl.this.m_headerArea != null && VersionTreeControl.this.m_graphArea.getSize().y > 0) {
                    VersionTreeControl.this.m_headerScrollPane.setBounds(new Rectangle(0, 0, VersionTreeControl.this.m_headerArea.getSize().x, VersionTreeControl.this.m_headerArea.getSize().y));
                    VersionTreeControl.this.setSashFormWeights();
                    VersionTreeControl.this.m_headerScrollPane.getHorizontalScrollBar().setValue(VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar().getValue());
                }
            }
        });
        this.m_graphArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (VersionTreeControl.this.m_graphArea != null && VersionTreeControl.this.m_graphArea.getSize().y > 0) {
                    VersionTreeControl.this.setSashFormWeights();
                }
            }
        });
        this.m_scrollPane.getHorizontalScrollBar().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equalsIgnoreCase("value") && VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar() != null) {
                    VersionTreeControl.this.m_headerScrollPane.getHorizontalScrollBar().setValue(VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar().getValue());
                }
            }
        });
        this.addPaintListener(this);
        this.initializeControl();
    }

    private void initializeControl() {
        this.m_selectedNodes = new HashSet();
        this.m_selectedVersions = new ArrayList();
        this.m_CtrlKeyPressed = false;
        this.m_selectedLabel = null;
        this.m_selectedConnection = null;
        this.m_versionTrees = new HashMap();
        this.m_currentVersionTree = null;
    }

    private void setSashFormWeights() {
        int MAX_HEADER_HEIGHT = 70;
        int headerPercent = 7000 / this.m_graphArea.getSize().y;
        if (headerPercent < 100) {
            int[] weights = new int[]{0, headerPercent, 100 - headerPercent};
            this.m_graphArea.setWeights(weights);
        }
    }

    public void setActiveWorkspace(IVfsWorkspace activeWorkspace, String activeWorkspacePath) {
        int xLocation = 0;
        int yLocation = 0;
        if (!this.m_navigateToActiveVersion) {
            xLocation = this.m_scrollPane.getHorizontalScrollBar().getValue();
            yLocation = this.m_scrollPane.getVerticalScrollBar().getValue();
        }
        this.m_currentVersionTree.refreshTree(activeWorkspace, false, activeWorkspacePath);
        if (xLocation > 0) {
            this.m_scrollPane.getHorizontalScrollBar().setValue(xLocation);
        }
        if (yLocation > 0) {
            this.m_scrollPane.getVerticalScrollBar().setValue(yLocation);
        }
    }

    public void setBranchSequenceNumberVisibility(boolean show) {
        if (this.m_currentVersionTree != null && this.m_currentVersionTree.m_versionHistory != null) {
            this.m_currentVersionTree.setBranchSequenceNumberVisibility(show);
        }
        this.m_showBranchSequenceNumbers = show;
    }

    public void setGraphDirection(boolean bottomTop) {
        if (this.m_showBottomTopView == bottomTop) {
            return;
        }
        if (this.m_currentVersionTree != null && this.m_currentVersionTree.m_versionHistory != null) {
            this.m_currentVersionTree.flipGraphOrientation();
            this.m_currentVersionTree.navigateToActiveVersion(this.m_navigateToActiveVersion);
        }
        this.m_showBottomTopView = bottomTop;
    }

    public void showActiveVersion(boolean show) {
        if (this.m_currentVersionTree != null && this.m_currentVersionTree.m_versionHistory != null) {
            this.m_currentVersionTree.navigateToActiveVersion(show);
        }
        this.m_navigateToActiveVersion = show;
    }

    public void refreshCurrentHistory() {
        if (this.m_currentVersionTree != null && this.m_currentVersionTree.m_versionHistory != null) {
            this.m_currentVersionTree.refreshTree(this.m_currentVersionTree.m_activeWorkspace, true, this.m_currentVersionTree.m_activeWorkspacePath);
        }
    }

    public void setEditMergeArrowVisibility(boolean show) {
        if (this.m_currentVersionTree != null && this.m_currentVersionTree.m_versionHistory != null) {
            this.m_currentVersionTree.setEditMergeArrowVisibility(show);
        }
        this.m_showEditMergeArrows = show;
    }

    public void setProperties(boolean showEditMergeArrows, boolean showBranchSequenceNumbers, boolean bottomTop, boolean showActiveVersion) {
        this.m_showBranchSequenceNumbers = showBranchSequenceNumbers;
        this.m_showEditMergeArrows = showEditMergeArrows;
        this.m_showBottomTopView = bottomTop;
        this.m_navigateToActiveVersion = showActiveVersion;
    }

    public void showVersionHistory(IVfsVersionHistory versionHistory, IVfsWorkspace activeWorkspace) {
        boolean width = false;
        boolean height = false;
        try {
            this.m_bodyArea.setVisible(true);
            this.m_headerArea.setVisible(true);
            this.m_graphArea.setVisible(true);
            VersionTree vTree = (VersionTree)this.m_versionTrees.get(this.getVersionHistoryKey(versionHistory));
            if (vTree != null) {
                if (this.m_currentVersionTree != null && !this.m_currentVersionTree.equals(vTree)) {
                    this.m_currentVersionTree.InitializeTree();
                }
                this.m_currentVersionTree = vTree;
                this.m_currentVersionTree.m_versionHistory = versionHistory;
                if (activeWorkspace != null) {
                    vTree.refreshTree(activeWorkspace, false, activeWorkspace.getAbsoluteRemotePath());
                } else {
                    vTree.refreshTree(null, false, null);
                }
            } else {
                vTree = new VersionTree(versionHistory, activeWorkspace);
                this.m_versionTrees.put(this.getVersionHistoryKey(versionHistory), vTree);
                if (this.m_currentVersionTree != null) {
                    this.m_currentVersionTree.InitializeTree();
                }
                this.m_currentVersionTree = vTree;
                vTree.refreshTree(activeWorkspace, false, activeWorkspace.getAbsoluteRemotePath());
            }
        }
        catch (Exception e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    String getVersionHistoryKey(IVfsVersionHistory versionHistory) {
        return versionHistory.getPath() + versionHistory.getVersionedFileSystemManager().getClientName();
    }

    public void unloadAllHistoriesAndReinitialize() {
        if (this.m_currentVersionTree != null) {
            this.m_currentVersionTree.unloadTree();
        }
        this.initializeControl();
    }

    protected Canvas getHeaderArea() {
        return this.m_headerArea;
    }

    protected Canvas getBodyArea() {
        return this.m_bodyArea;
    }

    public IVfsVersionHistory loadExistingHistory(String versionHistoryIdentifier) {
        VersionTree vTree = (VersionTree)this.m_versionTrees.get(versionHistoryIdentifier);
        if (vTree != null) {
            this.showVersionHistory(vTree.m_versionHistory, null);
            return vTree.m_versionHistory;
        }
        return null;
    }

    private void initDraw2D() {
        this.m_lws = new LightweightSystem(this.m_bodyArea);
        this.m_scrollPane = new ScrollPane();
        this.m_versionView = new Panel();
        this.m_scrollPane.setVerticalScrollBar(new ScrollBar());
        this.m_scrollPane.setVerticalScrollBarVisibility(1);
        this.m_scrollPane.setVisible(true);
        DelegatingLayout thisLayout = new DelegatingLayout();
        this.m_versionView.setLayoutManager((LayoutManager)thisLayout);
        this.m_scrollPane.setView(this.m_versionView);
        this.m_lws.setContents((IFigure)this.m_scrollPane);
        this.m_versionView.setPreferredSize(new Dimension(200, 300));
        this.m_scrollPane.setLocation(new Point(0, 0));
        this.m_graphArea.setVisible(false);
    }

    private void initHeaderDraw2D() {
        this.m_headerLWS = new LightweightSystem(this.m_headerArea);
        this.m_headerScrollPane = new ScrollPane();
        this.m_headerVersionView = new Panel();
        this.m_headerScrollPane.setVerticalScrollBarVisibility(0);
        this.m_headerScrollPane.setHorizontalScrollBarVisibility(0);
        this.m_headerScrollPane.setVisible(true);
        DelegatingLayout thisLayout = new DelegatingLayout();
        this.m_headerVersionView.setLayoutManager((LayoutManager)thisLayout);
        this.m_headerScrollPane.setView(this.m_headerVersionView);
        this.m_headerLWS.setContents((IFigure)this.m_headerScrollPane);
        this.m_headerVersionView.setPreferredSize(new Dimension(200, 300));
        this.m_headerVersionView.setLocation(new Point(0, 0));
    }

    public void paintControl(PaintEvent evt) {
    }

    private ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/";
        try {
            BluebirdPlugin plugin = BluebirdPlugin.getDefault();
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, iconPath + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (Exception e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public void addVersionSelectionListener(VersionSelectionListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(3);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
        }
    }

    public void removeVersionSelectionListener(VersionSelectionListener l) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ((AbstractCollection)this.listeners).remove(l);
        }
    }

    protected void fireVersionSelectionEvent(IVfsVersion[] selectedVersions) {
        VersionSelectionListener[] copy;
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            copy = this.listeners.toArray(new VersionSelectionListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < copy.length) {
            copy[i].versionsSelected(this, selectedVersions);
            ++i;
        }
    }

    protected void fireVersionRelationSelectionEvent(IVfsVersionRelation selected) {
        VersionSelectionListener[] copy;
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            copy = this.listeners.toArray(new VersionSelectionListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < copy.length) {
            copy[i].versionRelationSelected(this, selected);
            ++i;
        }
    }

    protected void fireWorkspaceSelectionEvent(String workspacePath) {
        VersionSelectionListener[] copy;
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            copy = this.listeners.toArray(new VersionSelectionListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < copy.length) {
            copy[i].workspaceSelected(this, workspacePath);
            ++i;
        }
    }

    public static String assureTrailingSlash(String path) {
        if (!path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class VersionTree
    implements IVfsActionListener,
    IVfsFolderItemListener,
    IVfsVersionListener,
    IVfsCollisionListener {
        private HashMap m_elementsToDraw = new HashMap();
        private HashMap m_linksToDraw;
        private HashMap m_connections;
        private HashMap m_connectionsOfVersionRelations;
        private HashMap m_editMergeConnections;
        private HashMap m_workspaceLabels;
        private HashMap m_workspacePaths;
        private HashSet m_visibleWorkspaces;
        private HashMap m_elementsInGraph = new HashMap();
        private ArrayList m_closedVersionsInActiveWorkspace = new ArrayList();
        private ArrayList m_openVersionsInActiveWorkspace = new ArrayList();
        private IVfsVersionGraph m_versionGraph = null;
        private IVfsVersionHistory m_versionHistory;
        private IVfsWorkspace m_activeWorkspace;
        private String m_activeWorkspacePath;
        private IVfsVersion m_activeVersion;
        org.eclipse.swt.graphics.Rectangle m_activeVersionLocation;
        private IVfsVersion m_syncdVersion;
        private HashSet m_visitedVersions;
        private ArrayList m_vfsWorkspaces;
        private boolean m_refreshNeeded;
        private boolean m_refreshInProgress;
        private int m_maxYLocationOfNode;
        private int m_maxLevel;
        private int m_maxDisplacement;
        private Label m_selectedWorkspaceLabel;

        VersionTree(IVfsVersionHistory versionHistory, IVfsWorkspace activeWorkspace) {
            this.m_linksToDraw = new HashMap();
            this.m_connections = new HashMap();
            this.m_connectionsOfVersionRelations = new HashMap();
            this.m_editMergeConnections = new HashMap();
            this.m_workspaceLabels = new HashMap();
            this.m_workspacePaths = new HashMap();
            this.m_versionHistory = versionHistory;
            this.m_activeWorkspace = activeWorkspace;
            this.m_activeWorkspacePath = this.m_activeWorkspace.getAbsoluteRemotePath();
            this.m_visitedVersions = new HashSet();
            this.m_visibleWorkspaces = new HashSet();
            this.m_vfsWorkspaces = new ArrayList();
            this.m_refreshNeeded = false;
            this.m_refreshInProgress = false;
            this.m_activeVersion = null;
            this.m_syncdVersion = null;
            this.m_activeVersionLocation = null;
            this.m_selectedWorkspaceLabel = null;
            IVersionedFileSystemManager vfsManager = this.m_versionHistory.getVersionedFileSystemManager();
            vfsManager.addFolderItemListener((IVfsFolderItemListener)this);
            vfsManager.addVersionListener((IVfsVersionListener)this);
            vfsManager.addCollisionListener((IVfsCollisionListener)this);
            VfsActionManager.getInstance().addActionListener((IVfsActionListener)this);
            VersionTreeControl.this.addDisposeListener(new DisposeListener(this){
                private final /* synthetic */ VersionTree this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetDisposed(DisposeEvent event) {
                    VfsActionManager.getInstance().removeActionListener((IVfsActionListener)this.this$1);
                    IVersionedFileSystemManager vfsManager = VersionTree.access$100(this.this$1).getVersionedFileSystemManager();
                    vfsManager.removeFolderItemListener((IVfsFolderItemListener)this.this$1);
                    vfsManager.removeVersionListener((IVfsVersionListener)this.this$1);
                    vfsManager.removeCollisionListener((IVfsCollisionListener)this.this$1);
                    VfsActionManager.getInstance().removeActionListener((IVfsActionListener)this.this$1);
                }
            });
        }

        IVfsWorkspace getActiveWorkspace() {
            return this.m_activeWorkspace;
        }

        String getActiveWorkspacePath() {
            return this.m_activeWorkspacePath;
        }

        Object[] getAllWorkspaces() {
            return this.m_vfsWorkspaces.toArray(new Object[this.m_vfsWorkspaces.size()]);
        }

        org.eclipse.swt.graphics.Rectangle getActiveVersionLocation() {
            return this.m_activeVersionLocation;
        }

        public void navigateToActiveVersion(boolean navigate) {
            VersionTreeControl.this.m_navigateToActiveVersion = navigate;
            if (VersionTreeControl.this.m_navigateToActiveVersion) {
                int currentWidth = VersionTreeControl.this.m_scrollPane.getBounds().width;
                int currentHeight = VersionTreeControl.this.m_scrollPane.getBounds().height;
                int targetX = this.m_activeVersionLocation.x;
                int targetY = this.m_activeVersionLocation.y;
                VersionTreeControl.this.m_scrollPane.getVerticalScrollBar().setValue(targetY - currentHeight / 2);
                VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar().setValue(targetX - currentWidth / 2);
            }
        }

        private void InitializeTree() {
            if (VersionTreeControl.this.m_versionView != null && this.m_versionGraph != null) {
                IVfsVersionGraph.IVfsLineOfDescent currentLine;
                Iterator it;
                if (this.m_elementsToDraw != null) {
                    it = this.m_versionGraph.getDescentLines().values().iterator();
                    while (it.hasNext()) {
                        Label label;
                        currentLine = (IVfsVersionGraph.IVfsLineOfDescent)it.next();
                        VersionDrawElement[] elementsToDraw = (VersionDrawElement[])this.m_elementsToDraw.get(currentLine.getWorkspaceName());
                        if (elementsToDraw != null) {
                            int i = 0;
                            while (i < elementsToDraw.length) {
                                VersionTreeControl.this.m_versionView.remove((IFigure)elementsToDraw[i].node);
                                VersionTreeControl.this.m_versionView.remove((IFigure)elementsToDraw[i].label);
                                if (elementsToDraw[i].marker != null) {
                                    VersionTreeControl.this.m_versionView.remove((IFigure)elementsToDraw[i].marker);
                                    elementsToDraw[i].marker = null;
                                }
                                if (elementsToDraw[i].markerCompanionNode != null) {
                                    VersionTreeControl.this.m_versionView.remove((IFigure)elementsToDraw[i].markerCompanionNode);
                                    elementsToDraw[i].markerCompanionNode = null;
                                }
                                if (elementsToDraw[i].curvedConnector != null) {
                                    VersionTreeControl.this.m_versionView.remove((IFigure)elementsToDraw[i].curvedConnector);
                                }
                                if (elementsToDraw[i].curvedConnectorNode != null) {
                                    VersionTreeControl.this.m_versionView.remove((IFigure)elementsToDraw[i].curvedConnectorNode);
                                }
                                try {
                                    this.m_elementsInGraph.remove(elementsToDraw[i].version.getVersionId());
                                }
                                catch (VfsException e) {
                                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                                }
                                elementsToDraw[i] = null;
                                ++i;
                            }
                            this.m_elementsToDraw.remove(currentLine.getWorkspaceName());
                        }
                        if (this.m_workspaceLabels == null || (label = (Label)this.m_workspaceLabels.get(currentLine.getWorkspaceName())) == null || VersionTreeControl.this.m_headerVersionView == null) continue;
                        VersionTreeControl.this.m_headerVersionView.remove((IFigure)label);
                        this.m_workspaceLabels.remove(currentLine.getWorkspaceName());
                    }
                    if (this.m_workspaceLabels != null) {
                        Label workspaceLabel = null;
                        Iterator it2 = this.m_workspaceLabels.values().iterator();
                        while (it2.hasNext()) {
                            workspaceLabel = (Label)it2.next();
                            VersionTreeControl.this.m_headerVersionView.remove((IFigure)workspaceLabel);
                        }
                        this.m_workspaceLabels.clear();
                    }
                    if (this.m_workspacePaths != null) {
                        this.m_workspacePaths.clear();
                    }
                }
                if (this.m_connections != null && this.m_linksToDraw != null) {
                    it = this.m_versionGraph.getDescentLines().values().iterator();
                    while (it.hasNext()) {
                        currentLine = (IVfsVersionGraph.IVfsLineOfDescent)it.next();
                        VersionDrawLink[] linksToDraw = (VersionDrawLink[])this.m_linksToDraw.get(currentLine.getWorkspaceName());
                        PolylineConnection[] connections = (PolylineConnection[])this.m_connections.get(currentLine.getWorkspaceName());
                        if (connections != null && linksToDraw != null) {
                            int i = 0;
                            while (i < linksToDraw.length) {
                                if (VersionTreeControl.this.m_versionView.getChildren().contains(connections[i])) {
                                    VersionTreeControl.this.m_versionView.remove((IFigure)connections[i]);
                                }
                                connections[i] = null;
                                linksToDraw[i] = null;
                                ++i;
                            }
                            this.m_linksToDraw.remove(currentLine.getWorkspaceName());
                            this.m_connections.remove(currentLine.getWorkspaceName());
                        }
                        it.remove();
                    }
                }
                if (this.m_visibleWorkspaces != null) {
                    this.m_visibleWorkspaces.clear();
                }
                if (this.m_vfsWorkspaces != null) {
                    this.m_vfsWorkspaces.clear();
                }
                if (this.m_selectedWorkspaceLabel != null) {
                    VersionTreeControl.this.m_versionView.remove((IFigure)this.m_selectedWorkspaceLabel);
                    this.m_selectedWorkspaceLabel = null;
                }
                List remainingFigures = VersionTreeControl.this.m_versionView.getChildren();
                IFigure[] figureArray = remainingFigures.toArray(new IFigure[remainingFigures.size()]);
                int figureCount = 0;
                while (figureCount < figureArray.length) {
                    VersionTreeControl.this.m_versionView.remove(figureArray[figureCount]);
                    ++figureCount;
                }
            }
            VersionTreeControl.this.m_CtrlKeyPressed = false;
            if (VersionTreeControl.this.m_selectedNodes != null) {
                VersionTreeControl.this.m_selectedNodes.removeAll(VersionTreeControl.this.m_selectedNodes);
            }
            if (this.m_editMergeConnections != null) {
                this.m_editMergeConnections.clear();
            }
            if (this.m_connectionsOfVersionRelations != null) {
                this.m_connectionsOfVersionRelations.clear();
            }
            if (this.m_elementsInGraph != null) {
                this.m_elementsInGraph.clear();
            }
            if (this.m_closedVersionsInActiveWorkspace != null) {
                this.m_closedVersionsInActiveWorkspace.clear();
            }
            if (this.m_openVersionsInActiveWorkspace != null) {
                this.m_openVersionsInActiveWorkspace.clear();
            }
        }

        public void unloadTree() {
            this.InitializeTree();
        }

        public void onIdle(IVersionedFileSystemManager[] involvedManagers) {
            if (this.m_refreshNeeded) {
                if (this == VersionTreeControl.this.m_currentVersionTree) {
                    VersionTreeControl.this.m_shell.getDisplay().syncExec(new Runnable(this){
                        private final /* synthetic */ VersionTree this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            this.this$1.refreshTree(VersionTree.access$300(this.this$1), true, VersionTree.access$400(this.this$1));
                            VersionTree.access$1002(this.this$1, false);
                        }
                    });
                } else {
                    this.m_versionHistory.refreshVersionSet();
                }
            }
        }

        public void onBusy(IVersionedFileSystemManager involvedManager) {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void populateWithVersions(boolean selectRootVersion) {
            boolean width = false;
            boolean height = false;
            try {
                this.InitializeTree();
                VersionTreeControl.this.m_versionView = new Figure();
                DelegatingLayout thisLayout = new DelegatingLayout();
                VersionTreeControl.this.m_versionView.setLayoutManager((LayoutManager)thisLayout);
                VersionTreeControl.this.m_scrollPane.setView(VersionTreeControl.this.m_versionView);
                this.m_versionGraph = new VfsVersionGraph(this.m_versionHistory);
                VersionTreeControl.this.imageSize = VersionTreeControl.this.m_layoutStyle == 0 ? this.createDrawElementsVertically() : this.createDrawElementsHorizontally();
                Iterator it = this.m_versionGraph.getDescentLines().values().iterator();
                while (it.hasNext()) {
                    ArrayList listVersionLinks = new ArrayList();
                    IVfsVersionGraph.IVfsLinkVisitor linkVisitor = new IVfsVersionGraph.IVfsLinkVisitor(this, listVersionLinks){
                        private final /* synthetic */ ArrayList val$listVersionLinks;
                        private final /* synthetic */ VersionTree this$1;
                        {
                            this.this$1 = this$1;
                            this.val$listVersionLinks = val$listVersionLinks;
                        }

                        public void oneMoreLink(Object from, Object to, IVfsVersionRelation VersionRelation) {
                            VersionDrawElement parent = (VersionDrawElement)((IVfsVersionGraph.IVfsVersionElement)from).getUIElement();
                            VersionDrawElement child = (VersionDrawElement)((IVfsVersionGraph.IVfsVersionElement)to).getUIElement();
                            this.val$listVersionLinks.add(new VersionDrawLink(parent, child, VersionRelation));
                        }
                    };
                    IVfsVersionGraph.IVfsLineOfDescent currentLine = (IVfsVersionGraph.IVfsLineOfDescent)it.next();
                    currentLine.applyVisitor(linkVisitor);
                    VersionDrawLink[] linksToDraw = listVersionLinks.toArray(new VersionDrawLink[listVersionLinks.size()]);
                    this.m_linksToDraw.put(currentLine.getWorkspaceName(), linksToDraw);
                }
                this.m_maxYLocationOfNode = 0;
                VersionDrawElement rootElement = (VersionDrawElement)this.m_elementsInGraph.get(this.m_versionHistory.getRootVersion().getVersionId());
                this.moveNode(rootElement, rootElement.location.y);
                this.drawVersionGraph();
                if (!selectRootVersion) return;
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }

        private void moveNode(VersionDrawElement node, int yLocation) {
            if (yLocation < node.location.y) {
                return;
            }
            if (yLocation > this.m_maxYLocationOfNode) {
                this.m_maxYLocationOfNode = yLocation;
            }
            boolean movingToSameLocation = false;
            if (node.location.y == yLocation) {
                movingToSameLocation = true;
            } else {
                node.location = new org.eclipse.swt.graphics.Rectangle(node.location.x, yLocation, node.location.width, node.location.height);
            }
            VersionDrawElement[] successorNodes = this.getSuccessorNodes(node);
            int i = 0;
            while (i < successorNodes.length) {
                if (successorNodes[i].version.getCreatorWorkspaceName().equalsIgnoreCase(node.version.getCreatorWorkspaceName())) {
                    if (movingToSameLocation) {
                        this.moveNode(successorNodes[i], successorNodes[i].location.y);
                    } else {
                        this.moveNode(successorNodes[i], yLocation + 50);
                    }
                } else if (successorNodes[i].location.y <= node.location.y) {
                    this.moveNode(successorNodes[i], yLocation + 50);
                } else {
                    this.moveNode(successorNodes[i], successorNodes[i].location.y);
                }
                ++i;
            }
        }

        private VersionDrawElement[] getSuccessorNodes(VersionDrawElement node) {
            ArrayList successorNodes = new ArrayList();
            IVfsVersionRelation[] successorRelations = node.version.getSuccessorRelationSet();
            int i = 0;
            while (i < successorRelations.length) {
                IVfsVersionRelation thisRelation = successorRelations[i];
                if (!(thisRelation.getRelationType().equals(VfsVersionRelationType.PRED_SUCC_COLLISION) || thisRelation.getRelationType().equals(VfsVersionRelationType.EDIT_MERGE) || thisRelation.getRelationType().equals(VfsVersionRelationType.DISCARD_MERGE) || thisRelation.getRelationType().equals(VfsVersionRelationType.CYCLIC_MERGE_COLLISION))) {
                    IVfsVersion successorVersion = this.m_versionHistory.getVersion(thisRelation.getTargetVersionId());
                    try {
                        successorNodes.add(this.m_elementsInGraph.get(successorVersion.getVersionId()));
                    }
                    catch (VfsException e) {
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                    }
                }
                ++i;
            }
            return successorNodes.toArray(new VersionDrawElement[successorNodes.size()]);
        }

        private void drawElementsAndLinks() {
            Iterator it = this.m_versionGraph.getDescentLines().values().iterator();
            while (it.hasNext()) {
                IVfsVersionGraph.IVfsLineOfDescent currentLine = (IVfsVersionGraph.IVfsLineOfDescent)it.next();
                VersionDrawElement[] elementsToDraw = (VersionDrawElement[])this.m_elementsToDraw.get(currentLine.getWorkspaceName());
                VersionDrawLink[] linksToDraw = (VersionDrawLink[])this.m_linksToDraw.get(currentLine.getWorkspaceName());
                PolylineConnection[] connections = new PolylineConnection[linksToDraw.length];
                Label[] labels = new Label[elementsToDraw.length];
                int i = 0;
                while (i < elementsToDraw.length) {
                    this.drawNode(elementsToDraw[i]);
                    this.drawNodeLabel(elementsToDraw[i]);
                    VersionTreeControl.this.m_versionView.add((IFigure)elementsToDraw[i].node);
                    VersionTreeControl.this.m_versionView.add((IFigure)elementsToDraw[i].label);
                    if (currentLine.getRootElements()[0].getVersion().equals(elementsToDraw[i].version)) {
                        labels = new Label[]{this.drawWorkspaceLabel(currentLine.getWorkspaceName(), elementsToDraw[i], null)};
                        if (currentLine.getWorkspaceName().equalsIgnoreCase(this.m_activeWorkspacePath)) {
                            labels[0].setBackgroundColor(ACTIVE_WORKSPACE_COLOR);
                        } else {
                            labels[0].setBackgroundColor(INACTIVE_WORKSPACE_COLOR);
                        }
                        VersionTreeControl.this.m_headerVersionView.add((IFigure)labels[0]);
                        this.m_workspaceLabels.put(currentLine.getWorkspaceName(), labels[0]);
                        this.m_workspacePaths.put(String.valueOf(labels[0].hashCode()), currentLine.getWorkspaceName());
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < linksToDraw.length) {
                    IVfsVersionRelation versionRelation = linksToDraw[i2].versionRelation;
                    if (versionRelation.isVisibleInWorkspace(this.m_activeWorkspacePath)) {
                        connections[i2] = this.createConnection(linksToDraw[i2].source, linksToDraw[i2].target, versionRelation);
                        VersionTreeControl.this.m_versionView.add((IFigure)connections[i2]);
                        this.m_connectionsOfVersionRelations.put(versionRelation.getURL(), connections[i2]);
                    }
                    ++i2;
                }
                this.m_connections.put(currentLine.getWorkspaceName(), connections);
            }
            this.highlightActiveConnections();
            this.createSelectedWorkspaceLabel();
        }

        private void createSelectedWorkspaceLabel() {
            String selectedWorkspace = "Selected Workspace:   " + this.m_activeWorkspacePath;
            this.m_selectedWorkspaceLabel = new Label(selectedWorkspace);
            this.m_selectedWorkspaceLabel.setTextAlignment(1);
            this.m_selectedWorkspaceLabel.setTextPlacement(8);
            this.m_selectedWorkspaceLabel.setSize(selectedWorkspace.length() * 6, 30);
            this.m_selectedWorkspaceLabel.setLocation(new Point(120, this.m_maxYLocationOfNode + 30 + 30));
            this.m_selectedWorkspaceLabel.setBorder((Border)new LineBorder());
            VersionTreeControl.this.m_versionView.add((IFigure)this.m_selectedWorkspaceLabel);
        }

        private void highlightActiveConnections() {
            this.m_visitedVersions.clear();
            IVfsVersion activeVersion = this.m_versionHistory.getActiveVersion(this.m_activeWorkspacePath);
            if (activeVersion == null) {
                Logbook.getWarnChapter().println("Unable to highlight active connections - active version is <null>");
                return;
            }
            this.highlightPredecessorRelations(activeVersion);
            IVfsVersionRelation[] successorRelations = activeVersion.getSuccessorRelationSet();
            int i = 0;
            while (i < successorRelations.length) {
                IVfsVersion successor = this.m_versionHistory.getVersion(successorRelations[i].getTargetVersionId());
                if (successorRelations[i].getRelationType() == VfsVersionRelationType.PRED_SUCC_COLLISION || successorRelations[i].getRelationType() == VfsVersionRelationType.CYCLIC_MERGE_COLLISION) {
                    this.highlightPredecessorRelations(successor);
                } else if (successor.isOpen() && this.m_activeWorkspacePath.equalsIgnoreCase(successor.getCreatorWorkspaceName())) {
                    this.highlightPredecessorRelations(successor);
                }
                ++i;
            }
            this.m_visitedVersions.clear();
        }

        private void highlightPredecessorRelations(IVfsVersion version) {
            if (version == null) {
                return;
            }
            if (this.m_visitedVersions.contains(version)) {
                return;
            }
            this.m_visitedVersions.add(version);
            IVfsVersionRelation[] predecessorRelations = version.getPredecessorRelationSet();
            ArrayList<IVfsVersion> predecessors = new ArrayList<IVfsVersion>();
            int i = 0;
            while (i < predecessorRelations.length) {
                if (predecessorRelations[i].getRelationType() != VfsVersionRelationType.PRED_SUCC_COLLISION && predecessorRelations[i].getRelationType() != VfsVersionRelationType.CYCLIC_MERGE_COLLISION) {
                    IVfsVersion predecessorVersion = this.m_versionHistory.getVersion(predecessorRelations[i].getSourceVersionId());
                    this.highlightConnection(predecessorRelations[i]);
                    predecessors.add(predecessorVersion);
                }
                ++i;
            }
            Iterator iter = ((AbstractList)predecessors).iterator();
            while (iter.hasNext()) {
                IVfsVersion predecessor = (IVfsVersion)iter.next();
                this.highlightPredecessorRelations(predecessor);
            }
            IVfsVersionRelation[] successorRelations = version.getSuccessorRelationSet();
            int i2 = 0;
            while (i2 < successorRelations.length) {
                IVfsVersion successorVersion;
                if (successorRelations[i2].getRelationType() == VfsVersionRelationType.PRED_SUCC && (successorVersion = this.m_versionHistory.getVersion(successorRelations[i2].getTargetVersionId())).isOpen() && successorVersion.getCreatorWorkspaceName().equalsIgnoreCase(this.m_activeWorkspacePath)) {
                    this.highlightConnection(successorRelations[i2]);
                    this.highlightPredecessorRelations(successorVersion);
                }
                ++i2;
            }
        }

        private void highlightConnection(IVfsVersionRelation versionRelation) {
            String tempPath;
            PolylineConnection connection = (PolylineConnection)this.m_connectionsOfVersionRelations.get(versionRelation.getURL());
            if (connection == null && (connection = (PolylineConnection)this.m_connectionsOfVersionRelations.get(tempPath = versionRelation.getTargetVersionId() + versionRelation.getSourceVersionId() + versionRelation.getRelationType().toString())) == null) {
                return;
            }
            Color arrowColor = null;
            if (versionRelation.getRelationType() == VfsVersionRelationType.BRANCH || versionRelation.getRelationType() == VfsVersionRelationType.PRED_SUCC) {
                arrowColor = PRED_SUCC_ARROW_COLOR;
            } else if (versionRelation.getRelationType() == VfsVersionRelationType.COPY_MERGE || versionRelation.getRelationType() == VfsVersionRelationType.MERGE) {
                arrowColor = MERGE_ARROW_COLOR;
            } else if (versionRelation.getRelationType() == VfsVersionRelationType.DISCARD_MERGE) {
                arrowColor = DISCARD_ARROW_COLOR;
            } else if (versionRelation.getRelationType() == VfsVersionRelationType.PRED_SUCC_COLLISION || versionRelation.getRelationType() == VfsVersionRelationType.CYCLIC_MERGE_COLLISION) {
                arrowColor = COLLISION_COLOR;
            } else if (versionRelation.getRelationType() == VfsVersionRelationType.EDIT_MERGE) {
                arrowColor = MERGE_ARROW_COLOR;
                VersionDrawElement sourceElement = (VersionDrawElement)this.m_elementsInGraph.get(versionRelation.getSourceVersionId());
                VersionDrawElement targetElement = (VersionDrawElement)this.m_elementsInGraph.get(versionRelation.getTargetVersionId());
                if (sourceElement.curvedConnector != null) {
                    sourceElement.curvedConnector.setForegroundColor(arrowColor);
                }
                if (targetElement.curvedConnector != null) {
                    targetElement.curvedConnector.setForegroundColor(arrowColor);
                }
            }
            connection.setForegroundColor(arrowColor);
            connection.repaint();
        }

        private void drawNodeLabel(VersionDrawElement element) {
            int labelTextSize = element.label.getText().length();
            element.label.setSize(10 * labelTextSize, 10);
            int xLocation = 0;
            int yLocation = 0;
            switch (labelTextSize) {
                case 1: {
                    xLocation = element.location.x + 10;
                    yLocation = element.location.y + 10;
                    break;
                }
                case 2: {
                    xLocation = element.location.x + 5;
                    yLocation = element.location.y + 10;
                    break;
                }
                case 3: {
                    xLocation = element.location.x;
                    yLocation = element.location.y + 10;
                }
            }
            element.label.setLocation(new Point(xLocation - VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar().getValue(), yLocation - VersionTreeControl.this.m_scrollPane.getVerticalScrollBar().getValue()));
            element.label.setFocusTraversable(false);
            element.label.setRequestFocusEnabled(false);
            element.label.setToolTip((IFigure)new Label(element.toolTip));
            element.label.setEnabled(false);
            try {
                if (!element.version.isVisibleInWorkspace(this.m_activeWorkspacePath)) {
                    element.label.setVisible(false);
                } else {
                    element.label.setForegroundColor(ColorConstants.black);
                }
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }

        private Label drawWorkspaceLabel(String name, VersionDrawElement element, Point location) {
            String displayPart = "..." + name.substring(name.length() - 11);
            Label label = new Label(displayPart);
            if (element != null) {
                int xLocation = element.location.x - 27 - VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar().getValue();
                label.setLocation(new Point(xLocation, 20));
            } else {
                label.setLocation(location);
            }
            label.setSize(80, 30);
            label.setOpaque(true);
            label.setToolTip((IFigure)new Label("Workspace : " + name));
            if (this.m_activeWorkspacePath.indexOf(name) > 0) {
                label.setBackgroundColor(ACTIVE_WORKSPACE_COLOR);
            } else {
                label.setBackgroundColor(INACTIVE_WORKSPACE_COLOR);
            }
            FocusBorder labelBorder = new FocusBorder();
            GC gc = new GC((Drawable)VersionTreeControl.this.m_shell);
            SWTGraphics swtGraphics = new SWTGraphics(gc);
            swtGraphics.setLineStyle(2);
            labelBorder.paint((IFigure)label, (Graphics)swtGraphics, new Insets(5));
            label.setBorder((Border)labelBorder);
            IVfsWorkspace workspace = this.findWorkspace(this.m_versionHistory.getRootVersion().getVersionedFileSystemManager().getWorkspaces(), name);
            if (workspace != null) {
                label.addMouseListener((MouseListener)new VersionGraphMouseListener(null, workspace, VersionTreeControl.this, (Figure)label));
            } else {
                label.addMouseListener((MouseListener)new VersionGraphMouseListener(null, name, VersionTreeControl.this, (Figure)label));
            }
            new Dragger((IFigure)label);
            return label;
        }

        private IVfsWorkspace findWorkspace(IVfsWorkspace[] workspaces, String workspacePath) {
            int i = 0;
            while (i < workspaces.length) {
                if (workspaces[i].getAbsoluteRemotePath().equalsIgnoreCase(workspacePath)) {
                    return workspaces[i];
                }
                ++i;
            }
            return null;
        }

        private void drawVersionMarker(int x, int y, VersionDrawElement versionElement, String toolTip, String icon) {
            Ellipse dummyNode = new Ellipse();
            dummyNode.setLocation(new Point(x - 30, y + 10));
            dummyNode.setSize(5, 5);
            dummyNode.setOutline(false);
            dummyNode.setBackgroundColor(ColorConstants.white);
            PolylineConnection connection = new PolylineConnection();
            connection.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)dummyNode));
            connection.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)versionElement.node));
            connection.setBackgroundColor(ColorConstants.white);
            connection.setForegroundColor(ColorConstants.white);
            Label label = new Label("");
            label.setOpaque(false);
            label.setBackgroundColor(ColorConstants.buttonLightest);
            label.setBorder((Border)new LineBorder());
            label.setToolTip((IFigure)new Label(toolTip));
            label.setIcon(VersionTreeControl.this.getImageDescriptor(icon).createImage());
            connection.add((IFigure)label, (Object)new MidpointLocator((Connection)connection, 0));
            VersionTreeControl.this.m_versionView.add((IFigure)connection);
            VersionTreeControl.this.m_versionView.add((IFigure)dummyNode);
            versionElement.marker = connection;
            versionElement.markerCompanionNode = dummyNode;
        }

        private void removeVersionMarker(VersionDrawElement element) {
            if (element == null) {
                return;
            }
            if (element.marker != null) {
                VersionTreeControl.this.m_versionView.remove((IFigure)element.marker);
            }
            if (element.markerCompanionNode != null) {
                VersionTreeControl.this.m_versionView.remove((IFigure)element.markerCompanionNode);
            }
            element.marker = null;
            element.markerCompanionNode = null;
        }

        private void drawNode(VersionDrawElement element) {
            boolean isDeleted = false;
            boolean isActive = false;
            String toolTip = null;
            Color nodeBackgroundColor = ACTIVE_VERSION_COLOR;
            if (element.version.isDeleted()) {
                this.drawVersionMarker(element.location.x, element.location.y, element, VersionTreeControl.DELETED_VERSION, VersionTreeControl.DELETED_VERSION_ICON);
                isDeleted = true;
            }
            String workspacePath = this.m_activeWorkspacePath;
            if (element.version.equals(this.m_activeVersion)) {
                toolTip = VersionTreeControl.ACTIVE_VERSION_IN_WORKSPACE + workspacePath;
                this.drawVersionMarker(element.location.x, element.location.y, element, toolTip, VersionTreeControl.ACTIVE_VERSION_ICON);
                this.m_activeVersionLocation = element.location;
            } else if (element.version.equals(this.m_syncdVersion)) {
                toolTip = VersionTreeControl.SYNCED_VERSION_IN_ACTIVE_WORKSPACE + workspacePath;
                this.drawVersionMarker(element.location.x, element.location.y, element, toolTip, VersionTreeControl.SYNCED_VERSION_ICON);
            }
            try {
                if (element.version.isVisibleInWorkspace(this.m_activeWorkspacePath)) {
                    nodeBackgroundColor = ACTIVE_VERSION_COLOR;
                    if (!element.version.isOpen()) {
                        this.m_closedVersionsInActiveWorkspace.add(element.version);
                    } else {
                        this.m_openVersionsInActiveWorkspace.add(element.version);
                    }
                } else {
                    element.node.setForegroundColor(ColorConstants.lightGray);
                }
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
            String[] activatingWorkspaceSet = element.version.getActivatedInWorkspaceSet();
            int i = 0;
            while (i < activatingWorkspaceSet.length) {
                this.m_visibleWorkspaces.add(VersionTreeControl.assureTrailingSlash(activatingWorkspaceSet[i]));
                ++i;
            }
            element.node.setLocation(new Point(element.location.x, element.location.y));
            element.node.setSize(element.location.width, element.location.height);
            element.node.setToolTip((IFigure)new Label(element.toolTip));
            element.node.setBackgroundColor(nodeBackgroundColor);
            element.node.setOpaque(false);
            element.node.setRequestFocusEnabled(true);
            element.node.setFocusTraversable(true);
            if (element.version.isOpen()) {
                element.node.setLineStyle(3);
                element.node.setBackgroundColor(OPEN_VERSION_COLOR);
            }
            element.node.setEnabled(true);
            element.node.addMouseListener((MouseListener)new VersionGraphMouseListener(element.location, element.version, VersionTreeControl.this, (Figure)element.node));
            new Dragger((IFigure)element.node);
        }

        private PolylineConnection createConnection(VersionDrawElement source, VersionDrawElement target, IVfsVersionRelation versionRelation) {
            VfsVersionRelationType connectionType = versionRelation == null ? VfsVersionRelationType.PRED_SUCC : versionRelation.getRelationType();
            PolylineConnection connection = new PolylineConnection();
            if (connectionType == VfsVersionRelationType.PRED_SUCC || connectionType == VfsVersionRelationType.BRANCH) {
                this.drawAnchoredConnector(source, target, connection, INACTIVE_ARROW_COLOR, connectionType);
            } else {
                Color arrowColor = null;
                arrowColor = connectionType == VfsVersionRelationType.PRED_SUCC_COLLISION || connectionType == VfsVersionRelationType.CYCLIC_MERGE_COLLISION ? COLLISION_COLOR : INACTIVE_ARROW_COLOR;
                if (source.location.x == target.location.x) {
                    this.drawCurvedLineConnector(source, target, connection, arrowColor);
                } else {
                    this.drawAnchoredConnector(source, target, connection, arrowColor, connectionType);
                }
            }
            connection.addMouseListener((MouseListener)new VersionGraphMouseListener(null, versionRelation, VersionTreeControl.this, (Figure)connection));
            return connection;
        }

        private void drawAnchoredConnector(VersionDrawElement source, VersionDrawElement target, PolylineConnection connection, Color foregroundColor, VfsVersionRelationType connectionType) {
            connection.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)source.node));
            connection.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)target.node));
            if (connectionType == VfsVersionRelationType.PRED_SUCC_COLLISION || connectionType == VfsVersionRelationType.CYCLIC_MERGE_COLLISION) {
                PolygonDecoration collidingVersionHead = new PolygonDecoration();
                collidingVersionHead.setToolTip((IFigure)new Label(VersionTreeControl.ACTIVE_VERSION));
                connection.setSourceDecoration((RotatableDecoration)collidingVersionHead);
                PolygonDecoration activeVersionHead = new PolygonDecoration();
                activeVersionHead.setToolTip((IFigure)new Label(VersionTreeControl.COLLIDING_VERSION));
                connection.setTargetDecoration((RotatableDecoration)activeVersionHead);
                connection.add((IFigure)this.createConnectionLabel(VersionTreeControl.COLLISION_TOOLTIP, VersionTreeControl.COLLISION_ICON), (Object)new MidpointLocator((Connection)connection, 0));
            } else if (connectionType == VfsVersionRelationType.MERGE) {
                connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
            } else if (connectionType == VfsVersionRelationType.COPY_MERGE) {
                connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
            } else if (connectionType == VfsVersionRelationType.DISCARD_MERGE) {
                connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
            } else {
                connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
            }
            connection.setForegroundColor(foregroundColor);
            if (connectionType == VfsVersionRelationType.MERGE || connectionType == VfsVersionRelationType.DISCARD_MERGE) {
                connection.setLineWidth(2);
            }
            if (this.showDottedLineToTarget(connectionType, target)) {
                connection.setLineStyle(3);
            }
            if (connectionType == VfsVersionRelationType.EDIT_MERGE) {
                this.m_editMergeConnections.put(connection.toString(), connection);
            }
        }

        private Label createConnectionLabel(String tooltip, String iconName) {
            Label label = new Label("");
            label.setOpaque(true);
            label.setBackgroundColor(ColorConstants.buttonLightest);
            label.setBorder((Border)new LineBorder());
            label.setToolTip((IFigure)new Label(tooltip));
            label.setIcon(VersionTreeControl.this.getImageDescriptor(iconName).createImage());
            return label;
        }

        private boolean showDottedLineToTarget(VfsVersionRelationType connectionType, VersionDrawElement target) {
            if (connectionType == VfsVersionRelationType.PRED_SUCC) {
                IVfsVersion targetVersion = target.version;
                IVfsVersionRelation[] predRelations = targetVersion.getPredecessorRelationSet();
                int i = 0;
                while (i < predRelations.length) {
                    if (predRelations[i].getRelationType() == VfsVersionRelationType.COPY_MERGE) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return false;
        }

        private void drawCurvedLineConnector(VersionDrawElement source, VersionDrawElement target, PolylineConnection connection, Color foregroundColor) {
            Ellipse dummySourceNode = null;
            if (source.curvedConnectorNode == null) {
                dummySourceNode = new Ellipse();
                int sourceNodeYLocation = VersionTreeControl.this.m_showBottomTopView ? source.location.y - 25 : source.location.y + 25;
                dummySourceNode.setLocation(new Point(source.location.x - 20, sourceNodeYLocation));
                dummySourceNode.setSize(1, 1);
                dummySourceNode.setOutline(false);
                dummySourceNode.setBackgroundColor(ColorConstants.white);
                VersionTreeControl.this.m_versionView.add((IFigure)dummySourceNode);
                source.curvedConnectorNode = dummySourceNode;
            } else {
                dummySourceNode = source.curvedConnectorNode;
            }
            PolylineConnection connectionSource = null;
            if (source.curvedConnector == null) {
                connectionSource = new PolylineConnection();
                connectionSource.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)source.node));
                connectionSource.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)dummySourceNode));
                connectionSource.setForegroundColor(foregroundColor);
                VersionTreeControl.this.m_versionView.add((IFigure)connectionSource);
                source.curvedConnector = connectionSource;
            } else {
                connectionSource = source.curvedConnector;
            }
            Ellipse dummyTargetNode = null;
            if (target.curvedConnectorNode == null) {
                dummyTargetNode = new Ellipse();
                int targetNodeYLocation = VersionTreeControl.this.m_showBottomTopView ? target.location.y + 25 : target.location.y - 25;
                dummyTargetNode.setLocation(new Point(target.location.x - 20, targetNodeYLocation));
                dummyTargetNode.setSize(1, 1);
                dummyTargetNode.setOutline(false);
                dummyTargetNode.setBackgroundColor(ColorConstants.white);
                VersionTreeControl.this.m_versionView.add((IFigure)dummyTargetNode);
                target.curvedConnectorNode = dummyTargetNode;
            } else {
                dummyTargetNode = target.curvedConnectorNode;
            }
            PolylineConnection connectionTarget = null;
            if (target.curvedConnector == null) {
                connectionTarget = new PolylineConnection();
                connectionTarget.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)dummyTargetNode));
                connectionTarget.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)target.node));
                connectionTarget.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
                connectionTarget.setForegroundColor(foregroundColor);
                VersionTreeControl.this.m_versionView.add((IFigure)connectionTarget);
                target.curvedConnector = connectionTarget;
            } else {
                connectionTarget = target.curvedConnector;
            }
            connection.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)dummySourceNode));
            connection.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)dummyTargetNode));
            connection.setForegroundColor(foregroundColor);
            this.m_editMergeConnections.put(connection.toString(), connection);
            this.m_editMergeConnections.put(connectionSource.toString(), connectionSource);
            this.m_editMergeConnections.put(connectionTarget.toString(), connectionTarget);
        }

        private void drawMergeArrow(VersionDrawElement source, VersionDrawElement target, PolylineConnection connection) {
            Point sourceNodeLocation = new Point(source.location.x, source.location.y);
            Point targetNodeLocation = new Point(target.location.x, target.location.y);
            try {
                int i;
                int levelDelta = 0;
                int displacementDelta = 0;
                levelDelta = (sourceNodeLocation.y - targetNodeLocation.y) / 50;
                displacementDelta = (sourceNodeLocation.x - targetNodeLocation.x) / 120;
                PointList arcList = new PointList(Math.abs(displacementDelta) + 2);
                int xValue = sourceNodeLocation.x;
                arcList.addPoint(xValue, sourceNodeLocation.y + 30);
                int yValue = 0;
                if (levelDelta == 0) {
                    yValue = sourceNodeLocation.y + 25 + 15;
                    boolean leftToRight = sourceNodeLocation.x < targetNodeLocation.x;
                    xValue = leftToRight ? xValue + 60 - 15 : xValue - 60 + 15;
                    int i2 = 0;
                    while (i2 < Math.abs(displacementDelta)) {
                        arcList.addPoint(xValue, yValue);
                        xValue = leftToRight ? (xValue += 120) : (xValue -= 120);
                        ++i2;
                    }
                }
                if (levelDelta < 0) {
                    arcList.addPoint(sourceNodeLocation.x, sourceNodeLocation.y + 30);
                    yValue = targetNodeLocation.y + 25;
                    xValue = sourceNodeLocation.x < targetNodeLocation.x ? sourceNodeLocation.x : targetNodeLocation.x;
                    xValue += 60;
                    i = 0;
                    while (i < Math.abs(displacementDelta)) {
                        arcList.addPoint(xValue, yValue);
                        xValue += 120;
                        ++i;
                    }
                }
                if (levelDelta > 0) {
                    arcList.addPoint(sourceNodeLocation.x, sourceNodeLocation.y + 30);
                    yValue = sourceNodeLocation.y + 25;
                    xValue = sourceNodeLocation.x < targetNodeLocation.x ? sourceNodeLocation.x : targetNodeLocation.x;
                    xValue += 60;
                    i = 0;
                    while (i < Math.abs(displacementDelta)) {
                        arcList.addPoint(xValue, yValue);
                        xValue += 120;
                        ++i;
                    }
                }
                xValue = targetNodeLocation.x + 30;
                yValue = targetNodeLocation.y + 30;
                arcList.addPoint(xValue, yValue);
                connection.setPoints(arcList);
                connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
            }
            catch (RuntimeException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }

        private Point createDrawElementsVertically() {
            int curX = 0;
            int curY = 0;
            int maxX = 0;
            this.m_maxLevel = 0;
            this.m_maxDisplacement = 0;
            int lineLevel = 0;
            ArrayList<VersionDrawElement> listOfDrawElements = null;
            VersionDrawElement[] elementsToDraw = null;
            Iterator it = this.m_versionGraph.getDescentLines().values().iterator();
            while (it.hasNext()) {
                lineLevel = 0;
                listOfDrawElements = new ArrayList<VersionDrawElement>();
                IVfsVersionGraph.IVfsLineOfDescent currentLine = (IVfsVersionGraph.IVfsLineOfDescent)it.next();
                this.m_maxDisplacement += currentLine.getContainedDisplacements();
                curX = maxX = 120 * (currentLine.getStartDisplacement() + 1);
                curY = 30 + (currentLine.getStartLevel() - 1) * 50;
                IVfsVersionGraph.IVfsLevelIterator li = currentLine.getLevelIterator();
                while (li.hasNextLevel()) {
                    ++lineLevel;
                    IVfsVersionGraph.IVfsVersionElement[] elements = li.nextLevel();
                    int i = 0;
                    while (i < elements.length) {
                        VersionDrawElement drawElement = new VersionDrawElement(new org.eclipse.swt.graphics.Rectangle(curX, curY, 30, 30), elements[i].getVersion(), new Ellipse(), new Label(String.valueOf(elements[i].getVersion().getBranchSequenceNumber())), null, null);
                        listOfDrawElements.add(drawElement);
                        elements[i].setUIElement((Object)drawElement);
                        try {
                            this.m_elementsInGraph.put(drawElement.version.getVersionId(), drawElement);
                        }
                        catch (VfsException e1) {
                            LogUtil.logException((Location)LOCATION, (Throwable)e1);
                        }
                        curX += 120;
                        ++i;
                    }
                    if (curX > maxX) {
                        maxX = curX;
                    }
                    curX = 120 * (currentLine.getStartDisplacement() + 1);
                    curY += 50;
                }
                this.m_maxLevel = Math.max(this.m_maxLevel, currentLine.getStartLevel() + lineLevel - 1);
                elementsToDraw = listOfDrawElements.toArray(new VersionDrawElement[listOfDrawElements.size()]);
                this.m_elementsToDraw.put(currentLine.getWorkspaceName(), elementsToDraw);
            }
            return new Point(maxX, curY);
        }

        private Point createDrawElementsHorizontally() {
            int curY;
            int curX = 20;
            int maxY = curY = 50;
            ArrayList<VersionDrawElement> listOfDrawElements = new ArrayList<VersionDrawElement>();
            IVfsVersionGraph.IVfsLevelIterator li = this.m_versionGraph.getRootLine().getLevelIterator();
            while (li.hasNextLevel()) {
                IVfsVersionGraph.IVfsVersionElement[] elements = li.nextLevel();
                int i = 0;
                while (i < elements.length) {
                    VersionDrawElement drawElement = new VersionDrawElement(new org.eclipse.swt.graphics.Rectangle(curX, curY, 30, 30), elements[i].getVersion(), new Ellipse(), new Label(String.valueOf(elements[i].getVersion().getBranchSequenceNumber())), null, null);
                    listOfDrawElements.add(drawElement);
                    elements[i].setUIElement((Object)drawElement);
                    curY += 50;
                    ++i;
                }
                if (curY > maxY) {
                    maxY = curY;
                }
                curX += 120;
                curY = 50;
            }
            return new Point(curX, maxY);
        }

        private void drawVersionGraph() {
            this.drawElementsAndLinks();
            int widthOfSelectedWorkspaceLabel = this.m_selectedWorkspaceLabel.getSize().width + this.m_selectedWorkspaceLabel.getBounds().x + 120;
            int widthOfHeaderWorkspaceLabels = (this.m_workspaceLabels.size() + 2) * 120;
            int viewWidth = widthOfSelectedWorkspaceLabel > widthOfHeaderWorkspaceLabels ? widthOfSelectedWorkspaceLabel : widthOfHeaderWorkspaceLabels;
            VersionTreeControl.this.m_versionView.setPreferredSize(new Dimension(viewWidth, this.m_maxYLocationOfNode + 100));
            VersionTreeControl.this.m_headerVersionView.setPreferredSize(new Dimension(viewWidth, 300));
        }

        void refreshTree(IVfsWorkspace activeWorkspace, boolean refreshVersionSet, String activeWorkspacePath) {
            this.m_refreshInProgress = true;
            if (activeWorkspacePath != null) {
                this.m_activeWorkspace = activeWorkspace;
                this.m_activeWorkspacePath = activeWorkspacePath;
            }
            if (refreshVersionSet) {
                this.m_versionHistory.refreshVersionSet();
            }
            this.m_activeVersion = this.m_versionHistory.getActiveVersion(this.m_activeWorkspacePath);
            this.m_syncdVersion = this.m_activeWorkspace != null ? this.m_versionHistory.getVersionInClientWorkspace(this.m_activeWorkspace) : null;
            this.populateWithVersions(true);
            this.setWorkspaceList();
            this.setEditMergeArrowVisibility(VersionTreeControl.this.m_showEditMergeArrows);
            VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar().setValue(0);
            VersionTreeControl.this.m_scrollPane.getVerticalScrollBar().setValue(0);
            VersionTreeControl.this.m_headerScrollPane.getHorizontalScrollBar().setValue(0);
            VersionTreeControl.this.m_headerScrollPane.getVerticalScrollBar().setValue(0);
            this.setBranchSequenceNumberVisibility(VersionTreeControl.this.m_showBranchSequenceNumbers);
            if (VersionTreeControl.this.m_showBottomTopView) {
                this.flipGraphOrientation();
            }
            this.navigateToActiveVersion(VersionTreeControl.this.m_navigateToActiveVersion);
            this.m_refreshInProgress = false;
        }

        private void flipGraphOrientation() {
            int originalElementX = 0;
            int originalElementY = 0;
            int viewHeight = this.m_maxYLocationOfNode + 100;
            Iterator iter = this.m_elementsInGraph.values().iterator();
            while (iter.hasNext()) {
                VersionDrawElement element = (VersionDrawElement)iter.next();
                originalElementX = element.location.x;
                originalElementY = element.location.y;
                element.location = new org.eclipse.swt.graphics.Rectangle(originalElementX, viewHeight - originalElementY - 50, element.location.width, element.location.height);
                if (element.version.equals(this.m_activeVersion)) {
                    this.m_activeVersionLocation = element.location;
                }
                element.node.translate(0, viewHeight - 2 * originalElementY - 50);
                if (element.markerCompanionNode != null) {
                    element.markerCompanionNode.translate(0, viewHeight - 2 * originalElementY - 50);
                }
                if (element.curvedConnectorNode != null) {
                    element.curvedConnectorNode.translate(0, viewHeight - 2 * originalElementY - 50);
                }
                this.drawNodeLabel(element);
            }
            VersionTreeControl.this.m_bodyArea.redraw();
            VersionTreeControl.this.m_bodyArea.update();
        }

        private void setWorkspaceList() {
            IVfsWorkspace[] allWorkspaces = this.m_versionHistory.getRootVersion().getVersionedFileSystemManager().getWorkspaces();
            Iterator iter = this.m_visibleWorkspaces.iterator();
            while (iter.hasNext()) {
                String workspacePath = (String)iter.next();
                IVfsWorkspace workspace = this.findWorkspace(allWorkspaces, workspacePath);
                if (workspace != null) {
                    this.m_vfsWorkspaces.add(workspace);
                    continue;
                }
                this.m_vfsWorkspaces.add(workspacePath);
            }
        }

        private ArrayList getRevisionsFromVersions(ArrayList versions, String workspacePath) {
            ArrayList<VfsRevision> revisions = new ArrayList<VfsRevision>();
            Iterator iter = ((AbstractList)versions).iterator();
            while (iter.hasNext()) {
                IVfsVersion vfsVersion = (IVfsVersion)iter.next();
                int[] ISNs = vfsVersion.getISNs(workspacePath);
                int j = 0;
                while (j < ISNs.length) {
                    revisions.add(new VfsRevision(vfsVersion, ISNs[j], workspacePath));
                    ++j;
                }
            }
            return revisions;
        }

        void setBranchSequenceNumberVisibility(boolean showBranchSequenceNumbers) {
            if (!showBranchSequenceNumbers) {
                ArrayList revisionsInActiveWorkspace = this.getRevisionsFromVersions(this.m_closedVersionsInActiveWorkspace, this.m_activeWorkspacePath);
                Collections.sort(revisionsInActiveWorkspace, new VfsRevisionComparator(this.m_activeWorkspacePath));
                int i = revisionsInActiveWorkspace.size() - 1;
                while (i >= 0) {
                    this.updateLabelProperties(((IVfsRevision)revisionsInActiveWorkspace.get(i)).getVersion(), String.valueOf(revisionsInActiveWorkspace.size() - i));
                    --i;
                }
                int i2 = 0;
                while (i2 < this.m_openVersionsInActiveWorkspace.size()) {
                    this.updateLabelProperties((IVfsVersion)this.m_openVersionsInActiveWorkspace.get(i2), String.valueOf(revisionsInActiveWorkspace.size() + 1));
                    ++i2;
                }
            } else {
                int i = 0;
                while (i < this.m_closedVersionsInActiveWorkspace.size()) {
                    IVfsVersion version = (IVfsVersion)this.m_closedVersionsInActiveWorkspace.get(i);
                    this.updateLabelProperties(version, String.valueOf(version.getBranchSequenceNumber()));
                    ++i;
                }
                int i3 = 0;
                while (i3 < this.m_openVersionsInActiveWorkspace.size()) {
                    IVfsVersion version = (IVfsVersion)this.m_openVersionsInActiveWorkspace.get(i3);
                    this.updateLabelProperties(version, String.valueOf(version.getBranchSequenceNumber()));
                    ++i3;
                }
            }
        }

        private void updateLabelProperties(IVfsVersion version, String labelText) {
            try {
                VersionDrawElement element = (VersionDrawElement)this.m_elementsInGraph.get(version.getVersionId());
                element.label.setText(labelText);
                this.drawNodeLabel(element);
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }

        private void drawAdditionalWorkspaceLabels() {
            Iterator iter = this.m_visibleWorkspaces.iterator();
            while (iter.hasNext()) {
                String workspacePath = (String)iter.next();
                if (this.m_workspaceLabels.get(workspacePath) != null) continue;
                this.createAdditionalWorkspaceLabel(workspacePath);
            }
        }

        private void createAdditionalWorkspaceLabel(String workspacePath) {
            Color labelColor = null;
            labelColor = this.m_activeWorkspacePath.equalsIgnoreCase(workspacePath) ? ACTIVE_WORKSPACE_COLOR : INACTIVE_WORKSPACE_COLOR;
            Point location = this.getAdditionalWorkspaceLocation();
            Label additionalWSLabel = this.drawWorkspaceLabel(workspacePath, null, location);
            VersionTreeControl.this.m_headerVersionView.add((IFigure)additionalWSLabel);
            additionalWSLabel.setBackgroundColor(labelColor);
            this.m_workspaceLabels.put(workspacePath, additionalWSLabel);
            this.m_workspacePaths.put(String.valueOf(additionalWSLabel.hashCode()), workspacePath);
        }

        private Point getAdditionalWorkspaceLocation() {
            Label workspaceLabel = null;
            Label labelOnRight = null;
            Iterator it = this.m_workspaceLabels.values().iterator();
            while (it.hasNext()) {
                workspaceLabel = (Label)it.next();
                if (labelOnRight == null) {
                    labelOnRight = workspaceLabel;
                    continue;
                }
                if (labelOnRight.getLocation().x >= workspaceLabel.getLocation().x) continue;
                labelOnRight = workspaceLabel;
            }
            return new Point(labelOnRight.getLocation().x + 100, labelOnRight.getLocation().y);
        }

        VersionDrawElement findVersion(int x, int y) {
            boolean notFound = true;
            Iterator it = this.m_versionGraph.getDescentLines().values().iterator();
            while (it.hasNext()) {
                IVfsVersionGraph.IVfsLineOfDescent currentLine = (IVfsVersionGraph.IVfsLineOfDescent)it.next();
                VersionDrawElement[] elementsToDraw = (VersionDrawElement[])this.m_elementsToDraw.get(currentLine.getWorkspaceName());
                int i = 0;
                while (notFound && i < elementsToDraw.length) {
                    notFound = !elementsToDraw[i].location.contains(x, y);
                    ++i;
                }
                if (notFound) continue;
                return elementsToDraw[i - 1];
            }
            return null;
        }

        IVfsVersionGraph getVersionGraph() {
            return this.m_versionGraph;
        }

        public void versionOnFolderItemChanged(IVfsActivityRecordedFolderItem folderItem, IVfsVersion oldVersion) {
            if (folderItem instanceof IVfsActivityRecordedFolderItem) {
                try {
                    if (folderItem.getObjectID().equalsIgnoreCase(this.m_versionHistory.getRootVersion().getObjectID()) && folderItem.getWorkspace().getAbsoluteRemotePath().equalsIgnoreCase(this.m_activeWorkspacePath) && !this.m_refreshInProgress) {
                        this.refreshSyncExec();
                    }
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            }
        }

        private void updateVersionMarkers(IVfsActivityRecordedFolderItem folderItem) {
            IVfsVersion activeVersion = null;
            try {
                activeVersion = folderItem.getActiveVersion();
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                activeVersion = this.m_versionHistory.getActiveVersion(this.m_activeWorkspacePath);
            }
            IVfsVersion syncdVersion = folderItem.getSyncedVersion();
            try {
                String toolTip;
                VersionDrawElement newElement;
                if (!activeVersion.equals(this.m_activeVersion)) {
                    if (this.m_activeVersion != null) {
                        this.removeVersionMarker((VersionDrawElement)this.m_elementsInGraph.get(this.m_activeVersion.getVersionId()));
                    }
                    newElement = (VersionDrawElement)this.m_elementsInGraph.get(activeVersion.getVersionId());
                    toolTip = VersionTreeControl.ACTIVE_VERSION_IN_WORKSPACE + this.m_activeWorkspacePath;
                    this.drawVersionMarker(newElement.location.x - VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar().getValue(), newElement.location.y - VersionTreeControl.this.m_scrollPane.getVerticalScrollBar().getValue(), newElement, toolTip, VersionTreeControl.ACTIVE_VERSION_ICON);
                }
                if (!syncdVersion.equals(this.m_syncdVersion)) {
                    if (this.m_syncdVersion != null && !this.m_syncdVersion.equals(this.m_activeVersion)) {
                        this.removeVersionMarker((VersionDrawElement)this.m_elementsInGraph.get(this.m_syncdVersion.getVersionId()));
                    }
                    if (!syncdVersion.equals(activeVersion)) {
                        newElement = (VersionDrawElement)this.m_elementsInGraph.get(syncdVersion.getVersionId());
                        toolTip = VersionTreeControl.SYNCED_VERSION_IN_ACTIVE_WORKSPACE + this.m_activeWorkspacePath;
                        this.drawVersionMarker(newElement.location.x - VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar().getValue(), newElement.location.y - VersionTreeControl.this.m_scrollPane.getVerticalScrollBar().getValue(), newElement, toolTip, VersionTreeControl.SYNCED_VERSION_ICON);
                    }
                }
            }
            catch (VfsException e1) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e1);
            }
            this.m_syncdVersion = syncdVersion;
            this.m_activeVersion = activeVersion;
        }

        private void refreshSyncExec() {
            if (this == VersionTreeControl.this.m_currentVersionTree && !this.m_refreshInProgress) {
                VersionTreeControl.this.m_shell.getDisplay().syncExec(new Runnable(this){
                    private final /* synthetic */ VersionTree this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        this.this$1.refreshTree(VersionTree.access$300(this.this$1), true, VersionTree.access$400(this.this$1));
                        VersionTree.access$1002(this.this$1, false);
                    }
                });
            }
        }

        public void locationStateChanged(IVfsFolderItem folderItem, VfsFolderItemLocationState oldState) {
            if (folderItem instanceof IVfsActivityRecordedFolderItem) {
                try {
                    if (folderItem.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY && folderItem.getObjectID().equalsIgnoreCase(this.m_versionHistory.getRootVersion().getObjectID()) && folderItem.asActivityRecordedFolderItem().getWorkspace().getAbsoluteRemotePath().equalsIgnoreCase(this.m_activeWorkspacePath) && !this.m_refreshInProgress) {
                        this.refreshSyncExec();
                    }
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            }
        }

        public void activityStateChanged(IVfsActivityRecordedFolderItem folderItem, VfsFolderItemActivityState oldState) {
            try {
                if (folderItem.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY && folderItem.getObjectID().equalsIgnoreCase(this.m_versionHistory.getRootVersion().getObjectID()) && !this.m_refreshInProgress) {
                    this.refreshSyncExec();
                }
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }

        public void itemsAddedOrRemoved(IVfsGenericFolder folder) {
        }

        public void setEditMergeArrowVisibility(boolean visible) {
            Iterator it = this.m_editMergeConnections.values().iterator();
            while (it.hasNext()) {
                PolylineConnection connection = (PolylineConnection)it.next();
                connection.setVisible(visible);
            }
        }

        public void versionOnIntegrateCollisionDiscarded(IVfsActivityRecordedFolderItem folderItem, IVfsIntegrateCollision integrateCollision, IVfsVersion discardedVersion) {
            try {
                if (folderItem.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY && folderItem.getObjectID().equalsIgnoreCase(this.m_versionHistory.getRootVersion().getObjectID()) && !this.m_refreshInProgress) {
                    this.refreshSyncExec();
                }
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }

        public void mergeVersionOnIntegrateCollisionCreated(IVfsActivityRecordedFolderItem folderItem, IVfsIntegrateCollision integrateCollision) {
            try {
                if (folderItem.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY && folderItem.getObjectID().equalsIgnoreCase(this.m_versionHistory.getRootVersion().getObjectID()) && !this.m_refreshInProgress) {
                    this.refreshSyncExec();
                }
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }

        public void activeVersionAccepted(IVfsActivityRecordedFolderItem folderItem, IVfsCheckinCollision checkinCollision) {
        }

        public void localVersionAccepted(IVfsActivityRecordedFolderItem folderItem, IVfsCheckinCollision checkinCollision) {
        }

        static /* synthetic */ boolean access$1002(VersionTree x0, boolean x1) {
            x0.m_refreshNeeded = x1;
            return x0.m_refreshNeeded;
        }
    }

    class Dragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        Point m_lastLocation;

        public Dragger(IFigure figure) {
            figure.addMouseMotionListener((MouseMotionListener)this);
            figure.addMouseListener((MouseListener)this);
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDoubleClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.m_lastLocation = e.getLocation();
        }

        public void mouseDragged(MouseEvent e) {
            if (this.m_lastLocation == null) {
                return;
            }
            Point p = e.getLocation();
            Dimension delta = p.getDifference(this.m_lastLocation);
            this.m_lastLocation = p;
            Figure figure = (Figure)e.getSource();
            if (figure instanceof Ellipse) {
                int y;
                int x = e.x + VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar().getValue();
                VersionDrawElement draggedElement = VersionTreeControl.this.m_currentVersionTree.findVersion(x, y = e.y + VersionTreeControl.this.m_scrollPane.getVerticalScrollBar().getValue());
                if (draggedElement != null) {
                    this.moveElement(draggedElement, delta);
                }
            } else {
                figure.setBounds(figure.getBounds().getTranslated(delta.width, delta.height));
                Label label = (Label)figure;
                String workspacePath = (String)VersionTreeControl.this.m_currentVersionTree.m_workspacePaths.get(String.valueOf(label.hashCode()));
                VersionDrawElement[] elementsToDraw = (VersionDrawElement[])VersionTreeControl.this.m_currentVersionTree.m_elementsToDraw.get(workspacePath);
                if (elementsToDraw != null) {
                    int i = 0;
                    while (i < elementsToDraw.length) {
                        this.moveElement(elementsToDraw[i], delta);
                        ++i;
                    }
                }
            }
        }

        void moveElement(VersionDrawElement element, Dimension delta) {
            element.node.setBounds(element.node.getBounds().getTranslated(delta.width, delta.height));
            element.label.setBounds(element.label.getBounds().getTranslated(delta.width, delta.height));
            if (element.markerCompanionNode != null) {
                element.markerCompanionNode.setBounds(element.markerCompanionNode.getBounds().getTranslated(delta.width, delta.height));
            }
            if (element.curvedConnectorNode != null) {
                element.curvedConnectorNode.setBounds(element.curvedConnectorNode.getBounds().getTranslated(delta.width, delta.height));
            }
            element.location.x = element.node.getLocation().x + VersionTreeControl.this.m_scrollPane.getHorizontalScrollBar().getValue();
            element.location.y = element.node.getLocation().y + VersionTreeControl.this.m_scrollPane.getVerticalScrollBar().getValue();
        }
    }

    static class VersionDrawLink {
        final VersionDrawElement source;
        final VersionDrawElement target;
        final IVfsVersionRelation versionRelation;

        VersionDrawLink(VersionDrawElement source, VersionDrawElement target, IVfsVersionRelation versionRelation) {
            this.source = source;
            this.target = target;
            this.versionRelation = versionRelation;
        }
    }

    static class VersionDrawElement {
        org.eclipse.swt.graphics.Rectangle location;
        final IVfsVersion version;
        final String toolTip;
        final Ellipse node;
        Label label;
        Ellipse markerCompanionNode;
        PolylineConnection marker;
        Ellipse curvedConnectorNode;
        PolylineConnection curvedConnector;

        VersionDrawElement(org.eclipse.swt.graphics.Rectangle location, IVfsVersion version, Ellipse node, Label label, Ellipse markerCompanionNode, PolylineConnection marker) {
            this.location = location;
            this.version = version;
            this.toolTip = VersionDrawElement.createToolTip(version);
            this.node = node;
            this.label = label;
            this.marker = marker;
            this.markerCompanionNode = markerCompanionNode;
            this.curvedConnector = null;
            this.curvedConnectorNode = null;
        }

        static String createToolTip(IVfsVersion version) {
            StringBuffer sb = new StringBuffer(" ");
            sb.append("Created by: " + version.getAuthor());
            sb.append(",  Last modified: ");
            sb.append(Util.getGMTString(version.getLastModifiedDate()));
            return sb.toString();
        }
    }
}

