/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.vtree;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.OpenEditorAction;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeControl;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import java.util.Iterator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class VersionGraphMouseListener
implements MouseListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$vtree$VersionGraphMouseListener == null ? (class$com$tssap$dtr$client$eclipse$ui$vtree$VersionGraphMouseListener = VersionGraphMouseListener.class$("com.tssap.dtr.client.eclipse.ui.vtree.VersionGraphMouseListener")) : class$com$tssap$dtr$client$eclipse$ui$vtree$VersionGraphMouseListener));
    private Shell m_shell;
    private IVfsVersion m_selectedVersion;
    private IVfsVersionRelation m_selectedVersionRelation;
    private IVfsWorkspace m_selectedWorkspace;
    private String m_selectedWorkspacePath;
    private Composite m_parent;
    private Menu m_popupMenu;
    private Rectangle m_figureLocation;
    private VersionTreeControl m_control;
    private Ellipse m_node;
    private Label m_label;
    private PolylineConnection m_connection;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$vtree$VersionGraphMouseListener;

    public VersionGraphMouseListener(Rectangle location, Object versionGraphEntity, VersionTreeControl control, Figure figure) {
        this.m_shell = control.m_graphArea.getShell();
        this.m_selectedVersion = null;
        this.m_selectedVersionRelation = null;
        this.m_selectedWorkspace = null;
        this.m_selectedWorkspacePath = null;
        if (versionGraphEntity instanceof IVfsVersion) {
            this.m_selectedVersion = (IVfsVersion)versionGraphEntity;
        } else if (versionGraphEntity instanceof IVfsVersionRelation) {
            this.m_selectedVersionRelation = (IVfsVersionRelation)versionGraphEntity;
        } else if (versionGraphEntity instanceof IVfsWorkspace) {
            this.m_selectedWorkspace = (IVfsWorkspace)versionGraphEntity;
            this.m_selectedWorkspacePath = this.m_selectedWorkspace.getAbsoluteRemotePath();
        } else if (versionGraphEntity instanceof String) {
            this.m_selectedWorkspacePath = (String)versionGraphEntity;
        }
        this.m_parent = control.m_graphArea;
        this.m_popupMenu = control.getMenu();
        this.m_figureLocation = location;
        this.m_control = control;
        this.m_node = null;
        this.m_label = null;
        this.m_connection = null;
        if (figure instanceof Ellipse) {
            this.m_node = (Ellipse)figure;
        } else if (figure instanceof Label) {
            this.m_label = (Label)figure;
        } else {
            this.m_connection = (PolylineConnection)figure;
        }
    }

    public void mouseReleased(MouseEvent me) {
        try {
            if (me.button == 1 || me.button == 3) {
                if (this.m_node != null) {
                    if (this.m_control.m_CtrlKeyPressed) {
                        if (me.button == 1) {
                            if (this.m_control.m_selectedNodes.contains(this.m_node)) {
                                this.unselectNode(this.m_node);
                                this.m_control.m_selectedNodes.remove(this.m_node);
                                if (this.m_selectedVersion.equals(this.m_control.m_selectedVersions.get(0))) {
                                    this.m_control.m_selectedVersions.remove(0);
                                } else {
                                    this.m_control.m_selectedVersions.remove(1);
                                }
                            } else {
                                if (this.m_control.m_selectedNodes.size() == 2) {
                                    return;
                                }
                                this.selectNode(this.m_node);
                                this.m_control.m_selectedVersions.add(this.m_selectedVersion);
                            }
                        }
                    } else if (me.button == 3) {
                        if (!this.m_control.m_selectedNodes.contains(this.m_node)) {
                            this.unselectAllSelectedNodes();
                            this.m_control.m_selectedVersions.clear();
                            this.selectNode(this.m_node);
                            this.m_control.m_selectedVersions.add(this.m_selectedVersion);
                        }
                    } else {
                        this.unselectAllSelectedNodes();
                        this.m_control.m_selectedVersions.clear();
                        this.selectNode(this.m_node);
                        this.m_control.m_selectedVersions.add(this.m_selectedVersion);
                    }
                    this.unselectLabel();
                    this.unselectConnection();
                } else if (this.m_label != null) {
                    this.unselectLabel();
                    this.unselectConnection();
                    this.unselectAllSelectedNodes();
                    this.selectLabel(this.m_label);
                } else {
                    this.unselectLabel();
                    this.unselectConnection();
                    this.unselectAllSelectedNodes();
                    this.selectConnection(this.m_connection);
                }
            }
            if (this.m_node != null) {
                IVfsVersion[] versionArray = this.m_control.m_selectedVersions.toArray(new IVfsVersion[this.m_control.m_selectedVersions.size()]);
                this.m_control.fireVersionSelectionEvent(versionArray);
            } else if (this.m_connection != null && this.m_selectedVersionRelation != null) {
                this.m_control.fireVersionRelationSelectionEvent(this.m_selectedVersionRelation);
            } else if (this.m_label != null && (this.m_selectedWorkspace != null || this.m_selectedWorkspacePath != null)) {
                this.m_control.fireWorkspaceSelectionEvent(this.m_selectedWorkspacePath);
                this.m_control.setActiveWorkspace(this.m_selectedWorkspace, this.m_selectedWorkspacePath);
            }
            if (me.button == 3 && this.m_label == null) {
                if (this.m_node != null) {
                    this.m_control.m_graphArea.redraw(this.m_node.getLocation().x, this.m_node.getLocation().y, this.m_node.getBounds().width, this.m_node.getBounds().height, true);
                } else if (this.m_connection != null) {
                    this.m_control.m_graphArea.redraw(this.m_connection.getLocation().x, this.m_connection.getLocation().y, this.m_connection.getBounds().width, this.m_connection.getBounds().height, true);
                }
                this.m_control.getMenu().setVisible(true);
            }
        }
        catch (RuntimeException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseDoubleClicked(MouseEvent me) {
        if (me.button == 1 && this.m_node != null) {
            OpenEditorAction.showVersion(this.m_selectedVersion, this.m_control.m_currentVersionTree.getActiveWorkspace());
        }
    }

    private void unselectAllSelectedNodes() {
        if (this.m_control.m_selectedNodes != null) {
            Iterator it = this.m_control.m_selectedNodes.iterator();
            while (it.hasNext()) {
                this.unselectNode((Ellipse)it.next());
            }
            this.m_control.m_selectedNodes.removeAll(this.m_control.m_selectedNodes);
        }
    }

    private void unselectNode(Ellipse node) {
        node.setBorder(null);
        node.repaint();
    }

    private void selectNode(Ellipse node) {
        FocusBorder nodeBorder = new FocusBorder();
        GC gc = new GC((Drawable)this.m_shell);
        SWTGraphics swtGraphics = new SWTGraphics(gc);
        nodeBorder.paint((IFigure)node, (Graphics)swtGraphics, new Insets(5));
        node.setBorder((Border)nodeBorder);
        this.m_control.m_selectedNodes.add(node);
        node.repaint();
    }

    private void unselectLabel() {
        if (this.m_control.m_selectedLabel != null) {
            Border oldBorder = this.m_control.m_selectedLabel.getBorder();
            oldBorder = null;
            FocusBorder labelBorder = new FocusBorder();
            GC gc = new GC((Drawable)this.m_shell);
            SWTGraphics swtGraphics = new SWTGraphics(gc);
            swtGraphics.setLineStyle(2);
            labelBorder.paint((IFigure)this.m_control.m_selectedLabel, (Graphics)swtGraphics, new Insets(5));
            this.m_control.m_selectedLabel.setBorder((Border)labelBorder);
            this.m_control.m_selectedLabel.repaint();
            this.m_control.m_selectedLabel = null;
        }
    }

    private void selectLabel(Label label) {
        if (this.m_control.m_selectedLabel != null) {
            Border oldBorder = this.m_control.m_selectedLabel.getBorder();
            oldBorder = null;
        }
        LineBorder labelBorder = new LineBorder(5);
        GC gc = new GC((Drawable)this.m_shell);
        SWTGraphics swtGraphics = new SWTGraphics(gc);
        swtGraphics.setLineStyle(1);
        labelBorder.paint((IFigure)label, (Graphics)swtGraphics, new Insets(5));
        label.setBorder((Border)labelBorder);
        label.repaint();
        this.m_control.m_selectedLabel = label;
    }

    private void selectConnection(PolylineConnection connection) {
        FocusBorder labelBorder = new FocusBorder();
        GC gc = new GC((Drawable)this.m_shell);
        SWTGraphics swtGraphics = new SWTGraphics(gc);
        labelBorder.paint((IFigure)connection, (Graphics)swtGraphics, new Insets(5));
        connection.setBackgroundColor(ColorConstants.tooltipBackground);
        connection.setBorder((Border)labelBorder);
        this.m_control.m_selectedConnection = connection;
    }

    private void unselectConnection() {
        if (this.m_control.m_selectedConnection != null) {
            this.m_control.m_selectedConnection.setBorder(null);
            this.m_control.m_selectedConnection = null;
        }
    }

    private void resetFocusToView() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IViewPart view = page.showView("com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView");
            if (view instanceof VersionTreeView) {
                ((VersionTreeView)view).setFocus();
            }
        }
        catch (PartInitException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

