/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.view;

import com.tssap.dtr.client.eclipse.ui.view.VfsObjectPropertySheet;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class VersionRelationPropertySheet
extends VfsObjectPropertySheet {
    private IVfsVersionRelation versionRelation;
    private static final String P_ID_RESOURCETYPE = "resourcetype";
    private static final String P_ID_RELATIONTYPE = "relationtype";
    private static final String P_ID_CREATIONDATE = "creationdate";
    private static final String P_ID_CREATOR = "creator";
    private static final String P_RESOURCETYPE = "Resource Type";
    private static final String P_RELATIONTYPE = "Relation Type";
    private static final String P_CREATIONDATE = "Creation Date";
    private static final String P_CREATOR = "Creator";
    private static final String T_PRED_SUCC_COLLISION = "CONFLICT: Predecessor-Successor";
    private static final String T_BRANCH = "Branch";
    private static final String T_PRED_SUCC = "Predecessor Successor";
    private static final String T_COPY_MERGE = "Copy Merge";
    private static final String T_CYCLIC_MERGE_COLLISION = "CONFLICT: Cyclic Merge";
    private static final String T_DISCARD_MERGE = "Discard Merge";
    private static final String T_EDIT_MERGE = "Edit Merge";
    private static final String T_MERGE = "Merge";
    private static final String T_VERSION_RELATION = "VERSION RELATION";
    private static ArrayList descriptors = new ArrayList();

    public VersionRelationPropertySheet(IVfsVersionRelation versionRelation) {
        this.versionRelation = versionRelation;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(P_ID_RELATIONTYPE)) {
            String type = null;
            if (this.versionRelation.getRelationType() == VfsVersionRelationType.BRANCH) {
                type = T_BRANCH;
            } else if (this.versionRelation.getRelationType() == VfsVersionRelationType.COPY_MERGE) {
                type = T_COPY_MERGE;
            } else if (this.versionRelation.getRelationType() == VfsVersionRelationType.CYCLIC_MERGE_COLLISION) {
                type = T_CYCLIC_MERGE_COLLISION;
            } else if (this.versionRelation.getRelationType() == VfsVersionRelationType.DISCARD_MERGE) {
                type = T_DISCARD_MERGE;
            } else if (this.versionRelation.getRelationType() == VfsVersionRelationType.EDIT_MERGE) {
                type = T_EDIT_MERGE;
            } else if (this.versionRelation.getRelationType() == VfsVersionRelationType.MERGE) {
                type = T_MERGE;
            } else if (this.versionRelation.getRelationType() == VfsVersionRelationType.PRED_SUCC_COLLISION) {
                type = T_PRED_SUCC_COLLISION;
            } else if (this.versionRelation.getRelationType() == VfsVersionRelationType.PRED_SUCC) {
                type = T_PRED_SUCC;
            }
            return type;
        }
        if (id.equals(P_ID_CREATIONDATE)) {
            if (this.versionRelation.getRelationType() == VfsVersionRelationType.PRED_SUCC) {
                return Util.getGMTString(this.versionRelation.getRelationCreationDate());
            }
            return Util.getGMTString(this.versionRelation.getRelationCreationDate());
        }
        if (id.equals(P_ID_CREATOR)) {
            if (this.versionRelation.getRelationType() == VfsVersionRelationType.PRED_SUCC || this.versionRelation.getCreator() == null || this.versionRelation.getCreator().length() == 0) {
                return this.versionRelation.getCreator();
            }
            return this.versionRelation.getCreator();
        }
        if (id.equals(P_ID_RESOURCETYPE)) {
            return T_VERSION_RELATION;
        }
        return null;
    }

    static {
        PropertyDescriptor property = new PropertyDescriptor((Object)P_ID_RELATIONTYPE, P_RELATIONTYPE);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_CREATIONDATE, P_CREATIONDATE);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_CREATOR, P_CREATOR);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_RESOURCETYPE, P_RESOURCETYPE);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
    }
}

