/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.view;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.view.VfsObjectPropertySheet;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class VersionPropertySheet
extends VfsObjectPropertySheet {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$view$VersionPropertySheet == null ? (class$com$tssap$dtr$client$eclipse$ui$view$VersionPropertySheet = VersionPropertySheet.class$("com.tssap.dtr.client.eclipse.ui.view.VersionPropertySheet")) : class$com$tssap$dtr$client$eclipse$ui$view$VersionPropertySheet));
    private IVfsVersion version;
    private static final String P_ID_LASTMODIFIED = "creationdate";
    private static final String P_ID_LASTMODIFIER = "creator";
    private static final String P_ID_NAME = "name";
    private static final String P_ID_XCMOID = "oid";
    private static final String P_ID_RESOURCETYPE = "resourcetype";
    private static final String P_ID_SEQUENCENO = "sequencenumber";
    private static final String P_ID_STATE = "state";
    private static final String P_ID_URL = "url";
    private static final String P_ID_WORKSPACE = "creationworkspace";
    private static final String P_ID_WORKSPACE_ID = "creationworkspaceid";
    private static final String P_LASTMODIFIED = "Last Modified";
    private static final String P_LASTMODIFIER = "Last Modifier";
    private static final String P_NAME = "Name";
    private static final String P_XCMOID = "Object ID";
    private static final String P_RESOURCETYPE = "Resource Type";
    private static final String P_SEQUENCENO = "Branch Sequence No.";
    private static final String P_STATE = "State";
    private static final String P_URL = "URL";
    private static final String P_WORKSPACE = "Creation Workspace";
    private static final String P_WORKSPACE_ID = "Creation Workspace ID";
    private static final String T_VERSION = "VERSION";
    private static final String T_OPEN = "OPEN";
    private static final String T_CLOSED = "CLOSED";
    private static final String T_VIRTUAL = "VIRTUAL";
    private static final String NOT_AVAILABLE = "<Not Available>";
    private static ArrayList descriptors = new ArrayList();
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$view$VersionPropertySheet;

    public VersionPropertySheet(IVfsVersion version) {
        this.version = version;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (this.version != null) {
            try {
                if (id.equals(P_ID_LASTMODIFIED)) {
                    return Util.getGMTString(this.version.getLastModifiedDate());
                }
                if (id.equals(P_ID_LASTMODIFIER)) {
                    return this.version.getAuthor();
                }
                if (id.equals(P_ID_NAME)) {
                    return this.version.getDisplayName();
                }
                if (id.equals(P_ID_XCMOID)) {
                    return this.version.getObjectID();
                }
                if (id.equals(P_ID_RESOURCETYPE)) {
                    return T_VERSION;
                }
                if (id.equals(P_ID_SEQUENCENO)) {
                    return new Integer(this.version.getBranchSequenceNumber());
                }
                if (id.equals(P_ID_STATE)) {
                    String state = this.version.isOpen() ? T_OPEN : T_CLOSED;
                    if (this.version.isVirtual()) {
                        state = state.concat(T_VIRTUAL);
                    }
                    return state;
                }
                if (id.equals(P_ID_URL)) {
                    return this.version.getUrl();
                }
                if (id.equals(P_ID_WORKSPACE)) {
                    return this.version.getCreatorWorkspaceName();
                }
                if (id.equals(P_ID_WORKSPACE_ID)) {
                    IVfsWorkspace creationWorkspace = this.version.getCreatorWorkspace();
                    if (creationWorkspace != null) {
                        return creationWorkspace.getObjectID();
                    }
                    return NOT_AVAILABLE;
                }
            }
            catch (VfsException x) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                return "?";
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PropertyDescriptor property = new PropertyDescriptor((Object)P_ID_LASTMODIFIED, P_LASTMODIFIED);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_LASTMODIFIER, P_LASTMODIFIER);
        property.setAlwaysIncompatible(true);
        property.setFilterFlags(VfsObjectPropertySheet.FILTER);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_NAME, P_NAME);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_XCMOID, P_XCMOID);
        property.setAlwaysIncompatible(true);
        property.setFilterFlags(VfsObjectPropertySheet.FILTER);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_RESOURCETYPE, P_RESOURCETYPE);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_SEQUENCENO, P_SEQUENCENO);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_STATE, P_STATE);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_URL, P_URL);
        property.setAlwaysIncompatible(true);
        property.setFilterFlags(VfsObjectPropertySheet.FILTER);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_WORKSPACE, P_WORKSPACE);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_WORKSPACE_ID, P_WORKSPACE_ID);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
    }
}

