/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.view;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.view.VfsObjectPropertySheet;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FolderPropertySheet
extends VfsObjectPropertySheet {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$view$FolderPropertySheet == null ? (class$com$tssap$dtr$client$eclipse$ui$view$FolderPropertySheet = FolderPropertySheet.class$("com.tssap.dtr.client.eclipse.ui.view.FolderPropertySheet")) : class$com$tssap$dtr$client$eclipse$ui$view$FolderPropertySheet));
    private IVfsActivityRecordedFolderItem m_folder;
    protected boolean m_isLocalOnly;
    protected boolean m_isServerOnly;
    protected boolean m_isMounted;
    private static final String P_ID_LASTMODIFIED = "creationdate";
    private static final String P_ID_LASTMODIFIER = "creator";
    private static final String P_ID_NAME = "name";
    private static final String P_ID_XCMOID = "oid";
    private static final String P_ID_LOCALPATH = "localpath";
    private static final String P_ID_REMOTEPATH = "remotepath";
    private static final String P_ID_RESOURCETYPE = "resourcetype";
    private static final String P_ID_STATE = "state";
    private static final String P_ID_URL = "url";
    private static final String P_LASTMODIFIED = "Last Modified";
    private static final String P_LASTMODIFIER = "Last Modifier";
    private static final String P_NAME = "Name";
    private static final String P_XCMOID = "Object ID";
    private static final String P_LOCALPATH = "Path (local)";
    private static final String P_REMOTEPATH = "Path (remote)";
    private static final String P_RESOURCETYPE = "Resource Type";
    private static final String P_STATE = "State";
    private static final String P_URL = "URL";
    private static ArrayList descriptors = new ArrayList();
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$view$FolderPropertySheet;

    public FolderPropertySheet(IVfsActivityRecordedFolderItem folder) {
        this.m_folder = folder;
        this.m_isLocalOnly = this.m_folder.getLocationState().equals(VfsFolderItemLocationState.LOCAL_ONLY);
        this.m_isServerOnly = this.m_folder.getLocationState().equals(VfsFolderItemLocationState.SERVER_ONLY);
        this.m_isMounted = !this.m_folder.getLocationState().equals(VfsFolderItemLocationState.NOT_MOUNTED);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (this.m_folder != null) {
            try {
                if (id.equals(P_ID_LASTMODIFIED)) {
                    return Util.getGMTString(this.m_folder.getLastModifiedDate());
                }
                if (id.equals(P_ID_LASTMODIFIER) && !this.m_isLocalOnly) {
                    return this.m_folder.getAuthor();
                }
                if (id.equals(P_ID_NAME)) {
                    return this.m_folder.getName();
                }
                if (id.equals(P_ID_XCMOID)) {
                    return this.m_folder.getObjectID();
                }
                if (id.equals(P_ID_LOCALPATH)) {
                    if (!this.m_isServerOnly) {
                        return this.m_folder.getLocalPath();
                    }
                    if (this.m_isMounted) {
                        return "[ " + this.m_folder.getLocalPath() + " ]";
                    }
                } else {
                    if (id.equals(P_ID_REMOTEPATH)) {
                        if (!this.m_isLocalOnly) {
                            return this.m_folder.getBrowsePath();
                        }
                        return "[ " + this.m_folder.getBrowsePath() + " ]";
                    }
                    if (id.equals(P_ID_RESOURCETYPE)) {
                        return this.m_folder.getCategory().toString();
                    }
                    if (id.equals(P_ID_STATE)) {
                        String locationState = this.m_folder.getLocationState().toString();
                        String activityState = this.m_folder.asActivityRecordedFolderItem().getActivityState().toString();
                        if (activityState.equals("")) {
                            return locationState;
                        }
                        return locationState + ", " + activityState;
                    }
                    if (id.equals(P_ID_URL) && !this.m_isLocalOnly) {
                        return this.m_folder.getUrl();
                    }
                }
            }
            catch (VfsException x) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                return "?";
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PropertyDescriptor property = new PropertyDescriptor((Object)P_ID_LASTMODIFIED, P_LASTMODIFIED);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_LASTMODIFIER, P_LASTMODIFIER);
        property.setAlwaysIncompatible(true);
        property.setFilterFlags(VfsObjectPropertySheet.FILTER);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_NAME, P_NAME);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_XCMOID, P_XCMOID);
        property.setAlwaysIncompatible(true);
        property.setFilterFlags(VfsObjectPropertySheet.FILTER);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_LOCALPATH, P_LOCALPATH);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_REMOTEPATH, P_REMOTEPATH);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_RESOURCETYPE, P_RESOURCETYPE);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_STATE, P_STATE);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_URL, P_URL);
        property.setAlwaysIncompatible(true);
        property.setFilterFlags(VfsObjectPropertySheet.FILTER);
        property.setCategory("DTR Info");
        descriptors.add(property);
    }
}

