/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.view;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.view.FolderPropertySheet;
import com.tssap.dtr.client.eclipse.ui.view.VfsObjectPropertySheet;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FilePropertySheet
extends FolderPropertySheet {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$view$FilePropertySheet == null ? (class$com$tssap$dtr$client$eclipse$ui$view$FilePropertySheet = FilePropertySheet.class$("com.tssap.dtr.client.eclipse.ui.view.FilePropertySheet")) : class$com$tssap$dtr$client$eclipse$ui$view$FilePropertySheet));
    private static final String P_ID_CONTENTTYPE = "contenttype";
    private static final String P_ID_SEQUENCENUMBER = "sequenceno";
    private static final String P_ID_CONTENTLENGTH = "contentlength";
    private static final String P_ID_FOREIGN_CHECKOUT_BY = "foreignco";
    private static final String P_CONTENTTYPE = "Content Type";
    private static final String P_SEQUENCENUMBER = "Branch Sequence No.";
    private static final String P_CONTENTLENGTH = "Size (byte)";
    private static final String P_FOREIGN_CHECKOUT_BY = "Checked-out by Others";
    private IVfsFile m_file;
    private static IPropertyDescriptor[] fileDescriptors;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$view$FilePropertySheet;

    public FilePropertySheet(IVfsFile file) {
        super((IVfsActivityRecordedFolderItem)file);
        this.m_file = file;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (fileDescriptors == null) {
            this.initFileDescriptors();
        }
        return fileDescriptors;
    }

    public Object getPropertyValue(Object id) {
        if (this.m_file != null) {
            Object value = super.getPropertyValue(id);
            if (value != null) {
                return value;
            }
            try {
                if (id.equals(P_ID_CONTENTTYPE) && !this.m_isLocalOnly) {
                    return this.m_file.getMimeType();
                }
                if (id.equals(P_ID_SEQUENCENUMBER)) {
                    if (!this.m_isLocalOnly) {
                        IVfsVersion syncedVersion = this.m_file.getSyncedVersion();
                        int syncedSequenceNo = syncedVersion == null ? 0 : syncedVersion.getBranchSequenceNumber();
                        if (this.m_file.getActiveVersion() != null) {
                            return syncedSequenceNo + " / " + this.m_file.getActiveVersion().getBranchSequenceNumber();
                        }
                        return syncedSequenceNo + " / " + "?";
                    }
                    return "0 / 0";
                }
                if (id.equals(P_ID_CONTENTLENGTH)) {
                    return Long.toString(this.m_file.getLength());
                }
                if (id.equals(P_ID_FOREIGN_CHECKOUT_BY) && this.m_file.isCheckedOutByOthers()) {
                    String str = "";
                    String[] names = this.m_file.getOtherCheckouters();
                    int i = 0;
                    while (i < names.length) {
                        if (i != 0) {
                            str = str + ", ";
                        }
                        str = str + names[i];
                        ++i;
                    }
                    return str;
                }
            }
            catch (VfsException x) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                return "?";
            }
        }
        return null;
    }

    private void initFileDescriptors() {
        IPropertyDescriptor[] folderDescriptors = super.getPropertyDescriptors();
        int superLength = folderDescriptors.length;
        IPropertyDescriptor[] additionalDescriptors = FilePropertySheet.getFileDescriptors();
        fileDescriptors = new IPropertyDescriptor[superLength + additionalDescriptors.length];
        System.arraycopy(folderDescriptors, 0, fileDescriptors, 0, superLength);
        System.arraycopy(additionalDescriptors, 0, fileDescriptors, superLength, additionalDescriptors.length);
    }

    private static IPropertyDescriptor[] getFileDescriptors() {
        ArrayList<PropertyDescriptor> additions = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor property = new PropertyDescriptor((Object)P_ID_CONTENTTYPE, P_CONTENTTYPE);
        property.setAlwaysIncompatible(true);
        property.setFilterFlags(VfsObjectPropertySheet.FILTER);
        property.setCategory("DTR Info");
        additions.add(property);
        property = new PropertyDescriptor((Object)P_ID_SEQUENCENUMBER, P_SEQUENCENUMBER);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        additions.add(property);
        property = new PropertyDescriptor((Object)P_ID_CONTENTLENGTH, P_CONTENTLENGTH);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        additions.add(property);
        property = new PropertyDescriptor((Object)P_ID_FOREIGN_CHECKOUT_BY, P_FOREIGN_CHECKOUT_BY);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        additions.add(property);
        return additions.toArray(new IPropertyDescriptor[additions.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

