/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.view;

import com.tssap.dtr.client.eclipse.ui.view.VfsObjectPropertySheet;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.VfsCollisionType;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CollisionPropertySheet
extends VfsObjectPropertySheet {
    private IVfsIntegrateCollision m_collision;
    private static final String P_ID_RESOURCETYPE = "resourcetype";
    private static final String P_ID_CREATIONDATE = "creationdate";
    private static final String P_ID_CREATOR = "creator";
    private static final String P_ID_TYPE = "type";
    private static final String P_ID_URL = "url";
    private static final String P_ID_VERSIONNAME = "versionname";
    private static final String P_ID_WORKSPACE = "creationworkspace";
    private static final String P_ID_ACTIVE_VERSION = "activeversion";
    private static final String P_ID_COLLIDING_VERSION = "collidingversion";
    private static final String P_ID_ISN = "isn";
    private static final String P_RESOURCETYPE = "Resource Type";
    private static final String P_CREATIONDATE = "Creation Date";
    private static final String P_CREATOR = "Creator";
    private static final String P_TYPE = "Conflict Type";
    private static final String P_URL = "URL";
    private static final String P_WORKSPACE = "Workspace";
    private static final String P_ACTIVE_VERSION = "Active Version";
    private static final String P_COLLIDING_VERSION = "Conflicting Version";
    private static final String P_ISN = "Integration Sequence No.";
    private static final String T_PRED_SUCC = "Predecessor-Successor Conflict";
    private static final String T_NAME_CLASH = "Name Conflict";
    private static final String T_CYCLIC_MERGE = "Cyclic-Merge Conflict";
    private static final String T_COLLISION = "INTEGRATION CONFLICT";
    private static ArrayList descriptors = new ArrayList();

    public CollisionPropertySheet(IVfsIntegrateCollision collision) {
        this.m_collision = collision;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(P_ID_TYPE)) {
            String type = null;
            if (this.m_collision.getCollisionType() == VfsCollisionType.PRED_SUCC) {
                type = T_PRED_SUCC;
            } else if (this.m_collision.getCollisionType() == VfsCollisionType.NAME_CLASH) {
                type = T_NAME_CLASH;
            } else if (this.m_collision.getCollisionType() == VfsCollisionType.CYCLIC_MERGE) {
                type = T_CYCLIC_MERGE;
            }
            return type;
        }
        if (id.equals(P_ID_URL)) {
            return this.m_collision.getPath();
        }
        if (id.equals(P_ID_WORKSPACE)) {
            return this.m_collision.getWorkspacePath();
        }
        if (id.equals(P_ID_ACTIVE_VERSION)) {
            return this.m_collision.getActiveVersionDescription();
        }
        if (id.equals(P_ID_COLLIDING_VERSION)) {
            return this.m_collision.getCollidingVersionDescription();
        }
        if (id.equals(P_ID_CREATIONDATE)) {
            return Util.getGMTString(this.m_collision.getCreationDate());
        }
        if (id.equals(P_ID_CREATOR)) {
            return this.m_collision.getCreator();
        }
        if (id.equals(P_ID_ISN)) {
            return this.m_collision.getIntegrationSequenceNumber();
        }
        if (id.equals(P_ID_RESOURCETYPE)) {
            return T_COLLISION;
        }
        return null;
    }

    static {
        PropertyDescriptor property = new PropertyDescriptor((Object)P_ID_TYPE, P_TYPE);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_URL, P_URL);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_WORKSPACE, P_WORKSPACE);
        property.setAlwaysIncompatible(true);
        property.setFilterFlags(VfsObjectPropertySheet.FILTER);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_ACTIVE_VERSION, P_ACTIVE_VERSION);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_COLLIDING_VERSION, P_COLLIDING_VERSION);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_CREATIONDATE, P_CREATIONDATE);
        property.setAlwaysIncompatible(true);
        property.setFilterFlags(VfsObjectPropertySheet.FILTER);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_CREATOR, P_CREATOR);
        property.setAlwaysIncompatible(true);
        property.setFilterFlags(VfsObjectPropertySheet.FILTER);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_ISN, P_ISN);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
        property = new PropertyDescriptor((Object)P_ID_RESOURCETYPE, P_RESOURCETYPE);
        property.setAlwaysIncompatible(true);
        property.setCategory("DTR Info");
        descriptors.add(property);
    }
}

