/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.util;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.util.ConfigurationUtil;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class WorkspacesWithDefaultActivity {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$util$WorkspacesWithDefaultActivity == null ? (class$com$tssap$dtr$client$eclipse$ui$util$WorkspacesWithDefaultActivity = WorkspacesWithDefaultActivity.class$("com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity")) : class$com$tssap$dtr$client$eclipse$ui$util$WorkspacesWithDefaultActivity));
    private static TreeSet workspaces = new TreeSet();
    private static File workspacesFile = ConfigurationUtil.getConfigFile("useDefault.workspaces");
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$util$WorkspacesWithDefaultActivity;

    public static boolean usingDefaultActivity(IVfsWorkspace workspace) {
        try {
            String ws = workspace.getContext().getClientName() + ":" + workspace.getBrowsePath();
            if (workspaces.contains(ws)) {
                return true;
            }
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
        return false;
    }

    public static void addWorkspace(IVfsWorkspace workspace) {
        if (!WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
            try {
                String ws = workspace.getContext().getClientName() + ":" + workspace.getBrowsePath();
                workspaces.add(ws);
                WorkspacesWithDefaultActivity.persist();
                Logbook.getInfoChapter().println("Switched to default activity mode for workspace \"" + workspace.getDisplayName() + "\".");
            }
            catch (VfsException x) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        WorkspacesWithDefaultActivity.updateOpenActivityTreeViewer(workspace);
    }

    public static void removeWorkspace(IVfsWorkspace workspace) {
        try {
            String ws = workspace.getContext().getClientName() + ":" + workspace.getBrowsePath();
            workspaces.remove(ws);
            WorkspacesWithDefaultActivity.persist();
            Logbook.getInfoChapter().println("Switched off default activity mode for workspace \"" + workspace.getDisplayName() + "\".");
            WorkspacesWithDefaultActivity.updateOpenActivityTreeViewer(workspace);
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void depersist() {
        workspaces.clear();
        try {
            String workspace;
            FileReader fileReader = new FileReader(workspacesFile);
            BufferedReader reader = new BufferedReader(fileReader);
            while ((workspace = reader.readLine()) != null) {
                void var2_3;
                workspaces.add(var2_3);
            }
            reader.close();
            fileReader.close();
        }
        catch (IOException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
    }

    private static void persist() {
        try {
            FileWriter fileWriter = new FileWriter(workspacesFile);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            Iterator iterator = workspaces.iterator();
            while (iterator.hasNext()) {
                String workspace = (String)iterator.next();
                writer.write(workspace);
                writer.newLine();
            }
            writer.close();
            fileWriter.close();
        }
        catch (IOException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
    }

    private static void updateOpenActivityTreeViewer(final IVfsWorkspace workspace) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            final IWorkbenchPage[] pages = window.getPages();
            if (pages == null) {
                return;
            }
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < pages.length) {
                        IViewReference[] views = pages[i].getViewReferences();
                        if (views != null) {
                            int j = 0;
                            while (j < views.length) {
                                TreeViewer treeViewer;
                                IViewPart viewPart = views[j].getView(false);
                                if (viewPart instanceof RepositoryView && ((RepositoryView)viewPart).getViewID().equals("com.tssap.dtr.client.eclipse.ui.treeBrowser.OpenActivityView") && (treeViewer = ((RepositoryView)viewPart).getRepositoryTreeViewer().getTreeViewer()) != null) {
                                    treeViewer.refresh((Object)workspace, true);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            });
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        WorkspacesWithDefaultActivity.depersist();
    }
}

