/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.util;

import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ResizableTitleDialog
extends Dialog {
    private Composite fComposite;
    private String fTitle;
    private Image fTitleImage;
    private static final int MIN_DIALOG_WIDTH = 450;
    private static final int MIN_DIALOG_HEIGHT = 250;

    public ResizableTitleDialog(Shell parent, String title, Image titleImage) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fTitle = title;
        this.fTitleImage = titleImage;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
        if (this.fTitleImage != null) {
            shell.setImage(this.fTitleImage);
        }
    }

    protected Control createContents(Composite parent) {
        this.fComposite = parent;
        return super.createContents(parent);
    }

    protected Point getInitialSize() {
        Shell s = this.getShell();
        if (s != null) {
            s.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent arg0) {
                }

                public void controlResized(ControlEvent arg0) {
                    ResizableTitleDialog.this.fComposite.layout(true);
                }
            });
        }
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(450), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(250), shellSize.y));
    }

    protected IPreferenceStore getPreferenceStore() {
        return BluebirdPlugin.getDefault().getPreferenceStore();
    }
}

