/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.util;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.util.ConfigurationUtil;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class RepositoryBrowseFavorite {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$util$RepositoryBrowseFavorite == null ? (class$com$tssap$dtr$client$eclipse$ui$util$RepositoryBrowseFavorite = RepositoryBrowseFavorite.class$("com.tssap.dtr.client.eclipse.ui.util.RepositoryBrowseFavorite")) : class$com$tssap$dtr$client$eclipse$ui$util$RepositoryBrowseFavorite));
    private static File favoritesFile = ConfigurationUtil.getConfigFile(".favorites");
    private static TreeSet allFavoriteEntries = new TreeSet();
    private static TreeSet others = new TreeSet();
    private static TreeMap currentFavorites = new TreeMap();
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$util$RepositoryBrowseFavorite;

    public static void addFavorite(IVfsFolderItem item, String name) {
        try {
            String favoritePath = item.getContext().getClientName() + "<" + item.getBrowsePath();
            currentFavorites.put(favoritePath, name);
            String favoriteEntry = favoritePath + ">" + name;
            allFavoriteEntries.add(favoriteEntry);
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
        RepositoryBrowseFavorite.persist();
    }

    public static TreeMap getFavoritesForClientdef(String clientdefName) {
        currentFavorites.clear();
        String s = clientdefName + "<";
        Iterator iterator = allFavoriteEntries.iterator();
        while (iterator.hasNext()) {
            String favorite = (String)iterator.next();
            if (favorite.startsWith(s)) {
                currentFavorites.put(favorite.substring(0, favorite.indexOf(">")), favorite.substring(favorite.indexOf(">") + 1));
                continue;
            }
            others.add(favorite);
        }
        return currentFavorites;
    }

    public static boolean gotoFavorite(TreeViewer viewer, IVfsFolderItem item) {
        if (item == null) {
            return false;
        }
        viewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
        return viewer.testFindItem((Object)item) != null;
    }

    public static void deleteFavorite(String clientdefName, String path) {
        String favorite = clientdefName + "<" + path;
        allFavoriteEntries.remove(favorite + ">" + currentFavorites.get(favorite));
        currentFavorites.remove(favorite);
        RepositoryBrowseFavorite.persist();
    }

    /*
     * WARNING - void declaration
     */
    public static void depersist() {
        allFavoriteEntries.clear();
        currentFavorites.clear();
        others.clear();
        try {
            String favorite;
            FileReader fileReader = new FileReader(favoritesFile);
            BufferedReader reader = new BufferedReader(fileReader);
            while ((favorite = reader.readLine()) != null) {
                void var2_3;
                allFavoriteEntries.add(var2_3);
            }
            reader.close();
            fileReader.close();
        }
        catch (IOException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
    }

    private static void persist() {
        String favorite;
        Iterator<Object> iterator = currentFavorites.keySet().iterator();
        while (iterator.hasNext()) {
            String path = (String)iterator.next();
            favorite = path.concat(">").concat((String)currentFavorites.get(path));
            others.add(favorite);
        }
        try {
            FileWriter fileWriter = new FileWriter(favoritesFile);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            iterator = others.iterator();
            while (iterator.hasNext()) {
                favorite = (String)iterator.next();
                writer.write(favorite);
                writer.newLine();
            }
            writer.close();
            fileWriter.close();
            currentFavorites.clear();
            others.clear();
        }
        catch (IOException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RepositoryBrowseFavorite.depersist();
    }
}

