/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.util;

import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.util.ConcreteCompositeImageDescriptor;
import com.tssap.dtr.client.eclipse.ui.util.MultiCompositeImageDescriptor;
import com.tssap.dtr.client.eclipse.ui.util.ObjectImageDescriptor;
import com.tssap.dtr.client.eclipse.ui.util.ObjectOffsets;
import com.tssap.dtr.client.eclipse.ui.util.StretchedMultiCompositeImageDescriptor;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public final class PluginImageRegistry {
    private static final String NULL_KEY = "BLANK";
    private static final String ICON_PREFIX = "browserIcons/";
    private static final String ICON_PREFIX_CONFIG = "config/";
    private static final String ICON_SUFFIX = ".gif";
    private static final String CAT_FOLDER = "FOLDER";
    private static ImageDescriptor NULL_IMAGE_DESCRIPTOR = PluginImageRegistry.getBrowserImageDescriptor("BLANK");
    private BluebirdPlugin _bluebirdPlugin = BluebirdPlugin.getDefault();

    private static ImageRegistry getImageRegistry() {
        return BluebirdPlugin.getDefault().getImageRegistry();
    }

    public static Image getCompositeImage(Object category, Object locationState, Object activityState) {
        if (category == null) {
            category = "";
        }
        if (locationState == null) {
            locationState = "";
        }
        if (activityState == null) {
            activityState = "";
        }
        String key = category.toString() + "+" + locationState.toString() + "+" + activityState.toString();
        if (PluginImageRegistry.getImageRegistry().get(key) == null) {
            PluginImageRegistry.putImage(key, category, locationState, activityState);
        }
        return PluginImageRegistry.getImageRegistry().get(key);
    }

    public static Image getCompositeImage(Image image, Object locationState, Object activityState) {
        if (image == null) {
            return null;
        }
        if (locationState == null) {
            locationState = "";
        }
        if (activityState == null) {
            activityState = "";
        }
        String key = image.toString() + "+" + locationState.toString() + "+" + activityState.toString();
        if (PluginImageRegistry.getImageRegistry().get(key) == null) {
            PluginImageRegistry.putImage(key, image, locationState, activityState);
        }
        return PluginImageRegistry.getImageRegistry().get(key);
    }

    public static Image getAtomicImage(String key) {
        ObjectOffsets objectOffsets = new ObjectOffsets();
        objectOffsets.add(key, 0);
        return BluebirdPlugin.getDefault().getPluginImageRegistry().getImage(objectOffsets, false);
    }

    public static Image getAtomicConfigImage(String key) {
        if (key == null) {
            key = "";
        }
        if (PluginImageRegistry.getImageRegistry().get(key) == null) {
            if (key.equals("")) {
                PluginImageRegistry.getImageRegistry().put(key, NULL_IMAGE_DESCRIPTOR);
            } else {
                PluginImageRegistry.getImageRegistry().put(key, PluginImageRegistry.getConfigImageDescriptor(key));
            }
        }
        return PluginImageRegistry.getImageRegistry().get(key);
    }

    private static void putImage(String key, Object category, Object locationState, Object activityState) {
        ConcreteCompositeImageDescriptor descriptor;
        ImageDescriptor imageDescriptor_loc = locationState == null || locationState.equals("") ? NULL_IMAGE_DESCRIPTOR : (locationState.equals(VfsFolderItemLocationState.SYNCED_TO_LATEST) && (category.toString().equals(CAT_FOLDER) || category.toString().equals(VfsFolderItemCategory.WORKSPACE.toString()) || category.toString().equals(VfsFolderItemCategory.WORKSPACE_FOLDER.toString()) || category.toString().equals(VfsFolderItemCategory.ROOT.toString())) ? PluginImageRegistry.getBrowserImageDescriptor(VfsFolderItemLocationState.MOUNTED.toString()) : PluginImageRegistry.getBrowserImageDescriptor(locationState.toString()));
        ImageDescriptor imageDescriptor_act = activityState == null || activityState.equals("") ? NULL_IMAGE_DESCRIPTOR : PluginImageRegistry.getBrowserImageDescriptor(activityState.toString());
        if (category instanceof Image) {
            descriptor = new ConcreteCompositeImageDescriptor((Image)category, (ImageDescriptor)new ConcreteCompositeImageDescriptor(imageDescriptor_loc, imageDescriptor_act));
        } else if (category instanceof ImageDescriptor) {
            descriptor = new ConcreteCompositeImageDescriptor((ImageDescriptor)category, (ImageDescriptor)new ConcreteCompositeImageDescriptor(imageDescriptor_loc, imageDescriptor_act));
        } else {
            ImageDescriptor imageDescriptor_cat = category.equals("") ? NULL_IMAGE_DESCRIPTOR : PluginImageRegistry.getBrowserImageDescriptor(category.toString());
            descriptor = new ConcreteCompositeImageDescriptor(imageDescriptor_cat, (ImageDescriptor)new ConcreteCompositeImageDescriptor(imageDescriptor_loc, imageDescriptor_act));
        }
        PluginImageRegistry.getImageRegistry().put(key, (ImageDescriptor)descriptor);
    }

    private static ImageDescriptor getBrowserImageDescriptor(String fileName) {
        ImageDescriptor imageDesc = BluebirdPlugin.getDefault().createImageDescriptor(ICON_PREFIX + fileName + ICON_SUFFIX);
        if (imageDesc != null) {
            return imageDesc;
        }
        return NULL_IMAGE_DESCRIPTOR;
    }

    private static ImageDescriptor getConfigImageDescriptor(String fileName) {
        ImageDescriptor imageDesc = BluebirdPlugin.getDefault().createImageDescriptor(ICON_PREFIX_CONFIG + fileName + ICON_SUFFIX);
        if (imageDesc != null) {
            return imageDesc;
        }
        return NULL_IMAGE_DESCRIPTOR;
    }

    public PluginImageRegistry(BluebirdPlugin plugin) {
        this._bluebirdPlugin = plugin;
    }

    public Image getImage(Object[] propertyKeys) {
        return this.getImage(null, propertyKeys);
    }

    public Image getImage(Image backgroundImage, Object[] propertyKeys) {
        ObjectOffsets objectOffsets = new ObjectOffsets();
        if (backgroundImage != null) {
            objectOffsets.add(backgroundImage, 0);
        }
        int i = 0;
        while (i < propertyKeys.length) {
            Object propertyKey = propertyKeys[i];
            objectOffsets.add(propertyKey, 0);
            ++i;
        }
        return this.getImage(objectOffsets, false);
    }

    public Image getImage(ObjectOffsets objectOffsets, boolean stretch) {
        Object descriptor;
        ImageDescriptor[] objectImageDescriptors = new ObjectImageDescriptor[objectOffsets.size()];
        int[] xOffsets = new int[objectOffsets.size()];
        StringBuffer keyBuffer = new StringBuffer();
        int i = 0;
        Iterator iterator = objectOffsets.iterator();
        while (iterator.hasNext()) {
            ObjectOffsets.ObjectOffset objectOffset = (ObjectOffsets.ObjectOffset)iterator.next();
            Object propertyKey = objectOffset.getObject();
            descriptor = ObjectImageDescriptor.getDescriptor(propertyKey);
            objectImageDescriptors[i] = descriptor;
            xOffsets[i] = objectOffset.getOffset();
            keyBuffer.append(((ObjectImageDescriptor)((Object)descriptor)).getKey()).append('\u0000').append(objectOffset.getOffset()).append('\u0000');
            ++i;
        }
        String key = keyBuffer.toString();
        Image image = this._bluebirdPlugin.getImageRegistry().get(key);
        if (image == null) {
            descriptor = stretch ? new StretchedMultiCompositeImageDescriptor(objectImageDescriptors, xOffsets) : new MultiCompositeImageDescriptor(null, objectImageDescriptors);
            this._bluebirdPlugin.getImageRegistry().put(key, (ImageDescriptor)descriptor);
            image = this._bluebirdPlugin.getImageRegistry().get(key);
        }
        return image;
    }
}

