/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.util;

import java.util.ArrayList;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class MultiCompositeImageDescriptor
extends CompositeImageDescriptor {
    private Image _backgroundImage;
    private ImageDescriptor[] _imageDescriptors;
    private ImageData[] _imageDatas;
    Point _size;

    public MultiCompositeImageDescriptor(Image backgroundImage, ImageDescriptor[] descriptors) {
        this._backgroundImage = backgroundImage;
        this._imageDescriptors = (ImageDescriptor[])descriptors.clone();
    }

    ImageData[] getImageDatas() {
        if (this._imageDatas == null) {
            ArrayList<ImageData> datas = new ArrayList<ImageData>(this._imageDescriptors.length + 1);
            if (this._backgroundImage != null) {
                datas.add(this._backgroundImage.getImageData());
            }
            int i = 0;
            while (i < this._imageDescriptors.length) {
                ImageData data;
                ImageDescriptor imageDescriptor = this._imageDescriptors[i];
                if (imageDescriptor != null && (data = imageDescriptor.getImageData()) != null) {
                    datas.add(data);
                }
                ++i;
            }
            this._imageDatas = datas.toArray(new ImageData[datas.size()]);
        }
        return this._imageDatas;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData[] imageDatas = this.getImageDatas();
        int i = 0;
        while (i < imageDatas.length) {
            ImageData imageData = imageDatas[i];
            this.drawImage(imageData, 0, 0);
            ++i;
        }
    }

    protected Point getSize() {
        if (this._size == null) {
            int maxWidth = 1;
            int maxHeight = 1;
            ImageData[] imageDatas = this.getImageDatas();
            int i = 0;
            while (i < imageDatas.length) {
                ImageData imageData = imageDatas[i];
                if (imageData.width > maxWidth) {
                    maxWidth = imageData.width;
                }
                if (imageData.height > maxHeight) {
                    maxHeight = imageData.height;
                }
                ++i;
            }
            this._size = new Point(maxWidth, maxHeight);
        }
        return this._size;
    }
}

