/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.util;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.util.ImageSingletone;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class LayoutHelper {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$util$LayoutHelper == null ? (class$com$tssap$dtr$client$eclipse$ui$util$LayoutHelper = LayoutHelper.class$("com.tssap.dtr.client.eclipse.ui.util.LayoutHelper")) : class$com$tssap$dtr$client$eclipse$ui$util$LayoutHelper));
    public static final ImageSingletone EMPTY_IMAGE = new ImageSingletone("NOT_CHECKED_OUT.gif");
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$util$LayoutHelper;

    public static Point parseCoordinates(String coordString) {
        int byIndex = coordString.indexOf(120);
        if (byIndex < 0) {
            return null;
        }
        try {
            int x = Integer.parseInt(coordString.substring(0, byIndex));
            int y = Integer.parseInt(coordString.substring(byIndex + 1));
            return new Point(x, y);
        }
        catch (NumberFormatException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return null;
        }
    }

    public static String serializeCoords(Point coords) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(coords.x);
        buffer.append('x');
        buffer.append(coords.y);
        return buffer.toString();
    }

    public static int getButtonWidthHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static int getButtonHeigthHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        return converter.convertVerticalDLUsToPixels(14);
    }

    public static int getControlHeigthHint(Control control) {
        PixelConverter converter = new PixelConverter(control);
        return converter.convertVerticalDLUsToPixels(14);
    }

    public static int getControlWidthHint(Control control) {
        PixelConverter converter = new PixelConverter(control);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, control.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PixelConverter {
        private FontMetrics fFontMetrics;

        public PixelConverter(Control control) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            this.fFontMetrics = gc.getFontMetrics();
            gc.dispose();
        }

        public int convertHeightInCharsToPixels(int chars) {
            return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
        }

        public int convertHorizontalDLUsToPixels(int dlus) {
            return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
        }

        public int convertVerticalDLUsToPixels(int dlus) {
            return Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
        }

        public int convertWidthInCharsToPixels(int chars) {
            return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
        }
    }
}

