/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.util;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DetailMessageDialog
extends MessageDialog {
    private String fDetailMessage;
    private int fDetailButtonID;
    private Text fDetailText;
    private static final int TEXT_LINE_COUNT = 10;

    public DetailMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, String detailMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.fDetailMessage = detailMessage;
        this.setShellStyle(this.getShellStyle() | 0x10000);
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getContents().computeSize(-1, -1);
        if (this.fDetailText != null) {
            this.fDetailText.dispose();
            this.fDetailText = null;
            this.getButton(this.fDetailButtonID).setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.createDropDownText((Composite)this.getContents());
            this.getButton(this.fDetailButtonID).setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    protected void createDropDownText(Composite parent) {
        this.fDetailText = new Text(parent, 2816);
        this.fDetailText.setFont(parent.getFont());
        this.fDetailText.setText(this.fDetailMessage);
        GridData data = new GridData(1808);
        data.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        data.heightHint = this.fDetailText.getLineHeight() * 10;
        this.fDetailText.setLayoutData((Object)data);
    }

    public void setDetailButton(int index) {
        this.fDetailButtonID = index;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == this.fDetailButtonID) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(buttonId);
        }
    }
}

