/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.VfsFolderLabelProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.VfsVersionLabelProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.Image;

public class VfsWorkspaceWFullPathLabelProvider
extends VfsFolderLabelProvider
implements IExecutableExtension {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsWorkspaceWFullPathLabelProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsWorkspaceWFullPathLabelProvider = VfsWorkspaceWFullPathLabelProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.VfsWorkspaceWFullPathLabelProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsWorkspaceWFullPathLabelProvider));
    private String m_viewId = null;
    private boolean m_withSortPossiblity;
    private VfsVersionLabelProvider m_versionLabelProvider;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsWorkspaceWFullPathLabelProvider;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof IConfigurationElement) {
            this.m_viewId = ((IConfigurationElement)data).getAttribute("id");
            this.m_withSortPossiblity = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(((IConfigurationElement)data).getAttribute("showSortMenu")));
        }
    }

    public String getText(Object element) {
        if (element instanceof IVfsWorkspace) {
            try {
                return ((IVfsWorkspace)element).getBrowsePath();
            }
            catch (VfsException unableToGetBrowsePath) {
                Logbook.getErrorChapter().println("Getting browse path of workspace failed: " + unableToGetBrowsePath.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)unableToGetBrowsePath);
                return "?";
            }
        }
        boolean sortByName = false;
        if (this.m_withSortPossiblity && this.m_viewId != null) {
            sortByName = this.getPreferenceStore().getBoolean(this.m_viewId + "_sortElementByName");
        }
        if (element instanceof IVfsActivityRecordedFolderItem) {
            String label = ".../" + ((IVfsActivityRecordedFolderItem)element).getWorkspaceRelativePath();
            if (sortByName) {
                label = ((IVfsActivityRecordedFolderItem)element).getName() + "   [" + label + "]";
            }
            if (((IVfsActivityRecordedFolderItem)element).hasLocalRemoteNameClash()) {
                label = label + "   < NAME CLASH >";
            } else if (((IVfsActivityRecordedFolderItem)element).isInconsistent()) {
                label = label + "   < INCONSISTENT >";
            }
            return label;
        }
        if (element instanceof IVfsActivityElement) {
            IVfsVersion version = ((IVfsActivityElement)element).getAsVersion();
            if (version == null) {
                throw new IllegalStateException("Internal error: version in open activity is <null>.");
            }
            String label = version.toString();
            if (sortByName) {
                label = version.getDisplayName() + "   [" + label + "]";
            }
            return label;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IVfsActivityElement) {
            return this.getVersionLabelProvider().getImage(((IVfsActivityElement)element).getAsVersion());
        }
        return super.getImage(element);
    }

    private VfsVersionLabelProvider getVersionLabelProvider() {
        if (this.m_versionLabelProvider == null) {
            this.m_versionLabelProvider = new VfsVersionLabelProvider();
        }
        return this.m_versionLabelProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

