/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.AbstractLabelProvider;
import com.tssap.dtr.client.eclipse.ui.util.ObjectOffsets;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.Image;

public class VfsVersionLabelProvider
extends AbstractLabelProvider
implements IExecutableExtension {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsVersionLabelProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsVersionLabelProvider = VfsVersionLabelProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.VfsVersionLabelProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsVersionLabelProvider));
    private static final String ITEM_VERSION = "VERSIONED";
    private String m_viewId = null;
    private boolean m_withSortPossiblity;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsVersionLabelProvider;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof IConfigurationElement) {
            this.m_viewId = ((IConfigurationElement)data).getAttribute("id");
            this.m_withSortPossiblity = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(((IConfigurationElement)data).getAttribute("showSortMenu")));
        }
    }

    public Image getImage(Object element) {
        if (element instanceof IVfsVersion) {
            IVfsVersion version = (IVfsVersion)element;
            try {
                ObjectOffsets objectOffsets = new ObjectOffsets();
                if (version.isFile()) {
                    objectOffsets.add("FILE", this.stretchImage() ? 5 : 0);
                } else {
                    objectOffsets.add("FOLDER", this.stretchImage() ? 5 : 0);
                }
                objectOffsets.add(ITEM_VERSION, this.stretchImage() ? 10 : 0);
                if (version.getBranchSequenceNumber() == 1) {
                    objectOffsets.add("CREATION", this.stretchImage() ? 0 : 0);
                } else if (version.isDeleted()) {
                    objectOffsets.add("DELETION", this.stretchImage() ? 0 : 0);
                }
                return BluebirdPlugin.getDefault().getPluginImageRegistry().getImage(objectOffsets, this.stretchImage());
            }
            catch (VfsException e) {
                Logbook.getErrorChapter().println(e.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IVfsVersion) {
            boolean sortByName = false;
            if (this.m_withSortPossiblity && this.m_viewId != null) {
                sortByName = this.getPreferenceStore().getBoolean(this.m_viewId + "_sortElementByName");
            }
            String label = element.toString();
            if (sortByName) {
                label = ((IVfsVersion)element).getDisplayName() + "   [" + label + "]";
            }
            return label;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

