/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.AbstractLabelProvider;
import com.tssap.dtr.client.eclipse.ui.util.ObjectOffsets;
import com.tssap.dtr.client.eclipse.vfs.VersionWrapper;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsCollisionType;
import org.eclipse.swt.graphics.Image;

public class VfsCollisionLabelProvider
extends AbstractLabelProvider {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsCollisionLabelProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsCollisionLabelProvider = VfsCollisionLabelProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.VfsCollisionLabelProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsCollisionLabelProvider));
    private static final String CAT_COLLISION = "COLLISION_";
    private static final String CAT_INTEGRATED_FILE = "FILE";
    private static final String ITEM_VERSION = "VERSIONED";
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsCollisionLabelProvider;

    public Image getImage(Object element) {
        ObjectOffsets objectOffsets = new ObjectOffsets();
        if (element instanceof IVfsIntegrateCollision) {
            IVfsIntegrateCollision collision = (IVfsIntegrateCollision)element;
            String imageFileName = CAT_COLLISION + collision.getCollisionState().getName().toUpperCase();
            objectOffsets.add(imageFileName, this.stretchImage() ? 5 : 0);
        } else if (element instanceof String) {
            objectOffsets.add(CAT_INTEGRATED_FILE, this.stretchImage() ? 5 : 0);
        } else if (element instanceof IVfsVersion) {
            objectOffsets.add(CAT_INTEGRATED_FILE, this.stretchImage() ? 5 : 0);
            objectOffsets.add(ITEM_VERSION, this.stretchImage() ? 10 : 0);
        } else {
            return null;
        }
        return BluebirdPlugin.getDefault().getPluginImageRegistry().getImage(objectOffsets, this.stretchImage());
    }

    public String getText(Object element) {
        if (element instanceof IVfsIntegrateCollision) {
            IVfsIntegrateCollision collision = (IVfsIntegrateCollision)element;
            try {
                IVfsVersion version = collision.getActiveVersion();
                if (collision.getCollisionType() == VfsCollisionType.NAME_CLASH) {
                    return version.toString() + "     < NAME CONFLICT >";
                }
                return version.toString();
            }
            catch (Exception unknownProblem) {
                Logbook.getErrorChapter().println(unknownProblem.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)unknownProblem);
                return "?";
            }
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof VersionWrapper) {
            return ((VersionWrapper)element).getDescription();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

