/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.AbstractLabelProvider;
import com.tssap.dtr.client.eclipse.ui.util.ObjectOffsets;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import org.eclipse.swt.graphics.Image;

public class VfsActivityLabelProvider
extends AbstractLabelProvider {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsActivityLabelProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsActivityLabelProvider = VfsActivityLabelProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.VfsActivityLabelProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsActivityLabelProvider));
    private static final String CAT_ACTIVITY = "ACTIVITY_";
    private static final String INTEGRATED_ACTIVITY = "INTEGRATED";
    protected static final String FOREIGN_USER = "FOREIGN_CO";
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$labelProviders$VfsActivityLabelProvider;

    public Image getImage(Object element) {
        try {
            if (element instanceof IVfsActivity) {
                String imageFileName = CAT_ACTIVITY + ((IVfsActivity)element).getState().toString();
                ObjectOffsets objectOffsets = new ObjectOffsets();
                objectOffsets.add(imageFileName, this.stretchImage() ? 5 : 0);
                return BluebirdPlugin.getDefault().getPluginImageRegistry().getImage(objectOffsets, this.stretchImage());
            }
            if (element instanceof ClosedActivityWrapper) {
                IVfsActivity activity = ((ClosedActivityWrapper)element).activity;
                IVfsWorkspace workspace = ((ClosedActivityWrapper)element).workspace;
                String imageFileName = CAT_ACTIVITY + activity.getState().toString();
                ObjectOffsets objectOffsets = new ObjectOffsets();
                objectOffsets.add(imageFileName, this.stretchImage() ? 5 : 0);
                if (!workspace.equals(activity.getWorkspace())) {
                    objectOffsets.add(INTEGRATED_ACTIVITY, this.stretchImage() ? 10 : 0);
                }
                if (activity.isForeign()) {
                    objectOffsets.add(FOREIGN_USER, this.stretchImage() ? 0 : 0);
                }
                return BluebirdPlugin.getDefault().getPluginImageRegistry().getImage(objectOffsets, this.stretchImage());
            }
        }
        catch (VfsException getActivityStateFailed) {
            Logbook.getErrorChapter().println(getActivityStateFailed.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)getActivityStateFailed);
        }
        return null;
    }

    public String getText(Object element) {
        try {
            if (element instanceof IVfsActivity) {
                IVfsWorkspace workspace;
                String name = ((IVfsActivity)element).getDisplayName();
                if (((IVfsActivity)element).isDefaultActivity() && (workspace = ((IVfsActivity)element).getWorkspace()) != null && WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
                    name = name + "   < DEFAULT >";
                }
                return name;
            }
            if (element instanceof ClosedActivityWrapper) {
                if (this.showAuthorOfForeignActivity()) {
                    IVfsActivity closedActivity = ((ClosedActivityWrapper)element).activity;
                    String label = closedActivity.getDisplayName();
                    if (closedActivity.isForeign()) {
                        label = "[" + closedActivity.getAuthor() + "]  " + label;
                    }
                    return label;
                }
                return ((ClosedActivityWrapper)element).activity.getDisplayName();
            }
        }
        catch (VfsException unknownProblem) {
            Logbook.getErrorChapter().println(unknownProblem.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)unknownProblem);
            return "?";
        }
        return null;
    }

    protected boolean showAuthorOfForeignActivity() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

