/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.inputProviders;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.TreeInputProvider;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class VersionedFileSystemManagerInputProvider
implements TreeInputProvider {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$inputProviders$VersionedFileSystemManagerInputProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$inputProviders$VersionedFileSystemManagerInputProvider = VersionedFileSystemManagerInputProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.inputProviders.VersionedFileSystemManagerInputProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$inputProviders$VersionedFileSystemManagerInputProvider));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$inputProviders$VersionedFileSystemManagerInputProvider;

    public int getNumberOfObjects() {
        return this.getClients().length;
    }

    public String getDisplayName(int index) {
        this.checkIndex(index);
        IClient current = this.getClients()[index];
        return "\"" + current.getName() + "\" (" + current.getAbsoluteLocalRoot() + ")";
    }

    public Object getInputObject(int index) {
        this.checkIndex(index);
        IClient current = this.getClients()[index];
        IVfsContext context = current.getContext();
        try {
            return VfsManagerProvider.getInstance().getVersionedFileSystemManager(context);
        }
        catch (VfsException unableToGetVFSManager) {
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
            if (part instanceof IViewPart) {
                ((IViewPart)part).getViewSite().getActionBars().getStatusLineManager().setErrorMessage(Dialog.getImage((String)"dialog_message_error_image"), unableToGetVFSManager.getMessage());
            } else {
                Logbook.getErrorChapter().println(unableToGetVFSManager.getMessage());
            }
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)unableToGetVFSManager);
            return null;
        }
    }

    public int getIndexOfDefaultInputObject() throws ConfigurationException {
        IClient[] clients = this.getClients();
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        if (clients.length == 0) {
            throw new ConfigurationException("No DTR clients configured.");
        }
        int i = 0;
        while (i < clients.length) {
            if (clients[i].equals(activeClient)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void refreshInput(Object currentInput) {
        if (currentInput instanceof IVersionedFileSystemManager) {
            IVfsGenericFolder iVfsGenericFolder = ((IVersionedFileSystemManager)currentInput).getRootFolder();
        }
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getClients().length) {
            throw new IndexOutOfBoundsException("Only 1 element present in this input provider. Unable to get element with index: " + index);
        }
    }

    private IClient[] getClients() {
        Iterator i = Configuration.getConfiguration().clients();
        ArrayList out = new ArrayList();
        while (i.hasNext()) {
            out.add(i.next());
        }
        return out.toArray(new IClient[out.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

