/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands;

import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.DNDUtility;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.VfsResourceTransfer;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.VFSDNDCommand;
import com.tssap.dtr.client.eclipse.ui.util.DetailMessageDialog;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionOnActivity;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsActionManager;
import com.tssap.dtr.client.lib.vfs.actions.UncheckoutAction;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.dnd.DropTargetEvent;

public class VFSUncheckoutCommand
extends VFSDNDCommand {
    public VFSUncheckoutCommand() {
        super(null);
    }

    protected void performAction(Object[] elements, Object destination) {
        String items = DNDUtility.getAsText(Arrays.asList(this.getValidElements(destination)));
        DetailMessageDialog dialog = new DetailMessageDialog(this.getShell(), "Confirm REVERT operation", null, "You are going to REVERT selected items.\n\nDo you want to continue?", items, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.SHOW_DETAILS_LABEL}, 0);
        dialog.setDetailButton(2);
        if (dialog.open() == 0) {
            IVfsActionManager manager = VfsActionManager.getInstance();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IVfsActivity) {
                    manager.doSynchronously((IVfsAction)new UncheckoutAction((IVfsActivity)elements[i]));
                } else if (elements[i] instanceof IVfsActivityRecordedFolderItem) {
                    Object[] parentItem;
                    IVfsActivityRecordedFolderItem recordedItem = (IVfsActivityRecordedFolderItem)elements[i];
                    IVfsActivity activity = null;
                    if (recordedItem.getOpenActivities().length > 1 && (parentItem = DNDUtility.getParentObjectForTreeSelection(VfsResourceTransfer.getInstance().getSourceViewID(), recordedItem, 1)).length == 1 && parentItem[0] instanceof IVfsActivity) {
                        activity = (IVfsActivity)parentItem[0];
                    }
                    if (activity == null) {
                        manager.doSynchronously((IVfsAction)new UncheckoutAction(recordedItem));
                    } else {
                        manager.doSynchronously((IVfsAction)new UncheckoutAction(recordedItem, activity));
                    }
                }
                ++i;
            }
        }
    }

    protected boolean checkSourceElements(Object[] elements, Object destination) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IVfsActivity) {
                IVfsActivity activity = (IVfsActivity)elements[i];
                if (DNDUtility.hasAvailableAction(activity, VfsActionOnActivity.UNCHECKOUT)) {
                    return true;
                }
            } else if (elements[i] instanceof IVfsActivityRecordedFolderItem) {
                IVfsActivityRecordedFolderItem item = (IVfsActivityRecordedFolderItem)elements[i];
                Object[] parentItem = DNDUtility.getParentObjectForTreeSelection(VfsResourceTransfer.getInstance().getSourceViewID(), item, 1);
                if (DNDUtility.hasAvailableAction((IVfsFolderItem)item, VfsActionOnFolderItem.UNCHECKOUT) && parentItem.length == 1) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected String getErrorMessage() {
        return "Following elements couldn't be reverted:";
    }

    public void setDNDResponse(DropTargetEvent event) {
        event.detail = 2;
    }
}

