/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands;

import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.DNDUtility;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.VfsResourceTransfer;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.DNDCommand;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public abstract class VFSDNDCommand
extends DNDCommand {
    protected VFSDNDCommand(Class destClass) {
        super(destClass, (Transfer)VfsResourceTransfer.getInstance());
    }

    protected void execute(Object destination, String destinationViewType, DropTargetEvent event) {
        Object[] valid = this.getValidElements(destination);
        Object[] invalid = this.getInvalidElements(destination);
        if (invalid.length > 0) {
            String invalidList = DNDUtility.getAsText(Arrays.asList(invalid));
            this.showErrorMessage(this.getErrorMessage(), invalidList);
        }
        if (valid.length > 0) {
            this.performAction(valid, destination);
        }
    }

    protected Object[] getSourceElemets() {
        ISelection selection = VfsResourceTransfer.getInstance().getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toArray();
        }
        return new Object[0];
    }

    protected abstract void performAction(Object[] var1, Object var2);

    protected void performAction(Object destination) {
        this.performAction(this.getSourceElemets(), destination);
    }

    protected abstract boolean checkSourceElements(Object[] var1, Object var2);

    protected abstract String getErrorMessage();

    protected boolean checkSourceElements(Object destination) {
        return this.checkSourceElements(this.getSourceElemets(), destination);
    }

    private Object[] getElements(Object[] elements, Object destination, boolean valid) {
        ArrayList<Object> outElements = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            if (this.checkSourceElements(new Object[]{elements[i]}, destination) == valid) {
                outElements.add(elements[i]);
            }
            ++i;
        }
        return outElements.toArray();
    }

    protected Object[] getValidElements(Object[] elements, Object destination) {
        return this.getElements(elements, destination, true);
    }

    protected Object[] getValidElements(Object destination) {
        return this.getValidElements(this.getSourceElemets(), destination);
    }

    protected Object[] getInvalidElements(Object[] elements, Object destination) {
        return this.getElements(elements, destination, false);
    }

    protected Object[] getInvalidElements(Object destination) {
        return this.getElements(this.getSourceElemets(), destination, false);
    }

    public boolean isValid(Object destination, String destinationViewType, DropTargetEvent event) {
        if (super.isValid(destination, destinationViewType, event)) {
            return this.checkSourceElements(destination);
        }
        return false;
    }
}

