/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.CopyResourceCommand;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.Messages;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class TextCopyToFolderCommand
extends CopyResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$TextCopyToFolderCommand == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$TextCopyToFolderCommand = TextCopyToFolderCommand.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.TextCopyToFolderCommand")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$TextCopyToFolderCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsFolder;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$TextCopyToFolderCommand;

    public TextCopyToFolderCommand() {
        super(class$com$tssap$dtr$client$lib$vfs$IVfsFolder == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsFolder = TextCopyToFolderCommand.class$("com.tssap.dtr.client.lib.vfs.IVfsFolder")) : class$com$tssap$dtr$client$lib$vfs$IVfsFolder, (Transfer)TextTransfer.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    protected void execute(Object destination, String destinationViewType, DropTargetEvent event) {
        if (event.data == null) {
            return;
        }
        InputStream input = null;
        File outputFile = null;
        IVfsFolderItem item = (IVfsFolderItem)destination;
        File parentFile = new File(item.getLocalPath());
        if (event.data instanceof String) {
            String data = (String)event.data;
            if (data.startsWith("\\\\")) {
                File file = new File(data);
                if (file.isFile() && file.exists()) {
                    try {
                        input = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                        this.showErrorMessage(Messages.getString("RepositoryDropAdapter.File_doesnt_exist_part1.message") + file.getAbsolutePath() + Messages.getString("RepositoryDropAdapter.File_doesnt_exist_part2.message"), null);
                        return;
                    }
                }
                outputFile = new File(parentFile, file.getName());
            } else {
                URL url = null;
                int newLinePos = data.indexOf("\n");
                if (newLinePos != -1) {
                    data = data.substring(0, newLinePos);
                }
                try {
                    url = new URL(data);
                    input = url.openStream();
                }
                catch (MalformedURLException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    this.showErrorMessage(Messages.getString("RepositoryDropAdapter.InvalidURL.message") + data, null);
                    return;
                }
                catch (IOException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    this.showErrorMessage(Messages.getString("RepositoryDropAdapter.IO_exception.message"), null);
                    return;
                }
                File wholeName = new File(url.getFile());
                outputFile = new File(parentFile, wholeName.getName());
            }
            if (input == null || outputFile == null) {
                return;
            }
            if (this.checkTargetFile(outputFile)) {
                try {
                    int bytesRead;
                    outputFile.createNewFile();
                    FileOutputStream output = new FileOutputStream(outputFile);
                    byte[] buffer = new byte[10240];
                    while ((bytesRead = input.read(buffer)) != -1) {
                        void wholeName;
                        ((OutputStream)output).write(buffer, 0, (int)wholeName);
                    }
                }
                catch (IOException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
                try {
                    item.asGenericFolder().refreshFolderItems();
                }
                catch (VfsException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

