/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.DNDUtility;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.AddEditUtility;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.DNDCommand;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceAddEditToWorkspaceCommand
extends DNDCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToWorkspaceCommand == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToWorkspaceCommand = ResourceAddEditToWorkspaceCommand.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.ResourceAddEditToWorkspaceCommand")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToWorkspaceCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToWorkspaceCommand;

    public ResourceAddEditToWorkspaceCommand() {
        super(class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace = ResourceAddEditToWorkspaceCommand.class$("com.tssap.dtr.client.lib.vfs.IVfsWorkspace")) : class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace, (Transfer)ResourceTransfer.getInstance());
    }

    protected void execute(Object destination, String destinationViewType, DropTargetEvent event) {
        if (event.data == null && !(event.data instanceof IResource[])) {
            return;
        }
        IResource[] sourceResources = (IResource[])event.data;
        IVfsWorkspace workspace = (IVfsWorkspace)destination;
        Object[] items = DNDUtility.convertResourcesToFolderItems(sourceResources);
        this.performAddEdit(items, workspace);
    }

    protected void performAddEdit(Object[] elements, IVfsWorkspace destination) {
        ArrayList<Object> valid = new ArrayList<Object>();
        ArrayList<Object> invalid = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            if (AddEditUtility.checkVfsResourceForAddEdit(elements[i], destination)) {
                valid.add(elements[i]);
            } else {
                invalid.add(elements[i]);
            }
            ++i;
        }
        if (invalid.size() > 0) {
            String invalidItems = DNDUtility.getAsText(invalid);
            this.showErrorMessage("Selected workspace could not be used for the resources for Add or Edit.", invalidItems);
        }
        if (valid.size() > 0) {
            IVfsActivity activity;
            Object[] validItems = Util.getArrayFromIterator(valid.iterator(), class$java$lang$Object == null ? (class$java$lang$Object = ResourceAddEditToWorkspaceCommand.class$("java.lang.Object")) : class$java$lang$Object);
            if (WorkspacesWithDefaultActivity.usingDefaultActivity(destination)) {
                try {
                    activity = destination.getDefaultActivity();
                }
                catch (VfsException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    return;
                }
            } else {
                SelectActivityDialog dialog = new SelectActivityDialog(this.getShell(), destination);
                if (dialog.open() == 1) {
                    return;
                }
                activity = dialog.getActivitySelection()[0];
            }
            AddEditUtility.handleAddEdit(validItems, activity);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

