/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.DNDUtility;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.AddEditUtility;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.DNDCommand;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceAddEditToBlankCommand
extends DNDCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToBlankCommand == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToBlankCommand = ResourceAddEditToBlankCommand.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.ResourceAddEditToBlankCommand")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToBlankCommand));
    private HashMap fActivities = new HashMap();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToBlankCommand;

    public ResourceAddEditToBlankCommand() {
        super(null, (Transfer)ResourceTransfer.getInstance());
    }

    protected void execute(Object destination, String destinationViewType, DropTargetEvent event) {
        ArrayList<IVfsFolderItem> valid = new ArrayList<IVfsFolderItem>();
        ArrayList<Object> invalid = new ArrayList<Object>();
        IResource[] sourceResources = (IResource[])event.data;
        int i = 0;
        while (i < sourceResources.length) {
            IResource resource = sourceResources[i];
            DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider(resource);
            IVfsWorkspace workspace = null;
            IVfsFolderItem item = null;
            if (provider != null) {
                item = provider.getFolderItem(resource);
                workspace = AddEditUtility.getWorkspace(item);
            }
            if (AddEditUtility.checkVfsResourceForAddEdit(item, workspace)) {
                valid.add(item);
            } else if (item == null) {
                invalid.add(sourceResources[i]);
            } else {
                invalid.add(item);
            }
            ++i;
        }
        if (invalid.size() > 0) {
            String invalidMsg = DNDUtility.getAsText(invalid);
            this.showErrorMessage("Some item(s) couldn't be checkouted in a activity.", invalidMsg);
        }
        if (valid.size() > 0) {
            this.fActivities.clear();
            IVfsActivityRecordedFolderItem[] items = (IVfsActivityRecordedFolderItem[])Util.getArrayFromIterator(valid.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem = ResourceAddEditToBlankCommand.class$("com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem);
            int i2 = 0;
            while (i2 < items.length) {
                IVfsActivity activity = this.getActivity(items[i2]);
                AddEditUtility.handleAddEdit(new Object[]{items[i2]}, activity);
                ++i2;
            }
        }
    }

    private IVfsActivity getActivity(Object element) {
        IVfsActivity activity;
        IVfsWorkspace workspace = AddEditUtility.getWorkspace(element);
        if (workspace == null) {
            return null;
        }
        if (this.fActivities.get(workspace) != null) {
            return (IVfsActivity)this.fActivities.get(workspace);
        }
        if (WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
            try {
                activity = workspace.getDefaultActivity();
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                return null;
            }
        } else {
            SelectActivityDialog dialog = new SelectActivityDialog(this.getShell(), workspace);
            if (dialog.open() == 1) {
                return null;
            }
            activity = dialog.getActivitySelection()[0];
        }
        this.fActivities.put(workspace, activity);
        return activity;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

