/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.DNDUtility;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.AddEditUtility;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.DNDCommand;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.AddAction;
import com.tssap.dtr.client.lib.vfs.actions.EditAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceAddEditToActivityCommand
extends DNDCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToActivityCommand == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToActivityCommand = ResourceAddEditToActivityCommand.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.ResourceAddEditToActivityCommand")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToActivityCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsActivity;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$ResourceAddEditToActivityCommand;

    public ResourceAddEditToActivityCommand() {
        super(class$com$tssap$dtr$client$lib$vfs$IVfsActivity == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivity = ResourceAddEditToActivityCommand.class$("com.tssap.dtr.client.lib.vfs.IVfsActivity")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivity, (Transfer)ResourceTransfer.getInstance());
    }

    protected void execute(Object destination, String destinationViewType, DropTargetEvent event) {
        if (event.data == null && !(event.data instanceof IResource[])) {
            return;
        }
        IResource[] sourceResources = (IResource[])event.data;
        if (destination instanceof IVfsActivity) {
            IVfsActivityRecordedFolderItem[] items = DNDUtility.convertResourcesToFolderItems(sourceResources);
            ArrayList<IVfsActivityRecordedFolderItem> error = new ArrayList<IVfsActivityRecordedFolderItem>();
            ArrayList<IVfsActivityRecordedFolderItem> valid = new ArrayList<IVfsActivityRecordedFolderItem>();
            int i = 0;
            while (i < items.length) {
                if (!AddEditUtility.checkVfsResourcesForAddEdit(new IVfsActivityRecordedFolderItem[]{items[i]}, (IVfsActivity)destination)) {
                    error.add(items[i]);
                } else {
                    valid.add(items[i]);
                }
                ++i;
            }
            if (error.size() > 0) {
                String invalidItems = DNDUtility.getAsText(error);
                this.showErrorMessage("Selected activity could be used for the resources from different workspace(s):", invalidItems);
            }
            items = valid.toArray(new IVfsActivityRecordedFolderItem[valid.size()]);
            this.handleAddEdit(items, (IVfsActivity)destination);
        }
    }

    private void handleAddEdit(IVfsActivityRecordedFolderItem[] items, IVfsActivity activity) {
        int i = 0;
        while (i < items.length) {
            if (items[i].asFile() != null) {
                this.handleFile(items[i].asFile(), activity);
            } else if (items[i].asFolder() != null) {
                this.handleFolder(items[i].asFolder(), activity);
            }
            ++i;
        }
    }

    private void handleFile(IVfsFile file, IVfsActivity activity) {
        boolean hasEdit = DNDUtility.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.CHECKOUT_FOR_EDIT);
        boolean hasAdd = DNDUtility.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.CREATE_AND_CHECKOUT);
        if (hasEdit) {
            this.editItem((IVfsActivityRecordedFolderItem)file, activity);
        } else if (hasAdd) {
            this.addItem((IVfsActivityRecordedFolderItem)file, activity);
        }
    }

    private void handleFolder(IVfsFolder folder, IVfsActivity activity) {
        try {
            IVfsFolderItem[] items = folder.refreshFolderItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].asFile() != null) {
                    this.handleFile(items[i].asFile(), activity);
                } else if (items[i].asFolder() != null) {
                    this.handleFolder(items[i].asFolder(), activity);
                }
                ++i;
            }
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    private void addItem(IVfsActivityRecordedFolderItem item, IVfsActivity activity) {
        VfsActionManager.getInstance().doSynchronously((IVfsAction)new AddAction(new IVfsActivityRecordedFolderItem[]{item}, activity, Integer.MAX_VALUE));
    }

    private void editItem(IVfsActivityRecordedFolderItem item, IVfsActivity activity) {
        VfsActionManager.getInstance().doSynchronously((IVfsAction)new EditAction(new IVfsActivityRecordedFolderItem[]{item}, activity, Integer.MAX_VALUE));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

