/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.DNDUtility;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.CopyResourceCommand;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.Messages;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;

public class FileCopyResourceToWorkspaceCommand
extends CopyResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$FileCopyResourceToWorkspaceCommand == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$FileCopyResourceToWorkspaceCommand = FileCopyResourceToWorkspaceCommand.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.FileCopyResourceToWorkspaceCommand")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$FileCopyResourceToWorkspaceCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$FileCopyResourceToWorkspaceCommand;

    public FileCopyResourceToWorkspaceCommand() {
        super(class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace = FileCopyResourceToWorkspaceCommand.class$("com.tssap.dtr.client.lib.vfs.IVfsWorkspace")) : class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace, (Transfer)FileTransfer.getInstance());
    }

    protected void execute(Object destination, String destinationViewType, DropTargetEvent event) {
        if (event.data == null && !(event.data instanceof String[])) {
            return;
        }
        String[] sourceFiles = (String[])event.data;
        ArrayList<String> directories = new ArrayList<String>();
        if (destination instanceof IVfsWorkspace) {
            ArrayList<File> files = new ArrayList<File>();
            int i = 0;
            while (i < sourceFiles.length) {
                File source = new File(sourceFiles[i]);
                if (source.exists() && source.isFile()) {
                    files.add(source);
                } else {
                    directories.add(source.getAbsolutePath());
                }
                ++i;
            }
            if (files.size() > 0) {
                String fileList = DNDUtility.getAsText(files);
                String message = Messages.getString("RepositoryDropAdapter.Files_arent_allowed_in_workspace.message") + fileList;
                this.showErrorMessage(message, null);
            }
        }
        this.performCopy(destination, directories.toArray(new String[directories.size()]));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

