/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands;

import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.Messages;
import com.tssap.dtr.client.eclipse.ui.util.DetailMessageDialog;
import com.tssap.dtr.client.lib.vfs.actions.IVfsActionManager;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class DNDCommand
implements IExecutableExtension {
    private String fViewType;
    private Class fDestClass;
    private Transfer fTransfer;
    private Shell fShell;
    protected IVfsActionManager fActionManager = VfsActionManager.getInstance();
    protected IConfigurationElement fConfigurationElement;

    protected DNDCommand(Class destClass, Transfer transfer) {
        this.fDestClass = destClass;
        this.fTransfer = transfer;
    }

    public boolean equals(Object obj) {
        DNDCommand otherCmd;
        return this.fDestClass != null && obj.getClass().isInstance(this) && this.fDestClass.equals((otherCmd = (DNDCommand)obj).getDestinationClass()) && this.fViewType.equals(otherCmd.getViewType()) && this.fTransfer.equals(otherCmd.getTransfer());
    }

    public boolean isValid(Object destination, String destinationViewType, DropTargetEvent event) {
        if (!destinationViewType.equalsIgnoreCase(this.fViewType)) {
            return false;
        }
        if (this.fDestClass != null ? !this.fDestClass.isInstance(destination) : destination != null) {
            return false;
        }
        return this.fTransfer.isSupportedType(event.currentDataType);
    }

    protected abstract void execute(Object var1, String var2, DropTargetEvent var3);

    public final void run(final Object destination, final String destinationViewType, final DropTargetEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (DNDCommand.this.isValid(destination, destinationViewType, event)) {
                    DNDCommand.this.execute(destination, destinationViewType, event);
                }
            }
        });
    }

    public String getViewType() {
        return this.fViewType;
    }

    public Class getDestinationClass() {
        return this.fDestClass;
    }

    public Transfer getTransfer() {
        return this.fTransfer;
    }

    public void setDNDResponse(DropTargetEvent event) {
        event.detail = 1;
    }

    protected void showErrorMessage(String dialogMessage, String detailMessage) {
        DetailMessageDialog dialog;
        if (detailMessage == null) {
            dialog = new DetailMessageDialog(this.getShell(), Messages.getString("RepositoryDropAdapter.error.dialogTitle"), null, dialogMessage, "", 1, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.SHOW_DETAILS_LABEL}, 0);
        } else {
            dialog = new DetailMessageDialog(this.getShell(), Messages.getString("RepositoryDropAdapter.error.dialogTitle"), null, dialogMessage, detailMessage, 1, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.SHOW_DETAILS_LABEL}, 0);
            dialog.setDetailButton(1);
        }
        dialog.open();
    }

    protected Shell getShell() {
        if (this.fShell == null) {
            IWorkbenchWindow window = BluebirdPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return Display.getDefault().getShells()[0];
            }
            return window.getShell();
        }
        return this.fShell;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfigurationElement = config;
    }

    public void setShell(Shell shell) {
        this.fShell = shell;
    }

    public void setDestinationViewType(String viewType) {
        this.fViewType = viewType;
    }
}

