/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.DNDCommand;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.Messages;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public abstract class CopyResourceCommand
extends DNDCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$CopyResourceCommand == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$CopyResourceCommand = CopyResourceCommand.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.CopyResourceCommand")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$CopyResourceCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$CopyResourceCommand;

    protected CopyResourceCommand(Class destClass, Transfer transfer) {
        super(destClass, transfer);
    }

    public boolean isValid(Object destination, String destinationViewType, DropTargetEvent event) {
        IVfsFolderItem item;
        return super.isValid(destination, destinationViewType, event) && destination instanceof IVfsFolderItem && (item = (IVfsFolderItem)destination).getLocalPath() != null;
    }

    protected void performCopy(Object destination, String[] sourceFiles) {
        IVfsFolderItem item = (IVfsFolderItem)destination;
        File destFileLocation = new File(item.getLocalPath());
        int i = 0;
        while (i < sourceFiles.length) {
            block6: {
                File source = new File(sourceFiles[i]);
                if (source.exists()) {
                    try {
                        if (!this.checkTargetFile(new File(destFileLocation, source.getName()))) break block6;
                        this.copyTree(source, destFileLocation);
                    }
                    catch (IOException e) {
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                        break;
                    }
                }
            }
            ++i;
        }
        try {
            item.asGenericFolder().refreshFolderItems();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    protected void copyTree(File source, File destination) throws IOException {
        if (source.isFile()) {
            this.copyFile(source, destination);
        } else if (source.isDirectory()) {
            File[] childrens = source.listFiles();
            int i = 0;
            while (i < childrens.length) {
                this.copyTree(childrens[i], new File(destination, source.getName()));
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void copyFile(File source, File destination) throws IOException {
        FileOutputStream output;
        block7: {
            if (!destination.exists()) {
                destination.mkdirs();
            }
            File destFile = new File(destination, source.getName());
            destFile.createNewFile();
            FileInputStream input = null;
            output = null;
            try {
                int bytesRead;
                input = new FileInputStream(source);
                output = new FileOutputStream(destFile);
                byte[] buffer = new byte[4096];
                while ((bytesRead = input.read(buffer)) != -1) {
                    void var7_7;
                    output.write(buffer, 0, (int)var7_7);
                }
                Object var9_8 = null;
                if (input == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
                throw throwable;
            }
            input.close();
        }
        if (output != null) {
            output.close();
        }
    }

    protected boolean checkTargetFile(File file) {
        if (file.exists()) {
            MessageDialog dialog;
            String type = Messages.getString("RepositoryDropAdapter.File.label");
            if (file.isDirectory()) {
                type = Messages.getString("RepositoryDropAdapter.Folder.label");
            }
            if ((dialog = new MessageDialog(this.getShell(), MessageFormat.format(Messages.getString("RepositoryDropAdapter.ConfirmReplace.dialogTitle"), type), null, MessageFormat.format(Messages.getString("RepositoryDropAdapter.ConfirmReplace.message"), type.toLowerCase(), file.getName()), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0)).open() == 3) {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

