/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.DNDUtility;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.actions.AddAction;
import com.tssap.dtr.client.lib.vfs.actions.EditAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;

class AddEditUtility {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$AddEditUtility == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$AddEditUtility = AddEditUtility.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.AddEditUtility")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$AddEditUtility));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$commands$AddEditUtility;

    AddEditUtility() {
    }

    public static IVfsWorkspace getWorkspace(Object element) {
        IVfsWorkspace workspace = null;
        if (element instanceof IVfsActivityRecordedFolderItem) {
            IVfsActivityRecordedFolderItem item = (IVfsActivityRecordedFolderItem)element;
            workspace = item.getWorkspace();
        } else if (element instanceof IVfsIntegrateCollision) {
            IVfsIntegrateCollision collision = (IVfsIntegrateCollision)element;
            workspace = collision.getWorkspace();
        }
        return workspace;
    }

    private static boolean checkEditPrerequisites(IVfsActivityRecordedFolderItem item, IVfsActivity activity) {
        if (item.asFile() != null) {
            boolean hasEdit = DNDUtility.hasAvailableAction((IVfsFolderItem)item, VfsActionOnFolderItem.CHECKOUT_FOR_EDIT);
            return hasEdit;
        }
        if (item.asFolder() != null) {
            boolean hasFolderEdit = DNDUtility.hasAvailableAction((IVfsFolderItem)item, VfsActionOnFolderItem.CHECKOUT_FOR_EDIT);
            return hasFolderEdit;
        }
        return true;
    }

    private static boolean checkAddPrerequisites(IVfsActivityRecordedFolderItem item, IVfsActivity activity) {
        boolean hasFolderAdd;
        boolean hasAdd;
        if (item.asFile() != null ? !(hasAdd = DNDUtility.hasAvailableAction((IVfsFolderItem)item, VfsActionOnFolderItem.CREATE_AND_CHECKOUT)) : item.asFolder() != null && !(hasFolderAdd = DNDUtility.hasAvailableAction((IVfsFolderItem)item, VfsActionOnFolderItem.ADD_INF))) {
            return false;
        }
        try {
            IVfsActivity[] openActivities;
            IVfsGenericFolder parent = item.getParent();
            if (!(parent instanceof IVfsFolder)) {
                return false;
            }
            IVfsFolder parentFolder = (IVfsFolder)parent;
            VfsFolderItemActivityState actState = parentFolder.getActivityState();
            if (actState.equals(VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE)) {
                return false;
            }
            if (actState.equals(VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) && !(openActivities = parentFolder.getOpenActivities())[0].equals(activity)) {
                return false;
            }
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean checkVfsResourcesForAddEdit(Object[] items, IVfsActivity destination) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                IVfsIntegrateCollision collision;
                if (items[i] instanceof IVfsActivityRecordedFolderItem) {
                    IVfsActivityRecordedFolderItem recordedItem = (IVfsActivityRecordedFolderItem)items[i];
                    boolean canEdit = AddEditUtility.checkEditPrerequisites(recordedItem, destination);
                    boolean canAdd = AddEditUtility.checkAddPrerequisites(recordedItem, destination);
                    if (canAdd || canEdit) {
                        return true;
                    }
                } else if (items[i] instanceof IVfsIntegrateCollision && (collision = (IVfsIntegrateCollision)items[i]).getMergeVersion() == null && collision.getWorkspace().equals(destination.getWorkspace())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean checkVfsResourceForAddEdit(Object element, IVfsWorkspace destination) {
        IVfsIntegrateCollision collision;
        if (destination == null || element == null) {
            return false;
        }
        if (element instanceof IVfsActivityRecordedFolderItem) {
            IVfsActivityRecordedFolderItem item = (IVfsActivityRecordedFolderItem)element;
            if (item != null) {
                if (item == null) {
                    return false;
                }
                if (!destination.equals(item.getWorkspace())) {
                    return false;
                }
                boolean canEdit = false;
                boolean canAdd = false;
                if (item.asFile() != null) {
                    canEdit = DNDUtility.hasAvailableAction((IVfsFolderItem)item, VfsActionOnFolderItem.CHECKOUT_FOR_EDIT);
                    canAdd = DNDUtility.hasAvailableAction((IVfsFolderItem)item, VfsActionOnFolderItem.CREATE_AND_CHECKOUT);
                } else if (item.asFolder() != null && item.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                    canEdit = DNDUtility.hasAvailableAction((IVfsFolderItem)item, VfsActionOnFolderItem.CHECKOUT_FOR_EDIT_1);
                    canAdd = DNDUtility.hasAvailableAction((IVfsFolderItem)item, VfsActionOnFolderItem.ADD_INF);
                }
                return canAdd || canEdit;
            }
        } else if (element instanceof IVfsIntegrateCollision && (collision = (IVfsIntegrateCollision)element).getMergeVersion() == null) {
            return collision.getWorkspace().equals(destination);
        }
        return false;
    }

    public static void handleAddEdit(Object[] elements, IVfsActivity activity) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IVfsIntegrateCollision) {
                IVfsIntegrateCollision collision = (IVfsIntegrateCollision)elements[i];
                try {
                    collision.createMergeVersion(activity, collision.getWorkspace());
                }
                catch (VfsException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    Logbook.getErrorChapter().print("Create merge version for Intergate Conflict failed.");
                }
            } else if (elements[i] instanceof IVfsActivityRecordedFolderItem) {
                IVfsActivityRecordedFolderItem item = (IVfsActivityRecordedFolderItem)elements[i];
                if (item.asFile() != null) {
                    AddEditUtility.handleFile(item.asFile(), activity);
                } else if (item.asFolder() != null) {
                    AddEditUtility.handleFolder(item.asFolder(), activity);
                }
            }
            ++i;
        }
    }

    private static void handleFile(IVfsFile file, IVfsActivity activity) {
        boolean hasEdit = DNDUtility.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.CHECKOUT_FOR_EDIT);
        boolean hasAdd = DNDUtility.hasAvailableAction((IVfsFolderItem)file, VfsActionOnFolderItem.CREATE_AND_CHECKOUT);
        if (hasEdit) {
            AddEditUtility.editItem((IVfsActivityRecordedFolderItem)file, activity);
        } else if (hasAdd) {
            AddEditUtility.addItem((IVfsActivityRecordedFolderItem)file, activity);
        }
    }

    private static void handleFolder(IVfsFolder folder, IVfsActivity activity) {
        try {
            IVfsFolderItem[] items = folder.refreshFolderItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].asFile() != null) {
                    AddEditUtility.handleFile(items[i].asFile(), activity);
                } else if (items[i].asFolder() != null) {
                    AddEditUtility.handleFolder(items[i].asFolder(), activity);
                }
                ++i;
            }
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    private static void addItem(IVfsActivityRecordedFolderItem item, IVfsActivity activity) {
        VfsActionManager.getInstance().doSynchronously((IVfsAction)new AddAction(new IVfsActivityRecordedFolderItem[]{item}, activity, Integer.MAX_VALUE));
    }

    private static void editItem(IVfsActivityRecordedFolderItem item, IVfsActivity activity) {
        VfsActionManager.getInstance().doSynchronously((IVfsAction)new EditAction(new IVfsActivityRecordedFolderItem[]{item}, activity, Integer.MAX_VALUE));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

