/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd;

import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.DNDUtility;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class VfsResourceTransfer
extends ByteArrayTransfer {
    private static final VfsResourceTransfer instance = new VfsResourceTransfer();
    private static final String TYPE_NAME = "vfs-resource-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = Transfer.registerType((String)TYPE_NAME);
    private ISelection fSelection;
    private String fSourceViewID;
    private Hashtable fParentObjectsTable = new Hashtable();

    private VfsResourceTransfer() {
    }

    public static VfsResourceTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof IVfsFolderItem[])) {
            return;
        }
        IVfsFolderItem[] resources = (IVfsFolderItem[])data;
        int resourceCount = resources.length;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(resourceCount);
            int i = 0;
            while (i < resources.length) {
                this.writeResource(dataOut, resources[i]);
                ++i;
            }
            dataOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int count = in.readInt();
            IVfsFolderItem[] results = new IVfsFolderItem[count];
            int i = 0;
            while (i < count) {
                results[i] = this.readResource(in);
                ++i;
            }
            return results;
        }
        catch (IOException e) {
            return null;
        }
        catch (VfsException e) {
            return null;
        }
    }

    private IVfsFolderItem readResource(DataInputStream dataIn) throws IOException, VfsException {
        String path = dataIn.readUTF();
        Iterator clients = Configuration.getConfiguration().clients();
        while (clients.hasNext()) {
            IClient client = (IClient)clients.next();
            IMountPoint mountPoint = client.getMountPointForLocalPath(path);
            if (mountPoint == null) continue;
            IVfsContext context = client.getContext();
            IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)context);
            return manager.getFolderItem(path);
        }
        return null;
    }

    private void writeResource(DataOutputStream dataOut, IVfsFolderItem item) throws IOException {
        dataOut.writeUTF(item.getLocalPath());
    }

    public void setSelection(ISelection selection) {
        this.fSelection = selection;
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public String getSourceViewID() {
        return this.fSourceViewID;
    }

    public void setSourceViewID(String partID) {
        this.fSourceViewID = partID;
        this.queryParentObjects();
    }

    private void queryParentObjects() {
        this.fParentObjectsTable.clear();
        if (!this.fSelection.isEmpty() && this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.fSelection;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object selectedElement = iter.next();
                Object[] parent = DNDUtility.getParentObjectForTreeSelection(this.fSourceViewID, selectedElement, 1);
                if (parent.length != 1) continue;
                this.fParentObjectsTable.put(selectedElement, parent[0]);
            }
        }
    }

    public Object getParentObject(Object selected) {
        return this.fParentObjectsTable.get(selected);
    }
}

