/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd;

import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.VfsResourceTransfer;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;

public class RepositoryDragAdapter
extends DragSourceAdapter {
    private String fViewType;
    private String fViewID;
    private TreeViewer fSource;

    public RepositoryDragAdapter(String viewType, TreeViewer source, String viewID) {
        this.fViewType = viewType;
        this.fSource = source;
        this.fViewID = viewID;
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = true;
        VfsResourceTransfer.getInstance().setSelection(this.fSource.getSelection());
        VfsResourceTransfer.getInstance().setSourceViewID(this.fViewID);
    }

    public void dragSetData(DragSourceEvent event) {
        if (VfsResourceTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = VfsResourceTransfer.getInstance().getSelection();
        } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
            this.setFileTransferData(event);
        }
    }

    private void setFileTransferData(DragSourceEvent event) {
        ISelection selection = this.fSource.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            ArrayList<String> out = new ArrayList<String>();
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                IVfsFolderItem item;
                Object element = iter.next();
                if (!(element instanceof IVfsFolderItem) || (item = (IVfsFolderItem)element).getLocalPath() == null) continue;
                String localPath = item.getLocalPath();
                if (localPath.endsWith(File.separator)) {
                    out.add(localPath.substring(0, localPath.length() - 1));
                    continue;
                }
                out.add(localPath);
            }
            event.data = out.size() == 0 ? null : out.toArray(new String[out.size()]);
        }
    }
}

