/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsActionOnActivity;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DNDUtility {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$DNDUtility == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$DNDUtility = DNDUtility.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.DNDUtility")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$DNDUtility));
    private static final IVfsActivityRecordedFolderItem[] EMPTY_VFS_ARRAY = new IVfsActivityRecordedFolderItem[0];
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$dnd$DNDUtility;

    public static boolean hasAvailableAction(IVfsFolderItem item, VfsActionOnFolderItem action) {
        VfsActionOnFolderItem[] availableActions = item.getActionsForCurrentState();
        int i = 0;
        while (i < availableActions.length) {
            if (availableActions[i] == action) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasAvailableAction(IVfsActivity activity, VfsActionOnActivity action) {
        try {
            VfsActionOnActivity[] availableActions = activity.getActionsForCurrentState();
            int i = 0;
            while (i < availableActions.length) {
                if (availableActions[i] == action) {
                    return true;
                }
                ++i;
            }
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        return false;
    }

    public static String getAsText(List list) {
        StringBuffer message = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String msg;
            String type;
            Object element = iter.next();
            if (element instanceof ClosedActivityWrapper) {
                element = ((ClosedActivityWrapper)element).activity;
            }
            if (element instanceof File) {
                type = null;
                msg = ((File)element).getAbsolutePath();
            } else if (element instanceof IResource) {
                type = null;
                msg = ((IResource)element).getLocation().toOSString();
            } else if (element instanceof IVfsActivity) {
                type = "Activity";
                try {
                    msg = ((IVfsActivity)element).getDisplayName();
                }
                catch (VfsException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    msg = "couldn't retrieve activity display name";
                }
            } else if (element instanceof IVfsWorkspace) {
                type = "Workspace";
                try {
                    msg = ((IVfsWorkspace)element).getBrowsePath();
                }
                catch (VfsException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    msg = "couldn't retrieve workspace display name";
                }
            } else if (element instanceof IVfsFolderItem) {
                type = null;
                msg = ((IVfsFolderItem)element).getLocalPath();
            } else {
                type = null;
                msg = element.toString();
            }
            if (type == null || type.equals("")) {
                message.append("\n\"" + msg + "\"");
                continue;
            }
            message.append("\n" + type + " - \"" + msg + "\"");
        }
        return message.toString();
    }

    public static Object[] convertSelction(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            return Util.getArrayFromIterator(sel.iterator(), class$java$lang$Object == null ? (class$java$lang$Object = DNDUtility.class$("java.lang.Object")) : class$java$lang$Object);
        }
        return new IVfsActivityRecordedFolderItem[0];
    }

    public static IVfsActivityRecordedFolderItem[] convertResourcesToFolderItems(IResource[] resources) {
        ArrayList<IVfsActivityRecordedFolderItem> out = new ArrayList<IVfsActivityRecordedFolderItem>();
        int i = 0;
        while (i < resources.length) {
            IVfsActivityRecordedFolderItem item;
            DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider(resources[i]);
            if (provider != null && (item = (IVfsActivityRecordedFolderItem)provider.getFolderItem(resources[i])) != null) {
                out.add(item);
            }
            ++i;
        }
        return out.toArray(new IVfsActivityRecordedFolderItem[out.size()]);
    }

    public static IVfsActivityRecordedFolderItem convertToFolderItem(String file) {
        IClient client = Configuration.getConfiguration().getActiveClient();
        if (client != null) {
            IVfsContext context = client.getContext();
            try {
                IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)context);
                IVfsFolderItem item = manager.getFolderItem(file);
                if (item == null && !(item instanceof IVfsActivityRecordedFolderItem)) {
                    return null;
                }
                IVfsActivityRecordedFolderItem recordedItem = (IVfsActivityRecordedFolderItem)item;
                return recordedItem;
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static IVfsActivityRecordedFolderItem[] convertToFolderItems(String[] files) {
        ArrayList<IVfsActivityRecordedFolderItem> out = new ArrayList<IVfsActivityRecordedFolderItem>();
        int i = 0;
        while (i < files.length) {
            IVfsActivityRecordedFolderItem item = DNDUtility.convertToFolderItem(files[i]);
            if (item != null) {
                out.add(item);
            }
            ++i;
        }
        if (out.size() > 0) {
            return out.toArray(new IVfsActivityRecordedFolderItem[out.size()]);
        }
        return EMPTY_VFS_ARRAY;
    }

    public static Object[] getParentObjectForTreeSelection(String viewID, Object selectedObject, int aboveLevel) {
        IViewPart view = DNDUtility.getView(viewID);
        HashSet<Object> parents = new HashSet<Object>();
        if (view != null && view instanceof RepositoryView) {
            if (aboveLevel < 1) {
                return new Object[]{selectedObject};
            }
            HashSet<TreeItem> correspondingTreeItems = new HashSet<TreeItem>();
            TreeItem[] selectedTreeItems = ((RepositoryView)view).getRepositoryTreeViewer().getTreeViewer().getTree().getSelection();
            int i = 0;
            while (i < selectedTreeItems.length) {
                if (selectedTreeItems[i].getData().equals(selectedObject)) {
                    correspondingTreeItems.add(selectedTreeItems[i]);
                }
                ++i;
            }
            Iterator iter = correspondingTreeItems.iterator();
            while (iter.hasNext()) {
                TreeItem parentTreeItem = (TreeItem)iter.next();
                int i2 = 0;
                while (i2 < aboveLevel) {
                    if ((parentTreeItem = parentTreeItem.getParentItem()) == null) break;
                    ++i2;
                }
                if (parentTreeItem == null) continue;
                parents.add(parentTreeItem.getData());
            }
        }
        return parents.toArray();
    }

    private static IViewPart getView(String viewID) {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            return page.findView(viewID);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

