/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.EmptyTreeContentProvider;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsCollisionQuery;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsRootFolder;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsCollisionState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.impl.VfsCollisionQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class VfsWorkspaceWithCollisionProvider
extends EmptyTreeContentProvider
implements IExecutableExtension {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsWorkspaceWithCollisionProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsWorkspaceWithCollisionProvider = VfsWorkspaceWithCollisionProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.VfsWorkspaceWithCollisionProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsWorkspaceWithCollisionProvider));
    private static final String OPEN_COLLISIONS_ATTRIBUTE = "provideWSWOpenCollisions";
    private static final String CLOSED_COLLISIONS_ATTRIBUTE = "provideWSWClosedCollisions";
    private IVfsCollisionQuery m_collisionQuery = null;
    private String m_viewId = null;
    private boolean m_withUserFilter;
    private boolean m_withWsFilter;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsWorkspaceWithCollisionProvider;

    public Object getParent(Object element) {
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if (data instanceof IConfigurationElement) {
            this.m_viewId = ((IConfigurationElement)data).getAttribute("id");
            this.m_withUserFilter = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(((IConfigurationElement)data).getAttribute("showSwitchUserMenu")));
            this.m_withWsFilter = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(((IConfigurationElement)data).getAttribute("showWorkspaceFilterMenu")));
        }
    }

    protected boolean isChildrenApplicable(Object element) {
        return element instanceof IVfsRootFolder;
    }

    protected Object[] getMyChildren(Object element) {
        String user = "MY";
        if (this.m_withUserFilter && this.m_viewId != null) {
            user = this.getPreferenceStore().getString(this.m_viewId + "_viewForUser");
        }
        if (user.equals("*")) {
            user = "ALL";
        }
        List wsToShow = new ArrayList();
        if (this.m_withWsFilter && this.m_viewId != null && this.getCurrentVfsManager() != null) {
            wsToShow = Util.restoreWorkspaceFilter(this.getCurrentVfsManager(), this.m_viewId + "_selectedWorkspaces-" + this.getCurrentVfsManager().getClientName());
        }
        IVfsWorkspace[] selectedWorkspaces = wsToShow.toArray(new IVfsWorkspace[wsToShow.size()]);
        IVfsRootFolder rootFolder = (IVfsRootFolder)element;
        IVfsRepository[] repositories = rootFolder.getRepositories();
        HashSet<IVfsWorkspace> workspaces = new HashSet<IVfsWorkspace>();
        int i = 0;
        while (i < repositories.length) {
            try {
                IVfsRepository repository = repositories[i];
                if (this.m_collisionQuery == null) {
                    this.m_collisionQuery = new VfsCollisionQuery();
                }
                this.m_collisionQuery.setOwner(user);
                this.m_collisionQuery.setCollisionState(VfsCollisionState.OPEN);
                int j = 0;
                while (j < selectedWorkspaces.length) {
                    if (j == 0) {
                        this.m_collisionQuery.setWorkspace(selectedWorkspaces[j].getAbsoluteRemotePath());
                    } else {
                        this.m_collisionQuery.addWorkspaceQuery(selectedWorkspaces[j].getAbsoluteRemotePath());
                    }
                    ++j;
                }
                repository.refreshIntegrateCollisions(this.m_collisionQuery);
            }
            catch (VfsException vfsException) {
                Logbook.getErrorChapter().println(vfsException.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)vfsException);
                return EmptyTreeContentProvider.getEmptyChildren();
            }
            workspaces.addAll(Arrays.asList(repositories[i].getWorkspacesContainingCollisions()));
            ++i;
        }
        return this.sortElementsByPath(workspaces.toArray(), true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

