/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.EmptyTreeContentProvider;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsRootFolder;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class VfsWorkspaceWithActivityProvider
extends EmptyTreeContentProvider
implements IExecutableExtension {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsWorkspaceWithActivityProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsWorkspaceWithActivityProvider = VfsWorkspaceWithActivityProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.VfsWorkspaceWithActivityProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsWorkspaceWithActivityProvider));
    private static final String OPEN_ACTIVITIES_ATTRIBUTE = "provideWSWOpenActivities";
    private static final String CLOSED_ACTIVITIES_ATTRIBUTE = "provideWSWClosedActivities";
    private boolean isWSWithOpenActivitiesProvided = false;
    private boolean isWSWithClosedActivitiesProvided = false;
    private String m_viewId = null;
    private boolean m_withUserFilter;
    private boolean m_withDateFilter;
    private boolean m_withWsFilter;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsWorkspaceWithActivityProvider;

    public Object getParent(Object element) {
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.isWSWithOpenActivitiesProvided = Boolean.TRUE.toString().equals(config.getAttribute(OPEN_ACTIVITIES_ATTRIBUTE));
        this.isWSWithClosedActivitiesProvided = Boolean.TRUE.toString().equals(config.getAttribute(CLOSED_ACTIVITIES_ATTRIBUTE));
        if (data instanceof IConfigurationElement) {
            this.m_viewId = ((IConfigurationElement)data).getAttribute("id");
            this.m_withUserFilter = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(((IConfigurationElement)data).getAttribute("showSwitchUserMenu")));
            this.m_withDateFilter = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(((IConfigurationElement)data).getAttribute("showSetDateRangeMenu")));
            this.m_withWsFilter = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(((IConfigurationElement)data).getAttribute("showWorkspaceFilterMenu")));
        }
    }

    protected boolean isChildrenApplicable(Object element) {
        return element instanceof IVfsRootFolder;
    }

    protected Object[] getMyChildren(Object element) {
        String dateRange;
        String user = "";
        if (this.m_withUserFilter && this.m_viewId != null) {
            user = this.getPreferenceStore().getString(this.m_viewId + "_viewForUser");
        }
        Date fromDate = null;
        if (this.m_withDateFilter && this.m_viewId != null && (dateRange = this.getPreferenceStore().getString(this.m_viewId + "_dateRange")).equals("")) {
            fromDate = this.getFromDate(14);
        }
        List wsToShow = new ArrayList();
        if (this.m_withWsFilter && this.m_viewId != null && this.getCurrentVfsManager() != null) {
            wsToShow = Util.restoreWorkspaceFilter(this.getCurrentVfsManager(), this.m_viewId + "_selectedWorkspaces-" + this.getCurrentVfsManager().getClientName());
        }
        IVfsRootFolder rootFolder = (IVfsRootFolder)element;
        IVfsRepository[] repositories = rootFolder.getRepositories();
        HashSet<IVfsWorkspace> workspaces = new HashSet<IVfsWorkspace>();
        int i = 0;
        while (i < repositories.length) {
            if (this.isWSWithClosedActivitiesProvided) {
                try {
                    if (user.equals("")) {
                        workspaces.addAll(Arrays.asList(repositories[i].getWorkspacesContainingClosedActivitiesBy(fromDate, null)));
                    } else if (user.equals("*")) {
                        workspaces.addAll(Arrays.asList(repositories[i].getWorkspacesContainingClosedActivitiesBy(null, fromDate, null)));
                    } else {
                        workspaces.addAll(Arrays.asList(repositories[i].getWorkspacesContainingClosedActivitiesBy(user, fromDate, null)));
                    }
                }
                catch (VfsException x) {
                    Logbook.getErrorChapter().println(x.getMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
            }
            if (this.isWSWithOpenActivitiesProvided) {
                workspaces.addAll(Arrays.asList(repositories[i].getWorkspacesContainingActivities(VfsActivityState.OPEN)));
            }
            ++i;
        }
        if (wsToShow.size() > 0) {
            HashSet workspacesToShow = new HashSet();
            Iterator iter = workspaces.iterator();
            while (iter.hasNext()) {
                Object ws = iter.next();
                if (!wsToShow.contains(ws)) continue;
                workspacesToShow.add(ws);
            }
            return this.sortElementsByPath(workspacesToShow.toArray(), true);
        }
        return this.sortElementsByPath(workspaces.toArray(), true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

