/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.EmptyTreeContentProvider;
import com.tssap.dtr.client.eclipse.ui.util.RefreshLogic;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsUtil;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class VfsFolderItemProvider
extends EmptyTreeContentProvider
implements IExecutableExtension {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsFolderItemProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsFolderItemProvider = VfsFolderItemProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.VfsFolderItemProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsFolderItemProvider));
    private static final String ATTRIBUTE_ONLY_MOUNTED = "provideOnlyMountedItem";
    private static final String ATTRIBUTE_ONLY_FOLDER = "provideOnlyGenericFolder";
    private boolean onlyMountedItemProvided;
    private boolean onlyGenericFolderProvided;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$VfsFolderItemProvider;

    public Object getParent(Object element) {
        if (element instanceof IVfsFolderItem) {
            IVfsFolderItem folderItem = (IVfsFolderItem)element;
            try {
                return folderItem.getParent();
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }
        return null;
    }

    protected boolean isChildrenApplicable(Object element) {
        return element instanceof IVfsGenericFolder;
    }

    protected Object[] getMyChildren(Object element) {
        IVfsGenericFolder genericFolder = (IVfsGenericFolder)element;
        try {
            Object[] folderItems = genericFolder.getFolderItems();
            if (RefreshLogic.doRefresh() || folderItems.length == 0) {
                genericFolder.refreshFolderItems();
                folderItems = genericFolder.getFolderItems();
            }
            folderItems = this.getFilteredFolderItems((IVfsFolderItem[])folderItems);
            return VfsUtil.sortItems((Object[])folderItems);
        }
        catch (VfsException e) {
            Logbook.getErrorChapter().println(e.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return EmptyTreeContentProvider.getEmptyChildren();
        }
    }

    private IVfsFolderItem[] getFilteredFolderItems(IVfsFolderItem[] folderItems) {
        if (folderItems == null) {
            return null;
        }
        if (this.onlyMountedItemProvided || this.onlyGenericFolderProvided) {
            ArrayList<IVfsFolderItem> filteredItems = new ArrayList<IVfsFolderItem>();
            int i = 0;
            while (i < folderItems.length) {
                IVfsContext.MountpointRelation relation;
                IVfsFolderItem item = folderItems[i];
                if (this.onlyGenericFolderProvided) {
                    item = folderItems[i].asGenericFolder();
                }
                if (item != null && this.onlyMountedItemProvided && item.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED && (relation = item.getContext().getMountpointRelation(item.getAbsoluteRemotePath())) != IVfsContext.MountpointRelation.ABOVE_MOUNTPOINT) {
                    item = null;
                }
                if (item != null) {
                    filteredItems.add(item);
                }
                ++i;
            }
            return filteredItems.toArray(new IVfsFolderItem[filteredItems.size()]);
        }
        return folderItems;
    }

    public void setInitializationData(IConfigurationElement configuration, String propertyName, Object data) throws CoreException {
        this.onlyMountedItemProvided = Boolean.TRUE.toString().equals(configuration.getAttribute(ATTRIBUTE_ONLY_MOUNTED));
        this.onlyGenericFolderProvided = Boolean.TRUE.toString().equals(configuration.getAttribute(ATTRIBUTE_ONLY_FOLDER));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

