/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.EmptyTreeContentProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class OpenActivityProvider
extends EmptyTreeContentProvider
implements IExecutableExtension {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$OpenActivityProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$OpenActivityProvider = OpenActivityProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.OpenActivityProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$OpenActivityProvider));
    private static final String EMPTY_ACTIVITIES_ATTRIBUTE = "provideEmptyActivities";
    private static final IVfsActivity[] EMPTY_ACTIVITIES_ARRAY = new IVfsActivity[0];
    private boolean isEmptyActivitiesProvided = false;
    private String m_viewId = null;
    private boolean m_withSortPossiblity;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$OpenActivityProvider;

    protected Object[] getMyChildren(Object element) {
        IVfsWorkspace workspace = (IVfsWorkspace)element;
        try {
            IVfsActivity[] openActivities = workspace.getActivities(VfsActivityState.OPEN);
            IVfsActivity[] emptyActivities = this.isEmptyActivitiesProvided ? workspace.getEmptyActivities() : EMPTY_ACTIVITIES_ARRAY;
            Object[] result = new IVfsActivity[openActivities.length + emptyActivities.length];
            System.arraycopy(openActivities, 0, result, 0, openActivities.length);
            System.arraycopy(emptyActivities, 0, result, openActivities.length, emptyActivities.length);
            boolean sortByName = false;
            boolean sortAscending = false;
            if (this.m_withSortPossiblity && this.m_viewId != null) {
                sortByName = this.getPreferenceStore().getBoolean(this.m_viewId + "_sortActivityByName");
                sortAscending = this.getPreferenceStore().getBoolean(this.m_viewId + "_sortActivityAscending");
            }
            return sortByName ? this.sortElementsByName(result, sortAscending) : this.sortElementsByDate(result, sortAscending);
        }
        catch (VfsException x) {
            Logbook.getErrorChapter().println(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            return EmptyTreeContentProvider.getEmptyChildren();
        }
    }

    public Object getParent(Object element) {
        IVfsActivity activity;
        if (element instanceof IVfsActivity && !(activity = (IVfsActivity)element).isInvalid()) {
            return activity.getWorkspace();
        }
        return null;
    }

    protected boolean isChildrenApplicable(Object element) {
        return element instanceof IVfsWorkspace;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.isEmptyActivitiesProvided = Boolean.TRUE.toString().equals(config.getAttribute(EMPTY_ACTIVITIES_ATTRIBUTE));
        if (data instanceof IConfigurationElement) {
            this.m_viewId = ((IConfigurationElement)data).getAttribute("id");
            this.m_withSortPossiblity = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(((IConfigurationElement)data).getAttribute("showSortMenu")));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

