/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.EmptyTreeContentProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class ConfigurableActivityProvider
extends EmptyTreeContentProvider
implements IExecutableExtension {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$ConfigurableActivityProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$ConfigurableActivityProvider = ConfigurableActivityProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.ConfigurableActivityProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$ConfigurableActivityProvider));
    private static final String OPEN_ACTIVITIES_ATTRIBUTE = "provideOpenActivities";
    private static final String CLOSED_ACTIVITIES_ATTRIBUTE = "provideClosedActivities";
    private static final String EMPTY_ACTIVITIES_ATTRIBUTE = "provideEmptyActivities";
    private static final IVfsActivity[] EMPTY_ACTIVITIES_ARRAY = new IVfsActivity[0];
    private boolean isOpenActivitiesProvided = false;
    private boolean isClosedActivitiesProvided = false;
    private boolean isEmptyActivitiesProvided = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$contentProviders$ConfigurableActivityProvider;

    public Object getParent(Object element) {
        IVfsActivity activity;
        if (element instanceof IVfsActivity && !(activity = (IVfsActivity)element).isInvalid()) {
            return activity.getWorkspace();
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement configuration, String propertyName, Object data) {
        this.isOpenActivitiesProvided = Boolean.TRUE.toString().equals(configuration.getAttribute(OPEN_ACTIVITIES_ATTRIBUTE));
        this.isClosedActivitiesProvided = Boolean.TRUE.toString().equals(configuration.getAttribute(CLOSED_ACTIVITIES_ATTRIBUTE));
        this.isEmptyActivitiesProvided = Boolean.TRUE.toString().equals(configuration.getAttribute(EMPTY_ACTIVITIES_ATTRIBUTE));
    }

    protected boolean isChildrenApplicable(Object element) {
        return element instanceof IVfsWorkspace;
    }

    protected Object[] getMyChildren(Object element) {
        IVfsWorkspace workspace = (IVfsWorkspace)element;
        try {
            IVfsActivity[] openActivities = this.isOpenActivitiesProvided ? workspace.getActivities(VfsActivityState.OPEN) : EMPTY_ACTIVITIES_ARRAY;
            IVfsActivity[] closedActivities = this.isClosedActivitiesProvided ? workspace.getActivities(VfsActivityState.CLOSED) : EMPTY_ACTIVITIES_ARRAY;
            IVfsActivity[] emptyActivities = this.isEmptyActivitiesProvided ? workspace.getEmptyActivities() : EMPTY_ACTIVITIES_ARRAY;
            Object[] result = new IVfsActivity[openActivities.length + closedActivities.length + emptyActivities.length];
            System.arraycopy(openActivities, 0, result, 0, openActivities.length);
            System.arraycopy(closedActivities, 0, result, openActivities.length, closedActivities.length);
            System.arraycopy(emptyActivities, 0, result, openActivities.length + closedActivities.length, emptyActivities.length);
            return this.sortActivityByDate(result);
        }
        catch (VfsException unknownProblem) {
            Logbook.getErrorChapter().println(unknownProblem.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)unknownProblem);
            return EmptyTreeContentProvider.getEmptyChildren();
        }
    }

    private Object[] sortActivityByDate(Object[] activities) {
        if (activities == null) {
            Logbook.getWarnChapter().println("Activities in sortActivityByDate is <null>.");
            Logbook.getWarnChapter().flush();
            return activities;
        }
        Arrays.sort(activities, new Comparator(){

            public int compare(Object act1, Object act2) {
                if (act1 instanceof IVfsActivity) {
                    IVfsActivity first = (IVfsActivity)act1;
                    IVfsActivity second = (IVfsActivity)act2;
                    if (second == null) {
                        Logbook.getWarnChapter().println("Second argument in sortActivityByDate.compare is <null>.");
                        Logbook.getWarnChapter().flush();
                        return 1;
                    }
                }
                if (act1 == null || act2 == null) {
                    Logbook.getWarnChapter().println("Argument in sortActivityByDate.compare is <null>.");
                    Logbook.getWarnChapter().flush();
                    throw new IllegalStateException("Can't compare <null> arguments.");
                }
                Date d1 = null;
                Date d2 = null;
                try {
                    d1 = ((IVfsActivity)act1).getCheckedInDate();
                    if (d1 == null) {
                        d1 = ((IVfsActivity)act1).getCreationDate();
                    }
                    if ((d2 = ((IVfsActivity)act2).getCheckedInDate()) == null) {
                        d2 = ((IVfsActivity)act2).getCreationDate();
                    }
                }
                catch (VfsException x) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
                if (d1 == null || d2 == null) {
                    Logbook.getWarnChapter().println("Argument's toString in sortActivityByDate.compare is <null>.");
                    Logbook.getWarnChapter().flush();
                    throw new IllegalStateException("Can't compare <null> toString'ed arguments.");
                }
                return -d1.compareTo(d2);
            }
        });
        return activities;
    }

    private Object[] sortActivityByName(Object[] activities) {
        if (activities == null) {
            Logbook.getWarnChapter().println("Activities in sortActivityByName is <null>.");
            Logbook.getWarnChapter().flush();
            return activities;
        }
        Arrays.sort(activities, new Comparator(){

            public int compare(Object act1, Object act2) {
                if (act1 == null || act2 == null) {
                    Logbook.getWarnChapter().println("Argument in sortActivityByName.compare is <null>.");
                    Logbook.getWarnChapter().flush();
                    throw new IllegalStateException("Can't compare <null> arguments.");
                }
                if (act1 instanceof IVfsActivity) {
                    IVfsActivity first = (IVfsActivity)act1;
                    IVfsActivity second = (IVfsActivity)act2;
                    if (second == null) {
                        Logbook.getWarnChapter().println("Second argument in sortActivityByName.compare is <null>.");
                        Logbook.getWarnChapter().flush();
                        return 1;
                    }
                }
                String n1 = null;
                String n2 = null;
                try {
                    n1 = ((IVfsActivity)act1).getDisplayName();
                    n2 = ((IVfsActivity)act2).getDisplayName();
                }
                catch (VfsException x) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
                if (n1 == null || n2 == null) {
                    Logbook.getWarnChapter().println("Argument's toString in sortActivityByName.compare is <null>.");
                    Logbook.getWarnChapter().flush();
                    throw new IllegalStateException("Can't compare <null> toString'ed arguments.");
                }
                return n1.compareTo(n2);
            }
        });
        return activities;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

