/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser;

import com.tssap.dtr.client.lib.util.Logbook;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ViewConfigurationRegistry {
    private static final String CONFIGURATION_EXTENSION_POINT = "com.tssap.dtr.client.eclipse.viewConfiguration";
    private static final String VIEW_ELEMENT = "view";
    private static final String VIEW_ID_ATTRIBUTE = "id";
    private Map myViewConfigurations = null;

    public IConfigurationElement getViewConfiguration(String viewID) {
        this.loadViews();
        if (this.myViewConfigurations.containsKey(viewID)) {
            return (IConfigurationElement)this.myViewConfigurations.get(viewID);
        }
        return null;
    }

    private void loadViews() {
        if (this.myViewConfigurations != null) {
            return;
        }
        this.myViewConfigurations = new HashMap();
        IConfigurationElement[] configurations = Platform.getPluginRegistry().getConfigurationElementsFor(CONFIGURATION_EXTENSION_POINT);
        int i = 0;
        while (i < configurations.length) {
            if (VIEW_ELEMENT.equals(configurations[i].getName())) {
                String viewID = configurations[i].getAttribute(VIEW_ID_ATTRIBUTE);
                if (viewID != null && !viewID.equals("")) {
                    this.myViewConfigurations.put(viewID, configurations[i]);
                } else {
                    Logbook.getErrorChapter().println("Incorrect <view /> element specified: this element has no \"id\" attribute.");
                }
            }
            ++i;
        }
    }
}

