/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser;

import com.tssap.dtr.client.eclipse.ui.treeBrowser.VFSAdaptableWrapper;
import com.tssap.dtr.client.lib.util.Logbook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class VFSAdaptableSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    private Collection myListeners = new HashSet();
    private ISelection mySelection;

    public VFSAdaptableSelectionProvider(ISelectionProvider original) {
        original.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public synchronized void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.myListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.mySelection;
    }

    public synchronized void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.myListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        Logbook.getErrorChapter().println("setSelection() method was called from VFSAdaptableSelectionProvider this is an exceptional situation - this method is not implemented.");
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.myListeners.isEmpty()) {
            return;
        }
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            ArrayList<VFSAdaptableWrapper> selectedElements = new ArrayList<VFSAdaptableWrapper>();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                selectedElements.add(new VFSAdaptableWrapper(it.next()));
            }
            this.mySelection = new StructuredSelection(selectedElements.toArray());
        } else {
            this.mySelection = new StructuredSelection(new Object[0]);
        }
        this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, this.mySelection));
    }

    private void fireSelectionChangedEvent(SelectionChangedEvent event) {
        ISelectionChangedListener[] listeners;
        VFSAdaptableSelectionProvider vFSAdaptableSelectionProvider = this;
        synchronized (vFSAdaptableSelectionProvider) {
            listeners = this.myListeners.toArray(new ISelectionChangedListener[this.myListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].selectionChanged(event);
            ++i;
        }
    }
}

