/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.JointContentProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.JointLabelProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.JointProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.PluggableProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.TreeInputProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.inputProviders.LogicalRootInputProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class TreeProvidersRegistry {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$TreeProvidersRegistry == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$TreeProvidersRegistry = TreeProvidersRegistry.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.TreeProvidersRegistry")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$TreeProvidersRegistry));
    private static final String CONTENT_PROVIDER_ELEMENT = "contentProvider";
    private static final String LABEL_PROVIDER_ELEMENT = "labelProvider";
    private static final String INPUT_PROVIDER_ELEMENT = "inputProvider";
    private static final String CLASS_ATTRIBUTE = "class";
    private JointContentProvider myTreeContentProvider = null;
    private JointLabelProvider myLabelProvider = null;
    private TreeInputProvider myInputProvider = null;
    private Collection myPluggableProviders = new ArrayList();
    private String myViewId;
    private IConfigurationElement myConfig = null;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$TreeProvidersRegistry;
    static /* synthetic */ Class class$org$eclipse$jface$viewers$ILabelProvider;
    static /* synthetic */ Class class$org$eclipse$jface$viewers$ITreeContentProvider;

    public TreeProvidersRegistry(String viewId) {
        this.myViewId = viewId;
    }

    public ITreeContentProvider getTreeContentProvider() {
        return this.getJointContentProvider();
    }

    public void addInputChangeListener(IContentProvider listener) {
        this.getJointContentProvider().addInputChangeListener(listener);
    }

    public void removeInputChangeListener(IContentProvider listener) {
        this.getJointContentProvider().removeInputChangeListener(listener);
    }

    public ILabelProvider getLabelProvider() {
        if (this.myLabelProvider == null) {
            this.myLabelProvider = new JointLabelProvider();
            this.registerAllProviders(this.myLabelProvider, LABEL_PROVIDER_ELEMENT, class$org$eclipse$jface$viewers$ILabelProvider == null ? (class$org$eclipse$jface$viewers$ILabelProvider = TreeProvidersRegistry.class$("org.eclipse.jface.viewers.ILabelProvider")) : class$org$eclipse$jface$viewers$ILabelProvider);
        }
        return this.myLabelProvider;
    }

    public void setInputProvider(TreeInputProvider inputProvider) {
        this.myInputProvider = inputProvider;
    }

    public TreeInputProvider getInputProvider() {
        if (this.myInputProvider == null) {
            IConfigurationElement config = this.getConfigurationElement();
            if (config == null) {
                Logbook.getErrorChapter().println("There is no configuration found for " + this.myViewId + " view. Empty TreeInput provider will be used.");
            } else {
                IConfigurationElement[] elements = config.getChildren(INPUT_PROVIDER_ELEMENT);
                int i = 0;
                while (i < elements.length) {
                    Object nextProvider = this.createExtension(elements[i], config);
                    if (nextProvider instanceof TreeInputProvider) {
                        if (this.myInputProvider == null) {
                            this.myInputProvider = (TreeInputProvider)nextProvider;
                        } else {
                            Logbook.getErrorChapter().println("Only one input provider allowed in the configuration of view (" + this.myViewId + "). First one will be used.");
                        }
                    } else {
                        Logbook.getErrorChapter().println("Input provider: (" + nextProvider.getClass() + "), specified in the configuration of: " + this.myViewId + " extension point is not instance of TreeInputProvider interface.");
                    }
                    ++i;
                }
                if (this.myInputProvider == null) {
                    Logbook.getErrorChapter().println("There is no TreeInputProviders specified in the configuration of " + this.myViewId + " view. Default one will be used.");
                }
            }
            if (this.myInputProvider == null) {
                this.myInputProvider = new LogicalRootInputProvider();
            }
        }
        return this.myInputProvider;
    }

    public PluggableProvider[] getPluggableProviders() {
        this.getTreeContentProvider();
        this.getLabelProvider();
        return this.myPluggableProviders.toArray(new PluggableProvider[this.myPluggableProviders.size()]);
    }

    private JointContentProvider getJointContentProvider() {
        if (this.myTreeContentProvider == null) {
            this.myTreeContentProvider = new JointContentProvider();
            this.registerAllProviders(this.myTreeContentProvider, CONTENT_PROVIDER_ELEMENT, class$org$eclipse$jface$viewers$ITreeContentProvider == null ? (class$org$eclipse$jface$viewers$ITreeContentProvider = TreeProvidersRegistry.class$("org.eclipse.jface.viewers.ITreeContentProvider")) : class$org$eclipse$jface$viewers$ITreeContentProvider);
        }
        return this.myTreeContentProvider;
    }

    private void registerAllProviders(JointProvider jointProvider, String elementName, Class providerClass) {
        IConfigurationElement config = this.getConfigurationElement();
        if (config == null) {
            return;
        }
        IConfigurationElement[] children = config.getChildren(elementName);
        int i = 0;
        while (i < children.length) {
            Object nextProvider = this.createExtension(children[i], config);
            if (nextProvider instanceof PluggableProvider) {
                this.addPluggableProvider((PluggableProvider)nextProvider);
            }
            if (!providerClass.isInstance(nextProvider)) {
                Logbook.getErrorChapter().println("Provider " + elementName + " (" + nextProvider.getClass() + "), specified in the configuration of: " + this.myViewId + " extension point is not instance of " + providerClass.getName() + ".");
            } else {
                jointProvider.registerProvider(nextProvider);
            }
            ++i;
        }
    }

    private void addPluggableProvider(PluggableProvider provider) {
        this.myPluggableProviders.add(provider);
    }

    private Object createExtension(IConfigurationElement configuration, IConfigurationElement parentConfig) {
        try {
            Object extension = configuration.createExecutableExtension(CLASS_ATTRIBUTE);
            if (extension instanceof IExecutableExtension) {
                ((IExecutableExtension)extension).setInitializationData(configuration, CLASS_ATTRIBUTE, (Object)parentConfig);
            }
            return extension;
        }
        catch (CoreException instantiationError) {
            Logbook.getErrorChapter().println("Unable to instantiate specified extension: " + configuration.getAttribute(CLASS_ATTRIBUTE));
            LogUtil.logException((Location)LOCATION, (Throwable)instantiationError);
            return null;
        }
    }

    private IConfigurationElement getConfigurationElement() {
        if (this.myConfig == null) {
            this.myConfig = BluebirdPlugin.getViewConfigurationRegistry().getViewConfiguration(this.myViewId);
        }
        return this.myConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

