/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.internal.IIDELoginListener;
import com.tssap.dtr.client.eclipse.internal.RepositoryViewLegendManager;
import com.tssap.dtr.client.eclipse.ui.LegendDialog;
import com.tssap.dtr.client.eclipse.ui.MultipleSelectionMessageDialog;
import com.tssap.dtr.client.eclipse.ui.SearchFolderItemInViewerDialog;
import com.tssap.dtr.client.eclipse.ui.actions.AddFavoriteAction;
import com.tssap.dtr.client.eclipse.ui.actions.CheckoutAndDeleteAction;
import com.tssap.dtr.client.eclipse.ui.actions.DeleteActivityAction;
import com.tssap.dtr.client.eclipse.ui.actions.DeleteSubtreeAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.OfflineModeTreeInput;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.PluggableProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryTreeViewer;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.VFSAdaptableSelectionProvider;
import com.tssap.dtr.client.eclipse.ui.util.ConcreteCompositeImageDescriptor;
import com.tssap.dtr.client.eclipse.ui.util.ImageDescriptorSingletone;
import com.tssap.dtr.client.eclipse.ui.util.RefreshLogic;
import com.tssap.dtr.client.eclipse.ui.util.RepositoryBrowseFavorite;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsManagerListener;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IConfigurationListener;
import java.security.KeyStore;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class RepositoryView
extends ViewPart
implements IShowInTarget,
IVfsManagerListener,
IConfigurationListener,
IIDELoginListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$RepositoryView == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$RepositoryView = RepositoryView.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$RepositoryView));
    private static final String REFRESH_ACTION_ICON_ATTRIBUTE = "refreshButtonIcon";
    private static final String REFRESH_ACTION_TOOLTIP_ATTRIBUTE = "refreshButtonTooltip";
    private static final String REFRESH_ACTION_TOOLTIP_DEFAULT = "Refresh";
    private static final String REFRESH_ACTION_ICON_DEFAULT = "refresh.gif";
    private static final String VIEW_ID_KEY = "id";
    private static final String VIEW_TITLE_SEPARATOR_CLIENT = " - ";
    private static final String VIEW_TITLE_SEPARATOR_USER_BEGIN = " [";
    private static final String VIEW_TITLE_SEPARATOR_USER_END = "]";
    private static final String VIEW_TITLE_PART_ALL_USERS = "All Users";
    private static final String MENU_LABEL_ADD_FAVORITE = "Add Favorite...";
    private static final String MENU_LABEL_GOTO_FAVORITE = "Go to Favorite";
    private static final String MENU_LABEL_DELETE_FAVORITE = "Delete Favorite";
    private static final String MENU_LABEL_FIND_BY_PATH = "Navigate by Path...";
    private static final String MENU_LABEL_VIEW_FOR_ANOTHER_USER = "Another User...";
    private static final String MENU_LABEL_SET_WORKSPACE_FILTER = "Workspace Filter...";
    private static final String MENU_LABEL_SORT_ASCENDING = "Ascending";
    private static final String MENU_LABEL_SORT_DESCENDING = "Descending";
    private static final String MENU_LABEL_SHOW_LEGEND = "Display Legend";
    private static final String IMAGE_NAME_FAVORITE = "favorite.gif";
    private static final String IMAGE_NAME_SEARCH = "search.gif";
    private static final String IMAGE_NAME_WSFILTER = "ws_filters.gif";
    private static final String IMAGE_NAME_LEGEND = "showlegend.gif";
    private static final String DIALOG_TITLE_WORKSPACE_FILTER = "Workspace Filter";
    private static final String DIALOG_MESSAGE_WORKSPACE_FILTER = "Select the workspaces to view";
    private static final ImageDescriptorSingletone DECORATOR_ALL_USERS = new ImageDescriptorSingletone("allusers.gif");
    private static final ImageDescriptorSingletone DECORATOR_OTHER_USER = new ImageDescriptorSingletone("otheruser.gif");
    private static final ImageDescriptorSingletone DECORATOR_DATE_RANGE = new ImageDescriptorSingletone("daterange.gif");
    private String m_viewId;
    private String m_viewType;
    private RepositoryTreeViewer m_repositoryViewer;
    private Composite m_parent;
    private Image m_defaultViewTitleImage;
    private IAction m_refreshAction;
    private Boolean m_favoritesMenuVisible = null;
    private Boolean m_userMenuVisible = null;
    private Boolean m_dateMenuVisible = null;
    private Boolean m_sortMenuVisible = null;
    private Boolean m_wsFilterMenuVisible = null;
    private Boolean m_legendMenuVisible = null;
    private RepositoryViewLegendManager m_legendManager;
    private String m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$RepositoryView;

    public RepositoryView() {
        IPreferenceStore preferenceStore = BluebirdPlugin.getDefault().getPreferenceStore();
        if (preferenceStore != null) {
            preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("showProjectDecorator".equals(event.getProperty())) {
                        RepositoryView.this.getRepositoryTreeViewer().refresh();
                    }
                }
            });
        }
    }

    public void createPartControl(Composite parent) {
        this.m_parent = parent;
        Composite composite = this.createNewPanel(parent);
        this.m_repositoryViewer.createControl(composite);
        this.m_repositoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    RepositoryView.this.clearStatusLine();
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof IVfsFolderItem) {
                        IVfsFile file = ((IVfsFolderItem)element).asFile();
                        IVfsFolder folder = ((IVfsFolderItem)element).asFolder();
                        if (file != null) {
                            if (file.hasLocalRemoteNameClash()) {
                                if (file.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                                    RepositoryView.this.showErrorMessage("\"" + file.getName() + "\" has a name clash between local existing file and resource in repository! Revert file and rename or delete local file.");
                                } else {
                                    RepositoryView.this.showErrorMessage("\"" + file.getName() + "\" has a name clash between local existing file and resource in repository! Rename or delete local file.");
                                }
                                return;
                            }
                            if (file.wasManuallySetWritable()) {
                                RepositoryView.this.showErrorMessage("\"" + file.getName() + "\" has been manually set to writable. Save changed content, reset file to read-only, remove it and sync again.");
                                return;
                            }
                            if (file.isInconsistent()) {
                                RepositoryView.this.showErrorMessage("\"" + file.getName() + "\" No MountPoint for checked-out file. Please create a MountPoint for the remote resource.");
                                return;
                            }
                        }
                        if (folder != null && folder.isInconsistent()) {
                            RepositoryView.this.showErrorMessage("\"" + folder.getName() + "\" No MountPoint for checked-out folder. Please create a MountPoint for the remote resource.");
                            return;
                        }
                        String msg = ((IVfsFolderItem)element).getCategory().toString();
                        msg = msg.concat(RepositoryView.VIEW_TITLE_SEPARATOR_CLIENT).concat(((IVfsFolderItem)element).getName());
                        if (element instanceof IVfsFile) {
                            try {
                                long length = ((IVfsFile)element).getLength();
                                String byteStr = length > 1L ? "bytes" : "byte";
                                msg = msg + " (" + length + " " + byteStr + ")";
                            }
                            catch (VfsException x) {
                                RepositoryView.this.showErrorMessage(x.getMessage());
                                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                            }
                        }
                        RepositoryView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
                    }
                }
            }
        });
        this.addKeyListener();
        this.getSite().registerContextMenu(this.m_repositoryViewer.getMenuManager(), (ISelectionProvider)this.m_repositoryViewer.getTreeViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)new VFSAdaptableSelectionProvider((ISelectionProvider)this.m_repositoryViewer.getTreeViewer()));
        this.createToolbar();
        this.createMenu();
        this.setDefaultViewTitleImage(this.getTitleImage());
        this.updateViewTitle();
        this.updateViewTitleImage();
        this.registerListeners();
    }

    private void registerListeners() {
        Configuration.getConfiguration().addConfigurationListener((IConfigurationListener)this);
        VersionedFileSystemFactory.addVfsManagerListener((IVfsManagerListener)this);
        if (VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
            VfsManagerProvider.getInstance().addIDELoginListener(this);
        }
    }

    public void setFocus() {
        this.getRepositoryTreeViewer().getTreeViewer().getTree().setFocus();
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        this.m_viewType = cfig.getAttribute("type").trim().toUpperCase();
        this.m_viewId = cfig.getAttribute(VIEW_ID_KEY);
        if (this.m_viewId == null || this.m_viewId.equals("")) {
            throw new RuntimeException("No \"id\" attribute specified in view configuration.");
        }
        this.m_repositoryViewer = new RepositoryTreeViewer(this.m_viewId, this.getConfigurationElement());
    }

    public void dispose() {
        Configuration.getConfiguration().removeConfigurationListener((IConfigurationListener)this);
        VersionedFileSystemFactory.removeVfsManagerListener((IVfsManagerListener)this);
        if (VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
            VfsManagerProvider.getInstance().removeIDELoginListener(this);
        }
        if (this.isUserMenuVisible()) {
            this.getPreferenceStore().setValue(this.getViewID() + "_viewForUser", "");
        }
        if (this.isDateRangeMenuVisible()) {
            this.getPreferenceStore().setValue(this.getViewID() + "_dateRange", "");
        }
        super.dispose();
    }

    public RepositoryTreeViewer getRepositoryTreeViewer() {
        return this.m_repositoryViewer;
    }

    private void createToolbar() {
        String imagePath;
        String refreshTooltip;
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        PluggableProvider[] providers = this.m_repositoryViewer.getPluggableProviders();
        int i = 0;
        while (i < providers.length) {
            final PluggableProvider provider = providers[i];
            Action nextAction = new Action(){
                private ImageDescriptor myImageDescriptor = null;
                private String myTooltip = null;

                public void setChecked(boolean value) {
                    super.setChecked(value);
                    provider.plugProvider(this.isChecked());
                    RepositoryView.this.m_repositoryViewer.refresh();
                }

                public ImageDescriptor getImageDescriptor() {
                    if (this.myImageDescriptor == null) {
                        this.myImageDescriptor = provider.getImageDescriptor();
                        if (this.myImageDescriptor == null) {
                            this.myImageDescriptor = super.getImageDescriptor();
                        }
                    }
                    return this.myImageDescriptor;
                }

                public String getToolTipText() {
                    if (this.myTooltip == null) {
                        this.myTooltip = provider.getToolTip();
                    }
                    return this.myTooltip;
                }
            };
            nextAction.setChecked(true);
            toolbarManager.add((IAction)nextAction);
            ++i;
        }
        IConfigurationElement config = BluebirdPlugin.getViewConfigurationRegistry().getViewConfiguration(this.m_viewId);
        String string = refreshTooltip = config != null ? config.getAttribute(REFRESH_ACTION_TOOLTIP_ATTRIBUTE) : "";
        if (refreshTooltip == null || "".equals(refreshTooltip)) {
            refreshTooltip = REFRESH_ACTION_TOOLTIP_DEFAULT;
        }
        String string2 = imagePath = config != null ? config.getAttribute(REFRESH_ACTION_ICON_ATTRIBUTE) : REFRESH_ACTION_ICON_DEFAULT;
        if (imagePath == null || "".equals(imagePath)) {
            imagePath = REFRESH_ACTION_ICON_DEFAULT;
        }
        final ImageDescriptor refreshImage = BluebirdPlugin.getDefault().createImageDescriptor(imagePath);
        final String processedTooltip = refreshTooltip + "   [F5]";
        this.m_refreshAction = new Action(){

            public void run() {
                RepositoryView.this.clearStatusLine();
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Object isInput = RepositoryView.access$300(4.access$400(this.this$1)).getTreeViewer().getInput();
                        IClient activeClient = Configuration.getConfiguration().getActiveClient();
                        IVersionedFileSystemManager shouldInput = RepositoryView.access$500(4.access$400(this.this$1), activeClient);
                        if (shouldInput == null) {
                            RepositoryView.access$300(4.access$400(this.this$1)).getTreeViewer().setInput((Object)new OfflineModeTreeInput());
                            return;
                        }
                        if (isInput != null && isInput.equals(shouldInput)) {
                            if (RepositoryView.access$600(4.access$400(this.this$1)).equals("com.tssap.dtr.client.eclipse.ui.treeBrowser.OpenActivityView")) {
                                try {
                                    IVfsRepository[] repositories = RepositoryView.access$700(4.access$400(this.this$1)).getRepositories();
                                    int i = 0;
                                    while (i < repositories.length) {
                                        repositories[i].refreshOpenActivitiesFromRepository();
                                        ++i;
                                    }
                                }
                                catch (VfsException x) {
                                    RepositoryView.access$100(4.access$400(this.this$1), x.getMessage());
                                    LogUtil.logCaughtException((Location)RepositoryView.access$200(), (Throwable)x);
                                }
                                catch (IllegalStateException ex) {
                                    RepositoryView.access$100(4.access$400(this.this$1), ex.getMessage());
                                    Logbook.getErrorChapter().println(ex.getMessage());
                                }
                            }
                            RefreshLogic.setRefresh(true);
                            RepositoryView.access$300(4.access$400(this.this$1)).refresh();
                            RefreshLogic.setRefresh(false);
                        } else {
                            RepositoryView.access$300(4.access$400(this.this$1)).setInput(shouldInput);
                        }
                    }
                });
            }

            public ImageDescriptor getImageDescriptor() {
                return refreshImage;
            }

            public String getToolTipText() {
                return processedTooltip;
            }

            static /* synthetic */ RepositoryView access$400(4 x0) {
                return x0.RepositoryView.this;
            }
        };
        toolbarManager.add(this.m_refreshAction);
    }

    private boolean isFavoriteMenuVisible() {
        if (this.m_favoritesMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            this.m_favoritesMenuVisible = viewConfiguration == null ? Boolean.FALSE : new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showFavoriteMenu")));
        }
        return this.m_favoritesMenuVisible;
    }

    private boolean isUserMenuVisible() {
        if (this.m_userMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            this.m_userMenuVisible = viewConfiguration == null ? Boolean.FALSE : new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showSwitchUserMenu")));
        }
        return this.m_userMenuVisible;
    }

    private boolean isDateRangeMenuVisible() {
        if (this.m_dateMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            this.m_dateMenuVisible = viewConfiguration == null ? Boolean.FALSE : new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showSetDateRangeMenu")));
        }
        return this.m_dateMenuVisible;
    }

    private boolean isFilterWorkspaceMenuVisible() {
        if (this.m_wsFilterMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            this.m_wsFilterMenuVisible = viewConfiguration == null ? Boolean.FALSE : new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showWorkspaceFilterMenu")));
        }
        return this.m_wsFilterMenuVisible;
    }

    private boolean isSortMenuVisible() {
        if (this.m_sortMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            this.m_sortMenuVisible = viewConfiguration == null ? Boolean.FALSE : new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showSortMenu")));
        }
        return this.m_sortMenuVisible;
    }

    private boolean isShowLegendMenuVisible() {
        if (this.m_legendMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            if (viewConfiguration == null) {
                this.m_legendMenuVisible = Boolean.FALSE;
            } else {
                this.m_legendMenuVisible = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showLegendMenu")));
                if (this.m_legendMenuVisible.booleanValue() && this.getLegendManager() == null) {
                    this.m_legendMenuVisible = new Boolean(false);
                }
            }
        }
        return this.m_legendMenuVisible;
    }

    private RepositoryViewLegendManager getLegendManager() {
        if (this.m_legendManager == null) {
            try {
                Object legendManager;
                IConfigurationElement viewConfiguration = this.getViewConfiguration();
                if (viewConfiguration != null && (legendManager = viewConfiguration.createExecutableExtension("legendManager")) instanceof RepositoryViewLegendManager) {
                    this.m_legendManager = (RepositoryViewLegendManager)legendManager;
                }
            }
            catch (CoreException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        return this.m_legendManager;
    }

    private IConfigurationElement getViewConfiguration() {
        BluebirdPlugin.getDefault();
        return BluebirdPlugin.getViewConfigurationRegistry().getViewConfiguration(this.m_viewId);
    }

    private void createMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        if (this.m_viewType != null && this.m_viewType.equals("FOLDER_ITEM") && this.isFavoriteMenuVisible()) {
            this.createFavoriteMenus(menuManager);
        }
        if (this.m_viewType != null && this.m_viewType.equals("ACTIVITY_CLOSED")) {
            if (this.isUserMenuVisible()) {
                this.createUserMenu(menuManager);
            }
            if (this.isDateRangeMenuVisible()) {
                this.createDateRangeMenu(menuManager);
            }
            if (this.isFilterWorkspaceMenuVisible()) {
                this.createFilterWorkspaceMenu(menuManager);
            }
        }
        if (this.m_viewType != null && (this.m_viewType.equals("ACTIVITY_OPEN") || this.m_viewType.equals("ACTIVITY_CLOSED")) && this.isSortMenuVisible()) {
            if (menuManager.getItems() != null && menuManager.getItems().length > 0) {
                menuManager.add((IContributionItem)new Separator());
            }
            this.createSortMenus(menuManager);
        }
        if (this.m_viewType != null && this.m_viewType.equals("VERSION")) {
            if (this.isUserMenuVisible()) {
                this.createUserMenuForCollisionView(menuManager);
            }
            if (this.isFilterWorkspaceMenuVisible()) {
                this.createFilterWorkspaceMenu(menuManager);
            }
        }
        if (this.isShowLegendMenuVisible()) {
            this.createShowLegendMenu(menuManager);
        }
    }

    private void createUserMenuForCollisionView(IMenuManager mainMenuManager) {
        MenuManager userMenu = new MenuManager("User Filter");
        mainMenuManager.add((IContributionItem)userMenu);
        Action actViewMy = new Action("Current User"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_viewForUser", "");
                RepositoryView.this.updateRepositoryTree(false);
                RepositoryView.this.updateViewHeaderForUserFilterChanged("");
            }
        };
        actViewMy.setChecked(false);
        Action actViewAll = new Action(VIEW_TITLE_PART_ALL_USERS){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_viewForUser", "*");
                RepositoryView.this.updateRepositoryTree(false);
                RepositoryView.this.updateViewHeaderForUserFilterChanged("*");
            }
        };
        actViewAll.setChecked(false);
        userMenu.add((IAction)actViewMy);
        userMenu.add((IAction)actViewAll);
        userMenu.addMenuListener(new IMenuListener((IAction)actViewMy, (IAction)actViewAll){
            private final /* synthetic */ IAction val$actViewMy;
            private final /* synthetic */ IAction val$actViewAll;
            {
                this.val$actViewMy = val$actViewMy;
                this.val$actViewAll = val$actViewAll;
            }

            public void menuAboutToShow(IMenuManager manager) {
                String user = RepositoryView.this.getUserFromPreferenceStrore();
                this.val$actViewMy.setChecked(user.equals(""));
                this.val$actViewAll.setChecked(user.equals("*"));
            }
        });
    }

    private void createFavoriteMenus(IMenuManager mainMenuManager) {
        Action addFavoriteAction = new Action(MENU_LABEL_ADD_FAVORITE){

            public ImageDescriptor getImageDescriptor() {
                return BluebirdPlugin.getDefault().createImageDescriptor(RepositoryView.IMAGE_NAME_FAVORITE);
            }

            public void run() {
                RepositoryView.this.clearStatusLine();
                AddFavoriteAction action = new AddFavoriteAction();
                action.setActivePart((IAction)this, (IWorkbenchPart)RepositoryView.this);
                action.selectionChanged((IAction)this, RepositoryView.this.getRepositoryTreeViewer().getTreeViewer().getSelection());
                action.run((IAction)this);
                super.run();
            }
        };
        mainMenuManager.add((IAction)addFavoriteAction);
        MenuManager gotoMenu = new MenuManager(MENU_LABEL_GOTO_FAVORITE);
        MenuManager deleteMenu = new MenuManager(MENU_LABEL_DELETE_FAVORITE);
        mainMenuManager.add((IContributionItem)gotoMenu);
        mainMenuManager.add((IContributionItem)deleteMenu);
        mainMenuManager.add((IContributionItem)new Separator());
        Action findAction = new Action(MENU_LABEL_FIND_BY_PATH){

            public ImageDescriptor getImageDescriptor() {
                return BluebirdPlugin.getDefault().createImageDescriptor(RepositoryView.IMAGE_NAME_SEARCH);
            }

            public void run() {
                RepositoryView.this.clearStatusLine();
                new SearchFolderItemInViewerDialog(RepositoryView.this.m_parent.getShell(), (StructuredViewer)RepositoryView.this.getRepositoryTreeViewer().getTreeViewer(), RepositoryView.this.getCurrentVfsManager().getCurrentContext()).open();
            }
        };
        mainMenuManager.add((IAction)findAction);
        mainMenuManager.addMenuListener(new IMenuListener((IAction)addFavoriteAction, (IMenuManager)gotoMenu, (IMenuManager)deleteMenu, (IAction)findAction){
            private final /* synthetic */ IAction val$addFavoriteAction;
            private final /* synthetic */ IMenuManager val$gotoMenu;
            private final /* synthetic */ IMenuManager val$deleteMenu;
            private final /* synthetic */ IAction val$findAction;
            {
                this.val$addFavoriteAction = val$addFavoriteAction;
                this.val$gotoMenu = val$gotoMenu;
                this.val$deleteMenu = val$deleteMenu;
                this.val$findAction = val$findAction;
            }

            public void menuAboutToShow(IMenuManager menuManager) {
                if (RepositoryView.this.getCurrentVfsManager() != null) {
                    boolean oneItemSelected = false;
                    ISelection selection = RepositoryView.this.getRepositoryTreeViewer().getTreeViewer().getSelection();
                    if (selection instanceof IStructuredSelection) {
                        oneItemSelected = ((IStructuredSelection)selection).size() == 1;
                    }
                    this.val$addFavoriteAction.setEnabled(oneItemSelected);
                    this.val$gotoMenu.removeAll();
                    this.val$deleteMenu.removeAll();
                    TreeMap favorites = RepositoryBrowseFavorite.getFavoritesForClientdef(RepositoryView.this.getActiveClientName());
                    if (favorites.size() > 0) {
                        RepositoryView.this.createGotoDeleteFavoritesMenus(this.val$gotoMenu, this.val$deleteMenu, favorites);
                    }
                    this.val$findAction.setEnabled(true);
                } else {
                    this.val$addFavoriteAction.setEnabled(false);
                    this.val$findAction.setEnabled(false);
                }
            }
        });
    }

    private void createGotoDeleteFavoritesMenus(IMenuManager gotoMenu, IMenuManager deleteMenu, Map favorites) {
        Iterator iterator = favorites.keySet().iterator();
        final String clientdefName = this.getActiveClientName();
        while (iterator.hasNext()) {
            String favorite = (String)iterator.next();
            String actionLabel = (String)favorites.get(favorite);
            final String path = favorite.substring(clientdefName.length() + 1);
            Action action = new Action(actionLabel){

                public void run() {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this){
                        private final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            RepositoryView.access$000(12.access$1500(this.this$1));
                            try {
                                if (RepositoryView.access$700(12.access$1500(this.this$1)) != null && !RepositoryBrowseFavorite.gotoFavorite(12.access$1500(this.this$1).getRepositoryTreeViewer().getTreeViewer(), RepositoryView.access$700(12.access$1500(this.this$1)).getFolderItemByBrowsePath(12.access$1600(this.this$1)))) {
                                    RepositoryView.access$100(12.access$1500(this.this$1), "Could not find \"" + 12.access$1600(this.this$1) + "\".");
                                    MessageDialog errorDialog = new MessageDialog(RepositoryView.access$1200(12.access$1500(this.this$1)).getShell(), "Resource not found", null, "The corresponding resource \"" + 12.access$1600(this.this$1) + "\" is not longer available." + "\n\n" + "Would you like to delete this favorite?", 1, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                                    if (errorDialog.open() == 0) {
                                        RepositoryBrowseFavorite.deleteFavorite(12.access$1700(this.this$1), 12.access$1600(this.this$1));
                                    }
                                }
                            }
                            catch (VfsException x) {
                                RepositoryView.access$100(12.access$1500(this.this$1), x.getMessage());
                                LogUtil.logCaughtException((Location)RepositoryView.access$200(), (Throwable)x);
                            }
                        }
                    });
                }

                static /* synthetic */ RepositoryView access$1500(12 x0) {
                    return x0.RepositoryView.this;
                }

                static /* synthetic */ String access$1600(12 x0) {
                    return x0.path;
                }

                static /* synthetic */ String access$1700(12 x0) {
                    return x0.clientdefName;
                }
            };
            gotoMenu.add((IAction)action);
            action = new Action(actionLabel){

                public void run() {
                    RepositoryView.this.clearStatusLine();
                    RepositoryBrowseFavorite.deleteFavorite(clientdefName, path);
                }
            };
            deleteMenu.add((IAction)action);
        }
    }

    private void createUserMenu(IMenuManager mainMenuManager) {
        MenuManager userMenu = new MenuManager("User Filter");
        mainMenuManager.add((IContributionItem)userMenu);
        Action actViewMy = new Action("Current User"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_viewForUser", "");
                RepositoryView.this.updateRepositoryTree(false);
                RepositoryView.this.updateViewHeaderForUserFilterChanged("");
            }
        };
        actViewMy.setChecked(false);
        String user = this.getUserFromPreferenceStrore();
        String actLabelViewAnother = !user.equals("") && !user.equals("*") ? user : MENU_LABEL_VIEW_FOR_ANOTHER_USER;
        Action actViewAnother = new Action(actLabelViewAnother){

            public void run() {
                InputDialog dialog = new InputDialog(RepositoryView.this.getSite().getShell(), "View for User...", "Enter a user name:", "< Name >", new IInputValidator(this){
                    private final /* synthetic */ 16 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String isValid(String newText) {
                        if ("".equals(newText)) {
                            return "User name must not be empty.";
                        }
                        return null;
                    }
                });
                if (dialog.open() == 0 && !RepositoryView.this.getUserFromPreferenceStrore().equals(dialog.getValue())) {
                    RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_viewForUser", dialog.getValue());
                    RepositoryView.this.updateRepositoryTree(false);
                    RepositoryView.this.updateViewHeaderForUserFilterChanged(dialog.getValue());
                }
            }
        };
        actViewAnother.setChecked(false);
        Action actViewAll = new Action(VIEW_TITLE_PART_ALL_USERS){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                MessageDialog warnDialog = new MessageDialog(RepositoryView.this.getSite().getShell(), "Show for all Users", null, "This setting will result in a long delay while retrieving data.\n\nAre you sure you want to select this option?", 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                if (warnDialog.open() == 0) {
                    RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_viewForUser", "*");
                    RepositoryView.this.updateRepositoryTree(false);
                    RepositoryView.this.updateViewHeaderForUserFilterChanged("*");
                }
            }
        };
        actViewAll.setChecked(false);
        userMenu.add((IAction)actViewMy);
        userMenu.add((IAction)actViewAnother);
        userMenu.add((IAction)actViewAll);
        userMenu.addMenuListener(new IMenuListener((IAction)actViewAnother, (IAction)actViewMy, (IAction)actViewAll){
            private final /* synthetic */ IAction val$actViewAnother;
            private final /* synthetic */ IAction val$actViewMy;
            private final /* synthetic */ IAction val$actViewAll;
            {
                this.val$actViewAnother = val$actViewAnother;
                this.val$actViewMy = val$actViewMy;
                this.val$actViewAll = val$actViewAll;
            }

            public void menuAboutToShow(IMenuManager manager) {
                String user = RepositoryView.this.getUserFromPreferenceStrore();
                if (!user.equals("") && !user.equals("*")) {
                    this.val$actViewAnother.setText(user);
                } else {
                    this.val$actViewAnother.setText(RepositoryView.MENU_LABEL_VIEW_FOR_ANOTHER_USER);
                }
                this.val$actViewMy.setChecked(user.equals(""));
                this.val$actViewAnother.setChecked(!user.equals("") && !user.equals("*"));
                this.val$actViewAll.setChecked(user.equals("*"));
            }
        });
    }

    private void createDateRangeMenu(IMenuManager mainMenuManager) {
        MenuManager dateRangeMenu = new MenuManager("Date Filter");
        mainMenuManager.add((IContributionItem)dateRangeMenu);
        Action actLastMonth = new Action("Last 2 Weeks"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_dateRange", "");
                RepositoryView.this.updateRepositoryTree(false);
                RepositoryView.this.updateViewTitleImage();
            }
        };
        actLastMonth.setChecked(false);
        Action actUnlimited = new Action("Unlimited"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_dateRange", "*");
                RepositoryView.this.updateRepositoryTree(false);
                RepositoryView.this.updateViewTitleImage();
            }
        };
        actUnlimited.setChecked(false);
        dateRangeMenu.add((IAction)actLastMonth);
        dateRangeMenu.add((IAction)actUnlimited);
        dateRangeMenu.addMenuListener(new IMenuListener((IAction)actLastMonth, (IAction)actUnlimited){
            private final /* synthetic */ IAction val$actLastMonth;
            private final /* synthetic */ IAction val$actUnlimited;
            {
                this.val$actLastMonth = val$actLastMonth;
                this.val$actUnlimited = val$actUnlimited;
            }

            public void menuAboutToShow(IMenuManager manager) {
                String dateRange = RepositoryView.this.getDateRangeFromPreferenceStrore();
                boolean unlimitedDateRange = dateRange.equals("*");
                this.val$actLastMonth.setChecked(!unlimitedDateRange);
                this.val$actUnlimited.setChecked(unlimitedDateRange);
            }
        });
    }

    private void createFilterWorkspaceMenu(IMenuManager mainMenuManager) {
        Action setWsFilterAction = new Action(MENU_LABEL_SET_WORKSPACE_FILTER){
            static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace;

            public ImageDescriptor getImageDescriptor() {
                return BluebirdPlugin.getDefault().createImageDescriptor(RepositoryView.IMAGE_NAME_WSFILTER);
            }

            public void run() {
                if (RepositoryView.this.getCurrentVfsManager() != null) {
                    MultipleSelectionMessageDialog dialog;
                    IVfsWorkspace[] allWorkspaces = RepositoryView.this.getCurrentVfsManager().getWorkspaces();
                    IVfsWorkspace[] lastWorkspaceFilter = new IVfsWorkspace[]{};
                    List ws = Util.restoreWorkspaceFilter(RepositoryView.this.getCurrentVfsManager(), RepositoryView.this.getViewID() + "_selectedWorkspaces-" + RepositoryView.this.getActiveClientName());
                    if (ws != null) {
                        lastWorkspaceFilter = ws.toArray(new IVfsWorkspace[ws.size()]);
                    }
                    if ((dialog = new MultipleSelectionMessageDialog(RepositoryView.this.getSite().getShell(), RepositoryView.DIALOG_TITLE_WORKSPACE_FILTER, RepositoryView.DIALOG_MESSAGE_WORKSPACE_FILTER, 2, (IVfsFolderItem[])allWorkspaces, (IVfsFolderItem[])(lastWorkspaceFilter.length > 0 ? lastWorkspaceFilter : allWorkspaces))).open() == 0) {
                        IStructuredSelection selection = dialog.getReturnedSelection();
                        IVfsWorkspace[] newWorkspaceFilter = (IVfsWorkspace[])Util.getArrayFromIterator(selection.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace = 23.class$("com.tssap.dtr.client.lib.vfs.IVfsWorkspace")) : class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace);
                        if (newWorkspaceFilter.length != allWorkspaces.length) {
                            RepositoryView.this.storeWorkspaceFilter(newWorkspaceFilter);
                            RepositoryView.this.updateRepositoryTree(false);
                        } else if (lastWorkspaceFilter.length > 0) {
                            RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_selectedWorkspaces-" + RepositoryView.this.getActiveClientName(), "");
                            RepositoryView.this.updateRepositoryTree(false);
                        }
                    }
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        mainMenuManager.add((IAction)setWsFilterAction);
        mainMenuManager.addMenuListener(new IMenuListener((IAction)setWsFilterAction){
            private final /* synthetic */ IAction val$setWsFilterAction;
            {
                this.val$setWsFilterAction = val$setWsFilterAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$setWsFilterAction.setEnabled(RepositoryView.this.getCurrentVfsManager() != null);
            }
        });
    }

    private void storeWorkspaceFilter(IVfsWorkspace[] workspaces) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < workspaces.length) {
            try {
                String pattern = workspaces[i].getUrl();
                buf.append(pattern);
                buf.append("\n");
            }
            catch (VfsException x) {
                this.showErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
            ++i;
        }
        this.getPreferenceStore().setValue(this.getViewID() + "_selectedWorkspaces-" + this.getActiveClientName(), buf.toString());
    }

    private void createSortMenus(IMenuManager mainMenuManager) {
        MenuManager sortActivityMenu = new MenuManager("Sort Activities");
        mainMenuManager.add((IContributionItem)sortActivityMenu);
        String sortByDateLabel = this.m_viewType.equals("ACTIVITY_OPEN") ? "by Creation Date" : "by Checkin Date";
        Action actSortActivityByDate = new Action(sortByDateLabel){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_sortActivityByName", !this.isChecked());
                RepositoryView.this.updateRepositoryTree(false);
            }
        };
        actSortActivityByDate.setChecked(false);
        Action actSortActivityByName = new Action("by Name"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_sortActivityByName", this.isChecked());
                RepositoryView.this.updateRepositoryTree(false);
            }
        };
        actSortActivityByName.setChecked(false);
        Action actSortActivityAscending = new Action(MENU_LABEL_SORT_ASCENDING){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_sortActivityAscending", this.isChecked());
                RepositoryView.this.updateRepositoryTree(false);
            }
        };
        actSortActivityAscending.setChecked(false);
        Action actSortActivityDescending = new Action(MENU_LABEL_SORT_DESCENDING){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_sortActivityAscending", !this.isChecked());
                RepositoryView.this.updateRepositoryTree(false);
            }
        };
        actSortActivityDescending.setChecked(false);
        sortActivityMenu.add((IAction)actSortActivityByDate);
        sortActivityMenu.add((IAction)actSortActivityByName);
        sortActivityMenu.add((IContributionItem)new Separator());
        sortActivityMenu.add((IAction)actSortActivityAscending);
        sortActivityMenu.add((IAction)actSortActivityDescending);
        sortActivityMenu.addMenuListener(new IMenuListener((IAction)actSortActivityByDate, (IAction)actSortActivityByName, (IAction)actSortActivityAscending, (IAction)actSortActivityDescending){
            private final /* synthetic */ IAction val$actSortActivityByDate;
            private final /* synthetic */ IAction val$actSortActivityByName;
            private final /* synthetic */ IAction val$actSortActivityAscending;
            private final /* synthetic */ IAction val$actSortActivityDescending;
            {
                this.val$actSortActivityByDate = val$actSortActivityByDate;
                this.val$actSortActivityByName = val$actSortActivityByName;
                this.val$actSortActivityAscending = val$actSortActivityAscending;
                this.val$actSortActivityDescending = val$actSortActivityDescending;
            }

            public void menuAboutToShow(IMenuManager manager) {
                boolean sortByName = RepositoryView.this.isActivitySortedByName();
                boolean sortAscending = RepositoryView.this.isActivityAscendingSorted();
                this.val$actSortActivityByDate.setChecked(!sortByName);
                this.val$actSortActivityByName.setChecked(sortByName);
                this.val$actSortActivityAscending.setChecked(sortAscending);
                this.val$actSortActivityDescending.setChecked(!sortAscending);
            }
        });
        MenuManager sortElementMenu = new MenuManager("Sort Activity Elements");
        mainMenuManager.add((IContributionItem)sortElementMenu);
        Action actSortElementByPath = new Action("by Path"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_sortElementByName", !this.isChecked());
                RepositoryView.this.updateRepositoryTree(true);
            }
        };
        actSortElementByPath.setChecked(false);
        Action actSortElementByName = new Action("by Name"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_sortElementByName", this.isChecked());
                RepositoryView.this.updateRepositoryTree(true);
            }
        };
        actSortElementByName.setChecked(false);
        Action actSortElementAscending = new Action(MENU_LABEL_SORT_ASCENDING){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_sortElementDescending", !this.isChecked());
                RepositoryView.this.updateRepositoryTree(false);
            }
        };
        actSortElementAscending.setChecked(false);
        Action actSortElementDescending = new Action(MENU_LABEL_SORT_DESCENDING){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                RepositoryView.this.getPreferenceStore().setValue(RepositoryView.this.getViewID() + "_sortElementDescending", this.isChecked());
                RepositoryView.this.updateRepositoryTree(false);
            }
        };
        actSortElementDescending.setChecked(false);
        sortElementMenu.add((IAction)actSortElementByPath);
        sortElementMenu.add((IAction)actSortElementByName);
        sortElementMenu.add((IContributionItem)new Separator());
        sortElementMenu.add((IAction)actSortElementAscending);
        sortElementMenu.add((IAction)actSortElementDescending);
        sortElementMenu.addMenuListener(new IMenuListener((IAction)actSortElementByPath, (IAction)actSortElementByName, (IAction)actSortElementAscending, (IAction)actSortElementDescending){
            private final /* synthetic */ IAction val$actSortElementByPath;
            private final /* synthetic */ IAction val$actSortElementByName;
            private final /* synthetic */ IAction val$actSortElementAscending;
            private final /* synthetic */ IAction val$actSortElementDescending;
            {
                this.val$actSortElementByPath = val$actSortElementByPath;
                this.val$actSortElementByName = val$actSortElementByName;
                this.val$actSortElementAscending = val$actSortElementAscending;
                this.val$actSortElementDescending = val$actSortElementDescending;
            }

            public void menuAboutToShow(IMenuManager manager) {
                boolean sortByName = RepositoryView.this.isElementSortedByName();
                boolean sortDescending = RepositoryView.this.isElementDescendingSorted();
                this.val$actSortElementByPath.setChecked(!sortByName);
                this.val$actSortElementByName.setChecked(sortByName);
                this.val$actSortElementAscending.setChecked(!sortDescending);
                this.val$actSortElementDescending.setChecked(sortDescending);
            }
        });
    }

    private void createShowLegendMenu(IMenuManager mainMenuManager) {
        IContributionItem[] items = mainMenuManager.getItems();
        if (items != null && items.length > 0) {
            mainMenuManager.add((IContributionItem)new Separator());
        }
        Action actShowLegend = new Action(MENU_LABEL_SHOW_LEGEND){

            public ImageDescriptor getImageDescriptor() {
                return BluebirdPlugin.getDefault().createImageDescriptor(RepositoryView.IMAGE_NAME_LEGEND);
            }

            public void run() {
                new LegendDialog(RepositoryView.this.getSite().getShell(), RepositoryView.this.getLegendManager(), this.getImageDescriptor().createImage(true)).open();
            }
        };
        mainMenuManager.add((IAction)actShowLegend);
    }

    private String getUserFromPreferenceStrore() {
        return this.getPreferenceStore().getString(this.getViewID() + "_viewForUser");
    }

    protected String getDateRangeFromPreferenceStrore() {
        return this.getPreferenceStore().getString(this.getViewID() + "_dateRange");
    }

    protected String getToDateFromPreferenceStrore() {
        return this.getPreferenceStore().getString(this.getViewID() + "_toDate");
    }

    private boolean isActivitySortedByName() {
        return this.getPreferenceStore().getBoolean(this.getViewID() + "_sortActivityByName");
    }

    private boolean isActivityAscendingSorted() {
        return this.getPreferenceStore().getBoolean(this.getViewID() + "_sortActivityAscending");
    }

    private boolean isElementSortedByName() {
        return this.getPreferenceStore().getBoolean(this.getViewID() + "_sortElementByName");
    }

    private boolean isElementDescendingSorted() {
        return this.getPreferenceStore().getBoolean(this.getViewID() + "_sortElementDescending");
    }

    private void updateRepositoryTree(final boolean updateLabel) {
        this.clearStatusLine();
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                RepositoryView.this.getRepositoryTreeViewer().getTreeViewer().refresh(updateLabel);
            }
        });
    }

    private void clearStatusLine() {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(null);
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
    }

    private String getActiveClientName() {
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        if (activeClient != null) {
            return activeClient.getName();
        }
        return null;
    }

    private IVersionedFileSystemManager getCurrentVfsManager() {
        Object currentInput = this.getRepositoryTreeViewer().getTreeViewer().getInput();
        if (!(currentInput instanceof IVersionedFileSystemManager)) {
            return null;
        }
        return (IVersionedFileSystemManager)currentInput;
    }

    private IVersionedFileSystemManager getVfsManager(IClient client) {
        if (client == null) {
            return null;
        }
        try {
            return VfsManagerProvider.getInstance().getVersionedFileSystemManager(client.getContext());
        }
        catch (VfsException x) {
            this.showErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            return null;
        }
    }

    public void onActiveClientChanged(final IClient newClient, IClient oldClient) {
        if (newClient == null) {
            this.getRepositoryTreeViewer().getTreeViewer().setInput((Object)new OfflineModeTreeInput());
            this.updateViewTitle();
            return;
        }
        if (!newClient.equals(oldClient)) {
            this.clearStatusLine();
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    if (RepositoryView.this.getVfsManager(newClient) != null) {
                        RepositoryView.this.getRepositoryTreeViewer().setInput(RepositoryView.this.getVfsManager(newClient));
                    } else {
                        RepositoryView.this.getRepositoryTreeViewer().getTreeViewer().setInput((Object)new OfflineModeTreeInput());
                    }
                    RepositoryView.this.updateViewTitle();
                }
            });
        }
    }

    public void onConfigurationChanged(IConfiguration configuration) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                if (RepositoryView.this.getCurrentVfsManager() != null) {
                    VersionedFileSystemFactory.releaseVersionedFileSystemManager((IVersionedFileSystemManager)RepositoryView.this.getCurrentVfsManager());
                } else {
                    IClient client = Configuration.getConfiguration().getActiveClient();
                    if (client != null) {
                        try {
                            IVersionedFileSystemManager newManager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)client.getContext());
                            RepositoryView.this.m_repositoryViewer.setInput(newManager);
                        }
                        catch (VfsException e) {
                            RepositoryView.this.showErrorMessage(e.getMessage());
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        }
                    }
                    LOCATION.pathT("RepositoryView reacted to configuration-changed event.");
                }
            }
        });
    }

    public void released(final IVersionedFileSystemManager vfsManager) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 39 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        block4: {
                            if (39.access$2600(this.this$1) == null || !39.access$2600(this.this$1).equals(39.access$2700(this.this$1).getRepositoryTreeViewer().getTreeViewer().getInput())) {
                                return;
                            }
                            RepositoryView.access$200().pathT("RepositoryView reacted to VFS-manager-released event.");
                            IClient client = Configuration.getConfiguration().getActiveClient();
                            if (client != null) {
                                try {
                                    IVersionedFileSystemManager newManager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)client.getContext());
                                    RepositoryView.access$300(39.access$2700(this.this$1)).setInput(newManager);
                                    return;
                                }
                                catch (VfsException x) {
                                    RepositoryView.access$100(39.access$2700(this.this$1), x.getMessage());
                                    LogUtil.logCaughtException((Location)RepositoryView.access$200(), (Throwable)x);
                                    if (!x.getCategory().equals(VfsExceptionCategory.PARALLEL_THREAD_ACCESS_DURING_INITIALIZATION_OF_VFS_MANAGER)) break block4;
                                    RepositoryView.access$2802(39.access$2700(this.this$1), client.getName());
                                }
                            }
                        }
                        RepositoryView.access$300(39.access$2700(this.this$1)).getTreeViewer().setInput((Object)new OfflineModeTreeInput());
                    }
                });
            }

            static /* synthetic */ IVersionedFileSystemManager access$2600(39 x0) {
                return x0.vfsManager;
            }

            static /* synthetic */ RepositoryView access$2700(39 x0) {
                return x0.RepositoryView.this;
            }
        });
    }

    public void created(final IVersionedFileSystemManager vfsManager) {
        if (this.m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem != null && this.m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem.equals(vfsManager.getClientName())) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(this){
                        private final /* synthetic */ 41 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            RepositoryView.access$300(41.access$3000(this.this$1)).setInput(41.access$2900(this.this$1));
                        }
                    });
                }

                static /* synthetic */ IVersionedFileSystemManager access$2900(41 x0) {
                    return x0.vfsManager;
                }

                static /* synthetic */ RepositoryView access$3000(41 x0) {
                    return x0.RepositoryView.this;
                }
            });
            this.m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem = null;
        }
    }

    private Composite createNewPanel(Composite parent) {
        Composite out = new Composite(parent, 0);
        out.setLayout((Layout)new FillLayout());
        return out;
    }

    public String getViewID() {
        return this.m_viewId;
    }

    private void showErrorMessage(String message) {
        this.clearStatusLine();
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(Dialog.getImage((String)"dialog_message_error_image"), message);
    }

    private void updateViewTitle() {
        String userName = "";
        String currentUserFilter = this.getUserFromPreferenceStrore();
        if (currentUserFilter.equals("*")) {
            userName = VIEW_TITLE_PART_ALL_USERS;
        } else if (!currentUserFilter.equals("")) {
            userName = currentUserFilter;
        }
        String title = this.getTitle();
        if (title.indexOf(VIEW_TITLE_SEPARATOR_USER_BEGIN) != -1) {
            title = title.substring(0, title.indexOf(VIEW_TITLE_SEPARATOR_USER_BEGIN));
        } else if (title.indexOf(VIEW_TITLE_SEPARATOR_CLIENT) != -1) {
            title = title.substring(0, title.indexOf(VIEW_TITLE_SEPARATOR_CLIENT));
        }
        if (!userName.equals("")) {
            title = title + VIEW_TITLE_SEPARATOR_USER_BEGIN + userName + VIEW_TITLE_SEPARATOR_USER_END;
        }
        if (this.getActiveClientName() != null) {
            title = title + VIEW_TITLE_SEPARATOR_CLIENT + this.getActiveClientName();
        }
        this.setTitle(title);
    }

    private void updateViewTitleImage() {
        ConcreteCompositeImageDescriptor decoratedImageDescriptor;
        String dateRange;
        if (this.getDefaultViewTitleImage() == null) {
            return;
        }
        Image titleImage = this.getDefaultViewTitleImage();
        boolean changed = false;
        if (this.isDateRangeMenuVisible() && !(dateRange = this.getDateRangeFromPreferenceStrore()).equals("*")) {
            decoratedImageDescriptor = new ConcreteCompositeImageDescriptor(titleImage, 5, DECORATOR_DATE_RANGE.getImageDescriptor(), 10);
            titleImage = decoratedImageDescriptor.createImage();
            changed = true;
        }
        if (this.isUserMenuVisible()) {
            String user = this.getUserFromPreferenceStrore();
            if (user.equals("*")) {
                decoratedImageDescriptor = new ConcreteCompositeImageDescriptor(titleImage, changed ? 0 : 5, DECORATOR_ALL_USERS.getImageDescriptor(), 0);
                titleImage = decoratedImageDescriptor.createImage();
            } else if (!user.equals("")) {
                decoratedImageDescriptor = new ConcreteCompositeImageDescriptor(titleImage, changed ? 0 : 5, DECORATOR_OTHER_USER.getImageDescriptor(), 0);
                titleImage = decoratedImageDescriptor.createImage();
            }
        }
        this.setTitleImage(titleImage);
    }

    private void updateViewHeaderForUserFilterChanged(String newUser) {
        if (newUser == null) {
            return;
        }
        this.updateViewTitle();
        this.updateViewTitleImage();
    }

    public void onUserLoggedIn(String[] userAndPassword, KeyStore[] serverAndClientCerts) {
        this.clearStatusLine();
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                IClient activeClient = Configuration.getConfiguration().getActiveClient();
                IVersionedFileSystemManager shouldInput = RepositoryView.this.getVfsManager(activeClient);
                if (shouldInput == null) {
                    RepositoryView.this.m_repositoryViewer.getTreeViewer().setInput((Object)new OfflineModeTreeInput());
                } else {
                    RepositoryView.this.m_repositoryViewer.setInput(shouldInput);
                }
            }
        });
        this.updateViewTitle();
    }

    public void onUserLoggedOut() {
        this.getRepositoryTreeViewer().getTreeViewer().setInput((Object)new OfflineModeTreeInput());
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.m_viewId + VIEW_TITLE_SEPARATOR_USER_END;
    }

    private IPreferenceStore getPreferenceStore() {
        return BluebirdPlugin.getDefault().getPreferenceStore();
    }

    private Image getDefaultViewTitleImage() {
        return this.m_defaultViewTitleImage;
    }

    private void setDefaultViewTitleImage(Image image) {
        this.m_defaultViewTitleImage = image;
    }

    private void addKeyListener() {
        this.getRepositoryTreeViewer().getTreeViewer().getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E && e.stateMask == 0 && RepositoryView.this.m_refreshAction != null) {
                    RepositoryView.this.m_refreshAction.run();
                } else if (e.character == '\u007f' && e.stateMask == 0) {
                    ISelection selection = RepositoryView.this.getRepositoryTreeViewer().getTreeViewer().getSelection();
                    if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
                        return;
                    }
                    Object firstItem = ((IStructuredSelection)selection).getFirstElement();
                    if (firstItem instanceof IVfsFile || firstItem instanceof IVfsFolder || firstItem instanceof IVfsActivity) {
                        Class<?> objectType = firstItem.getClass();
                        Iterator iter = ((IStructuredSelection)selection).iterator();
                        while (iter.hasNext()) {
                            if (iter.next().getClass().equals(objectType)) continue;
                            return;
                        }
                        Action fakeAction = new Action(this){
                            private final /* synthetic */ 44 this$1;
                            {
                                this.this$1 = this$1;
                            }
                        };
                        if (firstItem instanceof IVfsFile) {
                            CheckoutAndDeleteAction deleteFileAction = new CheckoutAndDeleteAction();
                            deleteFileAction.setActivePart((IAction)fakeAction, (IWorkbenchPart)RepositoryView.this);
                            deleteFileAction.selectionChanged((IAction)fakeAction, selection);
                            if (fakeAction.isEnabled()) {
                                deleteFileAction.run((IAction)fakeAction);
                            }
                        } else if (firstItem instanceof IVfsFolder) {
                            IVfsFolderItem[] folderItems = null;
                            try {
                                folderItems = ((IVfsFolder)firstItem).getFolderItems();
                            }
                            catch (VfsException x) {
                                RepositoryView.this.showErrorMessage(x.getMessage());
                                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                            }
                            if (folderItems == null) {
                                return;
                            }
                            if (((IStructuredSelection)selection).size() > 1 || folderItems.length == 0) {
                                CheckoutAndDeleteAction deleteFolderAction = new CheckoutAndDeleteAction();
                                deleteFolderAction.setActivePart((IAction)fakeAction, (IWorkbenchPart)RepositoryView.this);
                                deleteFolderAction.selectionChanged((IAction)fakeAction, selection);
                                if (fakeAction.isEnabled()) {
                                    deleteFolderAction.run((IAction)fakeAction);
                                }
                            } else {
                                DeleteSubtreeAction deleteSubtreeAction = new DeleteSubtreeAction();
                                deleteSubtreeAction.setActivePart((IAction)fakeAction, (IWorkbenchPart)RepositoryView.this);
                                deleteSubtreeAction.selectionChanged((IAction)fakeAction, selection);
                                if (fakeAction.isEnabled()) {
                                    deleteSubtreeAction.run((IAction)fakeAction);
                                }
                            }
                        } else if (firstItem instanceof IVfsActivity) {
                            DeleteActivityAction deleteActivityAction = new DeleteActivityAction();
                            deleteActivityAction.setActivePart((IAction)fakeAction, (IWorkbenchPart)RepositoryView.this);
                            deleteActivityAction.selectionChanged((IAction)fakeAction, selection);
                            if (fakeAction.isEnabled()) {
                                deleteActivityAction.run((IAction)fakeAction);
                            }
                        }
                    }
                }
            }
        });
    }

    public boolean show(ShowInContext context) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$600(RepositoryView x0) {
        return x0.m_viewId;
    }

    static /* synthetic */ String access$2802(RepositoryView x0, String x1) {
        x0.m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem = x1;
        return x0.m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem;
    }
}

